/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.ClassMarshaler;
import com.sun.corba.ee.impl.encoding.fast.ClassMarshalerFactory;
import com.sun.corba.ee.impl.encoding.fast.EmergeCode;
import com.sun.corba.ee.impl.encoding.fast.EmergeCodeFactory;
import com.sun.corba.ee.impl.encoding.fast.LabelManager;
import com.sun.corba.ee.impl.encoding.fast.LookupTable;
import com.sun.corba.ee.impl.encoding.fast.VarOctetUtility;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Writer;
import com.sun.corba.ee.spi.orbutil.generic.Holder;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class OutputStream
extends ObjectOutputStream {
    private static final EmergeCode NULL_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.NULL, null);
    private static final EmergeCode BOOL_ARR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.BOOL_ARR, null);
    private static final EmergeCode BYTE_ARR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.BYTE_ARR, null);
    private static final EmergeCode CHAR_ARR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.CHAR_ARR, null);
    private static final EmergeCode SHORT_ARR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.SHORT_ARR, null);
    private static final EmergeCode INT_ARR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.INT_ARR, null);
    private static final EmergeCode LONG_ARR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.LONG_ARR, null);
    private static final EmergeCode FLOAT_ARR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.FLOAT_ARR, null);
    private static final EmergeCode DOUBLE_ARR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.DOUBLE_ARR, null);
    private static final EmergeCode REF_ARR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.REF_ARR, null);
    private static final EmergeCode REF_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.REF, null);
    private static final EmergeCode DEREF_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.REF, null);
    private static final EmergeCode TUPLE_START_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.TUPLE, (Object)EmergeCode.TupleCode.TUPLE_START);
    private static final EmergeCode TUPLE_END_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.TUPLE, (Object)EmergeCode.TupleCode.TUPLE_END);
    private static final EmergeCode PART_NO_CUSTOM_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.PART, (Object)EmergeCode.PartCode.NO_CUSTOM);
    private static final EmergeCode PART_HAS_CUSTOM_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.PART, (Object)EmergeCode.PartCode.HAS_CUSTOM);
    private static final EmergeCode INDIR_CODE = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.INDIR, null);
    private final Map<Object, Object> replacements;
    private final Queue<Pair<Object, ReferenceWriter>> workQ = new LinkedList<Pair<Object, ReferenceWriter>>();
    private LabelManager labelManager;
    private final Writer writer;
    private final Holder<Boolean> firstTime = new Holder();
    private final Holder<ClassMarshaler> cmHolder = new Holder();
    private boolean insideBody = true;
    private Object currentObject;
    private ClassMarshaler currentClassMarshaler;
    private ReferenceWriter charArrayWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeCharArray((char[])obj);
        }
    };
    private ReferenceWriter booleanArrayWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeBooleanArray((boolean[])obj);
        }
    };
    private ReferenceWriter byteArrayWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeByteArray((byte[])obj);
        }
    };
    private ReferenceWriter shortArrayWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeShortArray((short[])obj);
        }
    };
    private ReferenceWriter intArrayWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeIntArray((int[])obj);
        }
    };
    private ReferenceWriter longArrayWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeLongArray((long[])obj);
        }
    };
    private ReferenceWriter floatArrayWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeFloatArray((float[])obj);
        }
    };
    private ReferenceWriter doubleArrayWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeDoubleArray((double[])obj);
        }
    };
    private ReferenceWriter objectArrayWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeValueArray((Object[])obj);
        }
    };
    private ReferenceWriter objectWriter = new ReferenceWriter(){

        @Override
        public void write(Object obj) throws IOException {
            OutputStream.this.writeObjectOverride(obj);
        }
    };

    void setInsideBody(boolean value) {
        this.insideBody = value;
    }

    public void tupleStart() {
        this.writer.putByte((byte)TUPLE_START_CODE.code());
    }

    public void tupleEnd() {
        this.writer.putByte((byte)TUPLE_END_CODE.code());
    }

    void startValue(Object data, int numClasses) {
        this.writer.putByte((byte)REF_CODE.code());
        LabelManager.Label label = this.getLabel(data, this.objectWriter);
        label.put(this.writer);
        VarOctetUtility.put(this.writer, numClasses);
    }

    void startClass(boolean isCustomMarshaled, char[] typeName, int numFields) {
        if (isCustomMarshaled) {
            this.writer.putByte((byte)PART_HAS_CUSTOM_CODE.code());
        } else {
            this.writer.putByte((byte)PART_NO_CUSTOM_CODE.code());
        }
        this.writer.putCharArray(typeName);
        VarOctetUtility.put(this.writer, 0L);
        VarOctetUtility.put(this.writer, numFields);
    }

    void startCustomPart(Object obj, ClassMarshaler cm) {
        this.tupleStart();
        this.currentObject = obj;
        this.currentClassMarshaler = cm;
    }

    void endCustomPart() {
        this.tupleEnd();
        this.currentObject = null;
        this.currentClassMarshaler = null;
    }

    public OutputStream(Writer writer, LookupTable<Object, LabelManager.Label> extContext) throws IOException {
        this.labelManager = new LabelManager(extContext);
        this.writer = writer;
        this.replacements = new IdentityHashMap<Object, Object>();
        writer.putByte((byte)TUPLE_START_CODE.code());
    }

    private ReferenceWriter getReferenceWriter(Class cls) {
        if (cls.isArray()) {
            Class<?> compType = cls.getComponentType();
            if (compType.isPrimitive()) {
                if (compType == Character.TYPE) {
                    return this.charArrayWriter;
                }
                if (compType == Byte.TYPE) {
                    return this.byteArrayWriter;
                }
                if (compType == Short.TYPE) {
                    return this.shortArrayWriter;
                }
                if (compType == Integer.TYPE) {
                    return this.intArrayWriter;
                }
                if (compType == Long.TYPE) {
                    return this.longArrayWriter;
                }
                if (compType == Float.TYPE) {
                    return this.floatArrayWriter;
                }
                if (compType == Double.TYPE) {
                    return this.doubleArrayWriter;
                }
                if (compType == Boolean.TYPE) {
                    return this.booleanArrayWriter;
                }
                throw new IllegalStateException("can't happen!");
            }
            return this.objectArrayWriter;
        }
        return this.objectWriter;
    }

    @Override
    public void flush() throws IOException {
        this.writer.putByte((byte)TUPLE_END_CODE.code());
        this.setInsideBody(false);
        Pair<Object, ReferenceWriter> data = null;
        while ((data = this.workQ.poll()) != null) {
            ((ReferenceWriter)data.second()).write(data.first());
        }
        this.writer.flush();
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void writeBoolean(boolean data) throws IOException {
        if (data) {
            this.writer.putByte(EmergeCodeFactory.BOOL_TRUE);
        } else {
            this.writer.putByte(EmergeCodeFactory.BOOL_FALSE);
        }
    }

    public void writeByte(byte data) throws IOException {
        EmergeCode code = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.BYTE, data);
        this.writer.putByte((byte)code.code());
        if (!code.hasEncodedValue()) {
            this.writer.putByte(data);
        }
    }

    public void writeChar(char data) throws IOException {
        EmergeCode code = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.CHAR, null);
        this.writer.putByte((byte)code.code());
    }

    public void writeShort(short data) throws IOException {
        EmergeCode code = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.SHORT, data);
        this.writer.putByte((byte)code.code());
        if (!code.hasEncodedValue()) {
            this.writer.putShort(data);
        }
    }

    @Override
    public void writeInt(int data) throws IOException {
        EmergeCode code = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.INT, data);
        this.writer.putByte((byte)code.code());
        if (!code.hasEncodedValue()) {
            this.writer.putInt(data);
        }
    }

    @Override
    public void writeLong(long data) throws IOException {
        EmergeCode code = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.LONG, data);
        this.writer.putByte((byte)code.code());
        if (!code.hasEncodedValue()) {
            this.writer.putLong(data);
        }
    }

    @Override
    public void writeFloat(float data) throws IOException {
        EmergeCode code = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.FLOAT, Float.valueOf(data));
        this.writer.putByte((byte)code.code());
        if (!code.hasEncodedValue()) {
            this.writer.putFloat(data);
        }
    }

    @Override
    public void writeDouble(double data) throws IOException {
        EmergeCode code = EmergeCodeFactory.getCode(EmergeCode.EmergeKind.DOUBLE, data);
        this.writer.putByte((byte)code.code());
        if (!code.hasEncodedValue()) {
            this.writer.putDouble(data);
        }
    }

    private LabelManager.Label getLabel(Object data, ReferenceWriter rw) {
        LabelManager.Label label = this.labelManager.lookup(this.firstTime, data);
        if (((Boolean)this.firstTime.content()).booleanValue()) {
            if (rw == null) {
                rw = this.getReferenceWriter(data.getClass());
            }
            this.workQ.offer((Pair<Object, ReferenceWriter>)new Pair(data, (Object)rw));
        }
        return label;
    }

    private LabelManager.Label handleIndir(Object data, ReferenceWriter rw) {
        LabelManager.Label label = this.getLabel(data, rw);
        if (this.insideBody) {
            this.writer.putByte((byte)INDIR_CODE.code());
            label.put(this.writer);
        }
        return label;
    }

    private void writePrimitiveArrayHeader(EmergeCode arrCode, LabelManager.Label label, int length) {
        this.writer.putByte((byte)arrCode.code());
        label.put(this.writer);
        VarOctetUtility.put(this.writer, 0L);
        VarOctetUtility.put(this.writer, length);
    }

    public void writeBooleanArray(boolean[] data) {
        LabelManager.Label label = this.handleIndir(data, this.booleanArrayWriter);
        if (!this.insideBody) {
            this.writePrimitiveArrayHeader(BOOL_ARR_CODE, label, data.length);
            for (boolean b : data) {
                this.writer.putBoolean(b);
            }
        }
    }

    public void writeByteArray(byte[] data) {
        LabelManager.Label label = this.handleIndir(data, this.byteArrayWriter);
        if (!this.insideBody) {
            this.writePrimitiveArrayHeader(BYTE_ARR_CODE, label, data.length);
            for (byte b : data) {
                this.writer.putByte(b);
            }
        }
    }

    public void writeCharArray(char[] data) {
        LabelManager.Label label = this.handleIndir(data, this.charArrayWriter);
        if (!this.insideBody) {
            this.writePrimitiveArrayHeader(CHAR_ARR_CODE, label, data.length);
            for (char c : data) {
                this.writer.putChar(c);
            }
        }
    }

    public void writeShortArray(short[] data) {
        LabelManager.Label label = this.handleIndir(data, this.shortArrayWriter);
        if (!this.insideBody) {
            this.writePrimitiveArrayHeader(SHORT_ARR_CODE, label, data.length);
            for (short s : data) {
                this.writer.putShort(s);
            }
        }
    }

    public void writeIntArray(int[] data) {
        LabelManager.Label label = this.handleIndir(data, this.intArrayWriter);
        if (!this.insideBody) {
            this.writePrimitiveArrayHeader(INT_ARR_CODE, label, data.length);
            for (int i : data) {
                this.writer.putInt(i);
            }
        }
    }

    public void writeLongArray(long[] data) {
        LabelManager.Label label = this.handleIndir(data, this.longArrayWriter);
        if (!this.insideBody) {
            this.writePrimitiveArrayHeader(LONG_ARR_CODE, label, data.length);
            for (long elem : data) {
                this.writer.putLong(elem);
            }
        }
    }

    public void writeFloatArray(float[] data) {
        LabelManager.Label label = this.handleIndir(data, this.floatArrayWriter);
        if (!this.insideBody) {
            this.writePrimitiveArrayHeader(FLOAT_ARR_CODE, label, data.length);
            for (float fl : data) {
                this.writer.putFloat(fl);
            }
        }
    }

    public void writeDoubleArray(double[] data) {
        LabelManager.Label label = this.handleIndir(data, this.doubleArrayWriter);
        if (!this.insideBody) {
            this.writePrimitiveArrayHeader(DOUBLE_ARR_CODE, label, data.length);
            for (double d : data) {
                this.writer.putDouble(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObjectOverride(Object obj) throws IOException {
        if (obj == null) {
            this.writer.putByte((byte)NULL_CODE.code());
            return;
        }
        ClassMarshaler cm = ClassMarshalerFactory.getClassMarshaler(obj.getClass());
        Holder cmHolder = new Holder((Object)cm);
        Object replacement = this.replacements.get(obj);
        if (replacement == obj && (replacement = cm.handleReplace(obj, (Holder<ClassMarshaler>)cmHolder)) != obj) {
            this.replacements.put(obj, replacement);
        }
        if (replacement == null) {
            this.writer.putByte((byte)NULL_CODE.code());
            return;
        }
        LabelManager.Label label = this.handleIndir(replacement, this.objectWriter);
        if (!this.insideBody) {
            Class<?> type = obj.getClass();
            this.setInsideBody(true);
            try {
                ((ClassMarshaler)cmHolder.content()).writeObject(obj, this);
            }
            finally {
                this.setInsideBody(false);
            }
        }
    }

    void writeValueArray(Object[] data) {
        LabelManager.Label label = this.handleIndir(data, this.objectArrayWriter);
        Class<?> dataType = data.getClass();
        Class<?> compType = data.getClass().getComponentType();
        ClassMarshaler cm = ClassMarshalerFactory.getClassMarshaler(compType);
        char[] selfType = cm.getTypeName();
        LabelManager.Label typeLabel = this.getLabel(selfType, this.objectArrayWriter);
        if (!this.insideBody) {
            this.writer.putByte((byte)REF_ARR_CODE.code());
            label.put(this.writer);
            typeLabel.put(this.writer);
            VarOctetUtility.put(this.writer, 0L);
            VarOctetUtility.put(this.writer, data.length);
            for (Object object : data) {
                LabelManager.Label elem = this.getLabel(object, null);
                elem.put(this.writer);
            }
        }
    }

    @Override
    public void defaultWriteObject() throws IOException {
        if (this.currentObject == null || this.currentClassMarshaler == null) {
            throw new IOException("Cannot call defaultWriteObject outside of a writeObject method");
        }
        this.currentClassMarshaler.writeClassFields(this.currentObject, this);
    }

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        throw new IOException("putFields not yet supported");
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void write(int val) throws IOException {
    }

    @Override
    public void write(byte[] buf) throws IOException {
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
    }

    @Override
    public void writeBytes(String val) throws IOException {
    }

    @Override
    public void writeChars(String val) throws IOException {
    }

    @Override
    public void writeUTF(String val) throws IOException {
    }

    private static interface ReferenceWriter {
        public void write(Object var1) throws IOException;
    }
}

