/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast.bytebuffer;

import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Allocator;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.BufferWrapper;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Slab;
import java.nio.ByteBuffer;

public abstract class AllocatorBase
implements Allocator {
    private int headerSize;
    private Slab currentSlab;
    private boolean closed = false;

    protected final void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Allocator is closed");
        }
    }

    AllocatorBase(int headerSize) {
        this.headerSize = headerSize;
        this.currentSlab = this.obtainSlab();
    }

    @Override
    public final int headerSize() {
        this.checkClosed();
        return this.headerSize;
    }

    abstract void dispose(Slab var1, ByteBuffer var2);

    abstract void releaseSlab(Slab var1);

    abstract Slab obtainSlab();

    @Override
    public final BufferWrapper allocate(int size) {
        this.checkClosed();
        if (size > this.maxAllocationSize()) {
            throw new IllegalArgumentException("Request size " + size + " is larger than maximum allocation size " + this.maxAllocationSize());
        }
        if (this.currentSlab.sizeAvailable() < size + this.headerSize) {
            this.currentSlab.markFull();
            this.releaseSlab(this.currentSlab);
            this.currentSlab = this.obtainSlab();
        }
        BufferWrapper result = new BufferWrapper(this, this.currentSlab, this.headerSize, size);
        return result;
    }

    @Override
    public final BufferWrapper allocate(int minSize, int maxSize) {
        this.checkClosed();
        if (minSize > this.maxAllocationSize()) {
            throw new IllegalArgumentException("Minimum request size " + minSize + " is larger than maximum allocation size " + this.maxAllocationSize());
        }
        int remaining = this.currentSlab.sizeAvailable() - this.headerSize;
        int allocSize = maxSize;
        if (remaining >= minSize && remaining <= maxSize) {
            allocSize = remaining;
        }
        return this.allocate(allocSize);
    }

    @Override
    public final void close() {
        this.checkClosed();
        this.releaseSlab(this.currentSlab);
        this.closed = true;
    }
}

