/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast.bytebuffer;

import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Allocator;
import java.nio.ByteBuffer;

public class Slab {
    private static final boolean DEBUG = true;
    private static long totalAllocated = 0L;
    private static long reclaimed = 0L;
    private ByteBuffer space;
    private int sizeDisposed;

    protected void finalize() {
        reclaimed += (long)this.space.capacity();
    }

    private void msg(String msg) {
        System.out.println("Slab: " + msg);
    }

    public int currentPosition() {
        return this.space.position();
    }

    public State getState() {
        if (this.sizeAllocated() == 0) {
            return State.EMPTY;
        }
        if (this.sizeAvailable() == 0) {
            return State.FULL;
        }
        return State.PARTIAL;
    }

    public int totalSize() {
        return this.space.capacity();
    }

    public int sizeAvailable() {
        return this.space.remaining();
    }

    public int sizeAllocated() {
        return this.space.position();
    }

    public int sizeDisposed() {
        return this.sizeDisposed;
    }

    public void markFull() {
        ByteBuffer result = this.allocate(this.sizeAvailable());
        this.dispose(result);
    }

    public void markEmpty() {
        this.space.position(0);
    }

    public Slab(int size, Allocator.BufferType bt) {
        totalAllocated += (long)size;
        try {
            this.space = bt == Allocator.BufferType.DIRECT ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
            this.initialize();
        }
        catch (Error err) {
            this.msg("Error " + err + " in constructor: size = " + size + " BufferType = " + (Object)((Object)bt) + " totalAllocated = " + totalAllocated + " reclaimed = " + reclaimed);
            throw err;
        }
        catch (RuntimeException exc) {
            this.msg("RuntimeException " + exc + " in constructor: size = " + size + " BufferType = " + (Object)((Object)bt) + " totalAllocated = " + totalAllocated + " reclaimed = " + reclaimed);
            throw exc;
        }
    }

    private void initialize() {
        this.space.limit(this.space.capacity());
        this.space.position(0);
        this.sizeDisposed = 0;
    }

    public ByteBuffer allocate(int size) {
        ByteBuffer result = null;
        if (size <= this.space.remaining()) {
            this.space.limit(this.space.position() + size);
            result = this.space.slice();
            this.space.position(this.space.limit());
            this.space.limit(this.space.capacity());
        }
        return result;
    }

    public void dispose(ByteBuffer buffer) {
        if (this.getState() == State.EMPTY) {
            throw new IllegalStateException("Attempt to disposed of a buffer to an empty Slab!");
        }
        this.sizeDisposed += buffer.capacity();
        if (this.getState() == State.FULL && this.sizeDisposed >= this.sizeAllocated()) {
            this.initialize();
        }
    }

    public ByteBuffer trim(int bufferStartPosition, ByteBuffer buffer, int sizeNeeded) {
        ByteBuffer result = buffer;
        if (bufferStartPosition + buffer.capacity() == this.space.position()) {
            this.space.position(bufferStartPosition);
            buffer = this.allocate(sizeNeeded);
        }
        return buffer;
    }

    public static enum State {
        EMPTY,
        PARTIAL,
        FULL;

    }
}

