/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast.bytebuffer;

import com.sun.corba.ee.impl.encoding.fast.bytebuffer.BufferWrapper;
import com.sun.corba.ee.impl.encoding.fast.bytebuffer.Writer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class WriterImpl
implements Writer {
    private Writer.BufferHandler handler;
    private volatile BufferWrapper buffer;
    private boolean isClosed = false;
    private ByteOrder byteOrder;

    public WriterImpl(Writer.BufferHandler handler) {
        this.handler = handler;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }

    @Override
    public Writer.BufferHandler bufferHandler() {
        return this.handler;
    }

    @Override
    public ByteOrder order() {
        return this.byteOrder;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    private void overflow() {
        this.initBuffer(this.handler.overflow(this.buffer));
    }

    private void initBuffer(BufferWrapper buffer) {
        this.buffer = buffer;
        buffer.buffer().clear();
        buffer.buffer().order(this.byteOrder);
    }

    @Override
    public synchronized void flush() {
        this.overflow();
    }

    @Override
    public synchronized void close() {
        this.handler.close(this.buffer);
        this.buffer = null;
        this.isClosed = true;
    }

    public synchronized void ensure(int size) {
        if (this.isClosed) {
            throw new IllegalStateException("ByteBufferWriter is closed");
        }
        if (this.buffer == null || this.buffer.remaining() < size) {
            this.overflow();
        }
        if (this.buffer.remaining() < size) {
            throw new RuntimeException("Newly allocated buffer is too small");
        }
    }

    @Override
    public void putBoolean(boolean data) {
        this.ensure(1);
        byte value = data ? (byte)1 : 0;
        this.buffer.buffer().put(value);
    }

    @Override
    public void putByte(byte data) {
        this.ensure(1);
        this.buffer.buffer().put(data);
    }

    @Override
    public void putChar(char data) {
        this.ensure(2);
        this.buffer.buffer().putChar(data);
    }

    @Override
    public void putShort(short data) {
        this.ensure(2);
        this.buffer.buffer().putShort(data);
    }

    @Override
    public void putInt(int data) {
        this.ensure(4);
        this.buffer.buffer().putInt(data);
    }

    @Override
    public void putLong(long data) {
        this.ensure(8);
        this.buffer.buffer().putLong(data);
    }

    @Override
    public void putFloat(float data) {
        this.ensure(4);
        this.buffer.buffer().putFloat(data);
    }

    @Override
    public void putDouble(double data) {
        this.ensure(8);
        this.buffer.buffer().putDouble(data);
    }

    @Override
    public void putBooleanArray(boolean[] data) {
        this.ensure(1);
        int ctr = 0;
        while (ctr < data.length) {
            int dataSizeToWrite = Math.min(data.length - ctr, this.buffer.buffer().remaining());
            for (int ctr2 = ctr; ctr2 < ctr + dataSizeToWrite; ++ctr2) {
                this.buffer.buffer().put((byte)(data[ctr2] ? 1 : 0));
            }
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void putByteArray(byte[] data) {
        this.ensure(1);
        int ctr = 0;
        while (true) {
            int dataSizeToWrite = Math.min(data.length - ctr, this.buffer.buffer().remaining());
            this.buffer.buffer().put(data, ctr, dataSizeToWrite);
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void putCharArray(char[] data) {
        this.ensure(2);
        CharBuffer typedBuffer = this.buffer.buffer().asCharBuffer();
        int ctr = 0;
        while (true) {
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.remaining());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void putShortArray(short[] data) {
        this.ensure(2);
        ShortBuffer typedBuffer = this.buffer.buffer().asShortBuffer();
        int ctr = 0;
        while (true) {
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void putIntArray(int[] data) {
        this.ensure(4);
        IntBuffer typedBuffer = this.buffer.buffer().asIntBuffer();
        int ctr = 0;
        while (true) {
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void putLongArray(long[] data) {
        this.ensure(8);
        LongBuffer typedBuffer = this.buffer.buffer().asLongBuffer();
        int ctr = 0;
        while (true) {
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void putFloatArray(float[] data) {
        this.ensure(4);
        FloatBuffer typedBuffer = this.buffer.buffer().asFloatBuffer();
        int ctr = 0;
        while (true) {
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }

    @Override
    public void putDoubleArray(double[] data) {
        this.ensure(8);
        DoubleBuffer typedBuffer = this.buffer.buffer().asDoubleBuffer();
        int ctr = 0;
        while (true) {
            int dataSizeToWrite = Math.min(data.length - ctr, typedBuffer.limit() - typedBuffer.position());
            typedBuffer.put(data, ctr, dataSizeToWrite);
            if ((ctr += dataSizeToWrite) == data.length) break;
            this.overflow();
        }
    }
}

