/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.DprintUtil;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.newtimer.generated.TimingPoints;
import com.sun.corba.ee.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.CodeSetsComponent;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerManager;
import com.sun.corba.ee.spi.protocol.CorbaClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.servicecontext.CodeSetServiceContext;
import com.sun.corba.ee.spi.servicecontext.MaxStreamFormatVersionServiceContext;
import com.sun.corba.ee.spi.servicecontext.ORBVersionServiceContext;
import com.sun.corba.ee.spi.servicecontext.SendingContextServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.corba.ee.spi.servicecontext.ServiceContextsCache;
import com.sun.corba.ee.spi.servicecontext.UEInfoServiceContext;
import com.sun.corba.ee.spi.servicecontext.UnknownServiceContext;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListIterator;
import com.sun.corba.ee.spi.transport.CorbaOutboundConnectionCache;
import java.io.IOException;
import java.util.Iterator;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.UnknownException;

public class CorbaClientRequestDispatcherImpl
implements CorbaClientRequestDispatcher {
    private Object lock = new Object();
    private DprintUtil dputil = new DprintUtil(this);
    private ORBVersionServiceContext ovsc = ServiceContextDefaults.makeORBVersionServiceContext();
    private MaxStreamFormatVersionServiceContext msfvc = ServiceContextDefaults.getMaxStreamFormatVersionServiceContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDROutputObject beginRequest(Object self, String opName, boolean isOneWay, CorbaContactInfo contactInfo) {
        Object object;
        CDROutputObject outputObject;
        TimingPoints tp;
        ORB orb;
        block41: {
            Object connectionCache;
            CorbaContactInfo corbaContactInfo = contactInfo;
            orb = contactInfo.getBroker();
            if (orb.subcontractDebugFlag) {
                this.dputil.enter("beginRequest", "op", opName, "isOneWay", isOneWay, "contactInfo", contactInfo);
            }
            tp = (TimingPoints)orb.getTimerManager().points();
            tp.enter_totalRequest();
            orb.getPIHandler().initiateClientPIRequest(false);
            CorbaConnection connection = null;
            Object object2 = this.lock;
            synchronized (object2) {
                if (contactInfo.isConnectionBased()) {
                    try {
                        tp.enter_connectionSetup();
                        if (contactInfo.shouldCacheConnection()) {
                            connection = orb.getTransportManager().getOutboundConnectionCache(contactInfo).get(contactInfo);
                        }
                        if (connection != null) {
                            if (orb.subcontractDebugFlag) {
                                this.dputil.info("Using cached connection", connection);
                            }
                        } else {
                            connection = contactInfo.createConnection();
                            if (orb.subcontractDebugFlag) {
                                this.dputil.info("Using created connection", connection);
                            }
                            if (connection.shouldRegisterReadEvent()) {
                                orb.getTransportManager().getSelector(0).registerForEvent(connection.getEventHandler());
                                connection.setState("ESTABLISHED");
                                if (orb.subcontractDebugFlag) {
                                    this.dputil.info("connection registered");
                                }
                            }
                            if (contactInfo.shouldCacheConnection()) {
                                CorbaOutboundConnectionCache connectionCache2 = orb.getTransportManager().getOutboundConnectionCache(contactInfo);
                                connectionCache2.stampTime(connection);
                                connectionCache2.put(contactInfo, connection);
                                if (orb.subcontractDebugFlag) {
                                    this.dputil.info("connection cached");
                                }
                            }
                        }
                    }
                    finally {
                        tp.exit_connectionSetup();
                    }
                }
            }
            CorbaMessageMediator messageMediator = contactInfo.createMessageMediator(orb, contactInfo, connection, opName, isOneWay);
            if (orb.subcontractDebugFlag) {
                this.dputil.info("created message mediator", messageMediator);
            }
            orb.getInvocationInfo().setMessageMediator(messageMediator);
            this.performCodeSetNegotiation(messageMediator);
            tp.enter_requestAddServiceContexts();
            try {
                this.addServiceContexts(messageMediator);
            }
            finally {
                tp.exit_requestAddServiceContexts();
            }
            outputObject = contactInfo.createOutputObject(messageMediator);
            if (orb.subcontractDebugFlag) {
                this.dputil.info("created output object", outputObject);
            }
            this.registerWaiter(messageMediator);
            object = this.lock;
            synchronized (object) {
                if (contactInfo.isConnectionBased() && contactInfo.shouldCacheConnection()) {
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("reclaiming connections");
                    }
                    connectionCache = orb.getTransportManager().getOutboundConnectionCache(contactInfo);
                    connectionCache.reclaim();
                }
            }
            orb.getPIHandler().setClientPIInfo(messageMediator);
            try {
                orb.getPIHandler().invokeClientPIStartingPoint();
            }
            catch (RemarshalException e) {
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("Remarshal");
                }
                if (this.getContactInfoListIterator(orb).hasNext()) {
                    contactInfo = (CorbaContactInfo)this.getContactInfoListIterator(orb).next();
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("RemarshalException: hasNext true", "contact info", contactInfo);
                    }
                    orb.getPIHandler().makeCompletedClientRequest(3, null);
                    this.unregisterWaiter(orb);
                    orb.getPIHandler().cleanupClientPIRequest();
                    connectionCache = this.beginRequest(self, opName, isOneWay, contactInfo);
                    if (orb.subcontractDebugFlag) {
                        this.dputil.exit();
                    }
                    return connectionCache;
                }
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("RemarshalException: hasNext false");
                }
                ORBUtilSystemException wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
                throw wrapper.remarshalWithNowhereToGo();
            }
            messageMediator.initializeMessage();
            if (!orb.subcontractDebugFlag) break block41;
            this.dputil.info("initialized message");
        }
        tp.enter_clientEncoding();
        object = outputObject;
        return object;
        finally {
            if (orb.subcontractDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDRInputObject marshalingComplete(Object self, CDROutputObject outputObject) throws ApplicationException, RemarshalException {
        CorbaMessageMediator messageMediator = outputObject.getMessageMediator();
        ORB orb = messageMediator.getBroker();
        TimingPoints tp = (TimingPoints)orb.getTimerManager().points();
        if (orb.subcontractDebugFlag) {
            this.dputil.enter("marshalingComplete", "self", self, this.opAndId(messageMediator));
        }
        try {
            tp.exit_clientEncoding();
            tp.enter_clientTransportAndWait();
            CDRInputObject inputObject = null;
            try {
                inputObject = this.marshalingComplete1(orb, messageMediator);
            }
            finally {
                tp.exit_clientTransportAndWait();
            }
            CDRInputObject cDRInputObject = this.processResponse(orb, messageMediator, inputObject);
            return cDRInputObject;
        }
        finally {
            tp.enter_clientDecoding();
            if (orb.subcontractDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDRInputObject marshalingComplete1(ORB orb, CorbaMessageMediator messageMediator) throws ApplicationException, RemarshalException {
        if (orb.subcontractDebugFlag) {
            this.dputil.enter("marshalingComplete1", this.opAndId(messageMediator));
        }
        try {
            messageMediator.finishSendingRequest();
            CDRInputObject cDRInputObject = messageMediator.waitForResponse();
            return cDRInputObject;
        }
        catch (RuntimeException e) {
            if (orb.subcontractDebugFlag) {
                this.dputil.info("exception", e.toString());
            }
            boolean retry = this.getContactInfoListIterator(orb).reportException(messageMediator.getContactInfo(), e);
            Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(2, e);
            if (retry) {
                if (newException == e) {
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("Retry true; same exception");
                    }
                    this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                } else {
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("Retry true; new exception");
                    }
                    this.continueOrThrowSystemOrRemarshal(messageMediator, newException);
                }
            } else {
                if (newException instanceof RuntimeException) {
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("Retry false; RuntimeException");
                    }
                    throw (RuntimeException)newException;
                }
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("Retry false; other exception");
                }
                throw e;
            }
            CDRInputObject cDRInputObject = null;
            return cDRInputObject;
        }
        finally {
            if (orb.subcontractDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CDRInputObject processResponse(ORB orb, CorbaMessageMediator messageMediator, CDRInputObject inputObject) throws ApplicationException, RemarshalException {
        TimingPoints tp = (TimingPoints)orb.getTimerManager().points();
        ORBUtilSystemException wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
        if (orb.subcontractDebugFlag) {
            this.dputil.enter("processResponse", this.opAndId(messageMediator));
        }
        tp.enter_processResponse();
        try {
            if (messageMediator.getConnection() != null) {
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("Non-null connection");
                }
                messageMediator.getConnection().setPostInitialContexts();
            }
            Throwable exception = null;
            if (messageMediator.isOneWay()) {
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("One way request");
                }
                this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
                exception = orb.getPIHandler().invokeClientPIEndingPoint(0, (Exception)exception);
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("One way request", "exception", exception);
                }
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
                CDRInputObject cDRInputObject = null;
                return cDRInputObject;
            }
            this.consumeServiceContexts(orb, messageMediator);
            inputObject.performORBVersionSpecificInit();
            if (messageMediator.isSystemExceptionReply()) {
                UEInfoServiceContext usc;
                ServiceContexts contexts;
                boolean doRemarshal;
                SystemException se = messageMediator.getSystemExceptionReply();
                if (orb.subcontractDebugFlag) {
                    this.dputil.info(new Object[]{"received system exception", se});
                }
                if (doRemarshal = this.getContactInfoListIterator(orb).reportException(messageMediator.getContactInfo(), (RuntimeException)((Object)se))) {
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info(new Object[]{"Do remarshal", se});
                    }
                    if (se == (exception = orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)((Object)se)))) {
                        if (orb.subcontractDebugFlag) {
                            this.dputil.info("Do remarshal: same exception");
                        }
                        exception = null;
                        this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                        throw wrapper.statementNotReachable1();
                    }
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("Do remarshal: new exception", exception);
                    }
                    this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
                    throw wrapper.statementNotReachable2();
                }
                if (orb.subcontractDebugFlag) {
                    this.dputil.info(new Object[]{"NO remarshal", se});
                }
                if ((contexts = messageMediator.getReplyServiceContexts()) != null && (usc = (UEInfoServiceContext)contexts.get(9)) != null) {
                    Throwable unknown = usc.getUE();
                    UnknownException ue = new UnknownException(unknown);
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("NO remarshal: UserException available", unknown);
                    }
                    exception = orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)ue);
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("NO remarshal: UserException available: PI exception ", exception);
                    }
                    this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
                    throw wrapper.statementNotReachable3();
                }
                if (orb.subcontractDebugFlag) {
                    this.dputil.info(new Object[]{"general exception", se});
                }
                exception = orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)((Object)se));
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("general exception: PI exception", exception);
                }
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
                throw wrapper.statementNotReachable4();
            }
            if (messageMediator.isUserExceptionReply()) {
                this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
                String exceptionRepoId = this.peekUserExceptionId(inputObject);
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("received user exception", "exceptionRepoId", exceptionRepoId);
                }
                Exception newException = null;
                if (messageMediator.isDIIRequest()) {
                    exception = messageMediator.unmarshalDIIUserException(exceptionRepoId, inputObject);
                    newException = orb.getPIHandler().invokeClientPIEndingPoint(1, (Exception)exception);
                    messageMediator.setDIIException(newException);
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("received user exception (DII)", "exception", exception, "newException", newException);
                    }
                } else {
                    ApplicationException appException = new ApplicationException(exceptionRepoId, (InputStream)inputObject);
                    exception = appException;
                    newException = orb.getPIHandler().invokeClientPIEndingPoint(1, (Exception)((Object)appException));
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("received user exception (not DII)", "exception", exception, "newException", newException);
                    }
                }
                if (newException != exception) {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, newException);
                }
                if (newException instanceof ApplicationException) {
                    throw (ApplicationException)((Object)newException);
                }
                CDRInputObject cDRInputObject = inputObject;
                return cDRInputObject;
            }
            if (messageMediator.isLocationForwardReply()) {
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("received location forward");
                }
                this.getContactInfoListIterator(orb).reportRedirect(messageMediator.getContactInfo(), messageMediator.getForwardedIOR());
                Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(3, null);
                if (!(newException instanceof RemarshalException)) {
                    exception = newException;
                }
                if (exception != null) {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
                }
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                throw wrapper.statementNotReachable5();
            }
            if (messageMediator.isDifferentAddrDispositionRequestedReply()) {
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("received different addressing dispostion request");
                }
                this.getContactInfoListIterator(orb).reportAddrDispositionRetry(messageMediator.getContactInfo(), messageMediator.getAddrDispositionReply());
                Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(5, null);
                if (!(newException instanceof RemarshalException)) {
                    exception = newException;
                }
                if (exception != null) {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
                }
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                throw wrapper.statementNotReachable6();
            }
            if (orb.subcontractDebugFlag) {
                this.dputil.info("received normal response");
            }
            this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
            messageMediator.handleDIIReply(inputObject);
            exception = orb.getPIHandler().invokeClientPIEndingPoint(0, null);
            this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
            CDRInputObject cDRInputObject = inputObject;
            return cDRInputObject;
        }
        finally {
            tp.exit_processResponse();
            if (orb.subcontractDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void continueOrThrowSystemOrRemarshal(CorbaMessageMediator messageMediator, Exception exception) throws SystemException, RemarshalException {
        block9: {
            ORB orb = messageMediator.getBroker();
            if (orb.subcontractDebugFlag) {
                this.dputil.enter("continueOrThrowSystemOrRemarshal", "exception", exception);
            }
            try {
                if (exception == null) {
                    break block9;
                }
                if (exception instanceof RemarshalException) {
                    orb.getInvocationInfo().setIsRetryInvocation(true);
                    this.unregisterWaiter(orb);
                    if (orb.subcontractDebugFlag) {
                        this.dputil.info("throwing Remarshal");
                    }
                    throw (RemarshalException)((Object)exception);
                }
                if (orb.subcontractDebugFlag) {
                    this.dputil.info("throwing exception", exception);
                }
                throw (SystemException)((Object)exception);
            }
            finally {
                if (orb.subcontractDebugFlag) {
                    this.dputil.exit();
                }
            }
        }
    }

    protected CorbaContactInfoListIterator getContactInfoListIterator(ORB orb) {
        return (CorbaContactInfoListIterator)((CorbaInvocationInfo)orb.getInvocationInfo()).getContactInfoListIterator();
    }

    protected void registerWaiter(CorbaMessageMediator messageMediator) {
        if (messageMediator.getConnection() != null) {
            messageMediator.getConnection().registerWaiter(messageMediator);
        }
    }

    protected void unregisterWaiter(ORB orb) {
        CorbaMessageMediator messageMediator = orb.getInvocationInfo().getMessageMediator();
        if (messageMediator != null && messageMediator.getConnection() != null) {
            messageMediator.getConnection().unregisterWaiter(messageMediator);
        }
    }

    protected void addServiceContexts(CorbaMessageMediator messageMediator) {
        ORB orb = messageMediator.getBroker();
        CorbaConnection c = messageMediator.getConnection();
        GIOPVersion giopVersion = messageMediator.getGIOPVersion();
        ServiceContexts contexts = null;
        if (ORBUtility.getEncodingVersion() != 0) {
            contexts = messageMediator.getRequestServiceContexts();
            ORBVersionServiceContext ovsc = ServiceContextDefaults.getORBVersionServiceContext();
            contexts.put(ovsc);
            return;
        }
        if (c != null && giopVersion.equals(GIOPVersion.V1_2) && c.getBroker().getORBData().alwaysSendCodeSetServiceContext()) {
            contexts = !c.isPostInitialContexts() ? messageMediator.getBroker().getServiceContextsCache().get(ServiceContextsCache.CASE.CLIENT_INITIAL) : messageMediator.getBroker().getServiceContextsCache().get(ServiceContextsCache.CASE.CLIENT_SUBSEQUENT);
            this.addCodeSetServiceContext(c, contexts, giopVersion);
            messageMediator.setRequestServiceContexts(contexts);
        } else {
            contexts = messageMediator.getRequestServiceContexts();
            this.addCodeSetServiceContext(c, contexts, giopVersion);
            contexts.put(this.msfvc);
            contexts.put(this.ovsc);
            if (c != null && !c.isPostInitialContexts()) {
                SendingContextServiceContext scsc = ServiceContextDefaults.makeSendingContextServiceContext(orb.getFVDCodeBaseIOR());
                contexts.put(scsc);
            }
        }
    }

    protected void consumeServiceContexts(ORB orb, CorbaMessageMediator messageMediator) {
        ServiceContexts ctxts = messageMediator.getReplyServiceContexts();
        ORBUtilSystemException wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
        if (ctxts == null) {
            return;
        }
        ServiceContext sc = ctxts.get(6);
        if (sc != null) {
            SendingContextServiceContext scsc = (SendingContextServiceContext)sc;
            IOR ior = scsc.getIOR();
            try {
                if (messageMediator.getConnection() != null) {
                    messageMediator.getConnection().setCodeBaseIOR(ior);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                throw wrapper.badStringifiedIor(t);
            }
        }
        if ((sc = ctxts.get(1313165056)) != null) {
            ORBVersionServiceContext ovsc = (ORBVersionServiceContext)sc;
            ORBVersion version = ovsc.getVersion();
            orb.setORBVersion(version);
        }
        this.getExceptionDetailMessage(messageMediator, wrapper);
    }

    protected void getExceptionDetailMessage(CorbaMessageMediator messageMediator, ORBUtilSystemException wrapper) {
        ServiceContext sc = messageMediator.getReplyServiceContexts().get(14);
        if (sc == null) {
            return;
        }
        if (!(sc instanceof UnknownServiceContext)) {
            throw wrapper.badExceptionDetailMessageServiceContextType();
        }
        byte[] data = ((UnknownServiceContext)sc).getData();
        EncapsInputStream in = new EncapsInputStream((org.omg.CORBA.ORB)messageMediator.getBroker(), data, data.length);
        in.consumeEndian();
        String msg = "----------BEGIN server-side stack trace----------\n" + in.read_wstring() + "\n" + "----------END server-side stack trace----------";
        messageMediator.setReplyExceptionDetailMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRequest(ORB broker, Object self, CDRInputObject inputObject) {
        ORB orb = broker;
        TimerManager<TimingPoints> tm = orb.getTimerManager();
        if (tm == null) {
            return;
        }
        TimingPoints tp = (TimingPoints)tm.points();
        try {
            CorbaMessageMediator messageMediator;
            tp.exit_clientDecoding();
            if (orb.subcontractDebugFlag) {
                this.dputil.enter("endRequest", new Object[0]);
            }
            if ((messageMediator = orb.getInvocationInfo().getMessageMediator()) != null) {
                CDROutputObject outputObj;
                CDRInputObject inputObj;
                ORBUtility.popEncVersionFromThreadLocalState();
                if (messageMediator.getConnection() != null) {
                    messageMediator.sendCancelRequestIfFinalFragmentNotSent();
                }
                if ((inputObj = messageMediator.getInputObject()) != null) {
                    inputObj.close();
                }
                if ((outputObj = messageMediator.getOutputObject()) != null) {
                    outputObj.close();
                }
            }
            this.unregisterWaiter(orb);
            orb.getPIHandler().cleanupClientPIRequest();
        }
        catch (IOException ex) {
            if (orb.subcontractDebugFlag) {
                this.dputil.info("ignoring IOException", ex);
            }
        }
        finally {
            tp.exit_totalRequest();
            if (orb.subcontractDebugFlag) {
                this.dputil.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performCodeSetNegotiation(CorbaMessageMediator messageMediator) {
        CorbaConnection conn = messageMediator.getConnection();
        if (conn == null) {
            return;
        }
        GIOPVersion giopVersion = messageMediator.getGIOPVersion();
        if (giopVersion.equals(GIOPVersion.V1_0)) {
            return;
        }
        IOR ior = messageMediator.getContactInfo().getEffectiveTargetIOR();
        CorbaConnection corbaConnection = conn;
        synchronized (corbaConnection) {
            if (conn.getCodeSetContext() != null) {
                return;
            }
            IIOPProfileTemplate temp = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
            Iterator<TaggedComponent> iter = temp.iteratorById(1);
            if (!iter.hasNext()) {
                return;
            }
            CodeSetComponentInfo serverCodeSets = ((CodeSetsComponent)iter.next()).getCodeSetComponentInfo();
            CodeSetComponentInfo.CodeSetContext result = CodeSetConversion.impl().negotiate(conn.getBroker().getORBData().getCodeSetComponentInfo(), serverCodeSets);
            conn.setCodeSetContext(result);
        }
    }

    protected void addCodeSetServiceContext(CorbaConnection conn, ServiceContexts ctxs, GIOPVersion giopVersion) {
        if (giopVersion.equals(GIOPVersion.V1_0) || conn == null) {
            return;
        }
        CodeSetComponentInfo.CodeSetContext codeSetCtx = null;
        if (conn.getBroker().getORBData().alwaysSendCodeSetServiceContext() || !conn.isPostInitialContexts()) {
            codeSetCtx = conn.getCodeSetContext();
        }
        if (codeSetCtx == null) {
            return;
        }
        CodeSetServiceContext cssc = ServiceContextDefaults.makeCodeSetServiceContext(codeSetCtx);
        ctxs.put(cssc);
    }

    protected String peekUserExceptionId(CDRInputObject inputObject) {
        CDRInputObject cdrInputObject = inputObject;
        cdrInputObject.mark(Integer.MAX_VALUE);
        String result = cdrInputObject.read_string();
        cdrInputObject.reset();
        return result;
    }

    protected String opAndId(CorbaMessageMediator mediator) {
        return ORBUtility.operationNameAndRequestId(mediator);
    }
}

