/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.security.jmac.provider.PacketMapMessageInfo;
import com.sun.enterprise.security.jmac.provider.PacketMessageInfo;
import com.sun.enterprise.security.jmac.provider.config.PipeHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthContext;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.WebServiceException;

public class ClientSecurityTube
extends AbstractFilterTubeImpl
implements SecureConversationInitiator {
    protected PipeHelper helper;
    protected static final Logger _logger = LogDomains.getLogger(ClientSecurityTube.class, (String)"javax.enterprise.system.core.security");
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ClientSecurityTube.class);
    private static final String WSIT_CLIENT_AUTH_CONTEXT = "com.sun.xml.wss.provider.wsit.WSITClientAuthContext";
    private ClientAuthContext cAC = null;
    private PacketMessageInfo info = null;
    private Subject clientSubject = null;

    public ClientSecurityTube(Map props, Tube next) {
        super(next);
        props.put("SECURITY_PIPE", this);
        WSDLPort wsdlModel = (WSDLPort)props.get("WSDL_MODEL");
        if (wsdlModel != null) {
            props.put("WSDL_SERVICE", wsdlModel.getOwner().getName());
        }
        this.helper = new PipeHelper("SOAP", props, null);
    }

    protected ClientSecurityTube(ClientSecurityTube that, TubeCloner cloner) {
        super((AbstractFilterTubeImpl)that, cloner);
        this.helper = that.helper;
    }

    public void preDestroy() {
        try {
            Packet request = new Packet();
            PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
            Subject subj = ClientSecurityTube.getClientSubject(request);
            ClientAuthContext cAC = this.helper.getClientAuthContext(info, subj);
            if (cAC != null && WSIT_CLIENT_AUTH_CONTEXT.equals(cAC.getClass().getName())) {
                cAC.cleanSubject((MessageInfo)info, subj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.helper.disable();
    }

    public NextAction processRequest(Packet request) {
        try {
            this.info = new PacketMapMessageInfo(request, new Packet());
            AuthStatus status = AuthStatus.SEND_SUCCESS;
            this.info.getMap().put("javax.xml.ws.wsdl.service", this.helper.getProperty("WSDL_SERVICE"));
            Subject clientSubject = ClientSecurityTube.getClientSubject(request);
            this.cAC = this.helper.getClientAuthContext(this.info, clientSubject);
            if (this.cAC != null) {
                status = this.cAC.secureRequest((MessageInfo)this.info, clientSubject);
            }
            if (status == AuthStatus.FAILURE) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "ws.status_secure_request", status);
                }
                throw new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantSecureRequst", "Cannot secure request for {0}", new Object[]{this.helper.getModelName()}), (Throwable)new Exception("An Error occured while Securing the Request"));
            }
            return this.doInvoke(this.next, this.info.getRequestPacket());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ws.error_secure_request", e);
            throw new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantSecureRequst", "Cannot secure request for {0}", new Object[]{this.helper.getModelName()}), (Throwable)e);
        }
    }

    public NextAction processResponse(Packet response) {
        try {
            Message m = response.getMessage();
            if (m != null && this.cAC != null) {
                AuthStatus status = AuthStatus.SUCCESS;
                this.info.setResponsePacket(response);
                try {
                    status = this.cAC.validateResponse((MessageInfo)this.info, this.clientSubject, null);
                }
                catch (Exception e) {
                    return this.doThrow((Throwable)new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantValidateResponse", "Cannot validate response for {0}", new Object[]{this.helper.getModelName()}), (Throwable)e));
                }
                if (status == AuthStatus.SEND_CONTINUE) {
                    return this.doInvoke(this.next, this.info.getRequestPacket());
                }
                response = this.info.getResponsePacket();
            }
            return this.doReturnWith(response);
        }
        catch (Throwable t2) {
            WebServiceException t2;
            if (!(t2 instanceof WebServiceException)) {
                t2 = new WebServiceException(t2);
            }
            return this.doThrow((Throwable)t2);
        }
    }

    private static Subject getClientSubject(Packet p) {
        Subject s = null;
        if (p != null) {
            s = (Subject)p.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (s == null) {
            s = PipeHelper.getClientSubject();
            if (p != null) {
                p.invocationProperties.put("CLIENT_SUBJECT", s);
            }
        }
        return s;
    }

    public JAXBElement startSecureConversation(Packet packet) throws WSSecureConversationException {
        PacketMapMessageInfo info = new PacketMapMessageInfo(packet, new Packet());
        JAXBElement token = null;
        try {
            Subject clientSubject = ClientSecurityTube.getClientSubject(packet);
            HashMap<String, PacketMapMessageInfo> map = new HashMap<String, PacketMapMessageInfo>();
            map.put("SECURITY_TOKEN", info);
            this.helper.getSessionToken(map, info, clientSubject);
            Object o = info.getMap().get("SECURITY_TOKEN");
            if (o != null && o instanceof JAXBElement) {
                token = (JAXBElement)o;
            }
        }
        catch (Exception e) {
            if (e instanceof WSSecureConversationException) {
                throw (WSSecureConversationException)e;
            }
            throw new WSSecureConversationException("Secure Conversation failure: ", (Throwable)e);
        }
        return token;
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new ClientSecurityTube(this, cloner);
    }
}

