/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.EjbComponentAnnotationScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.EjbDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.EjbRuntimeDDFile;
import com.sun.enterprise.deployment.io.runtime.GFEjbRuntimeDDFile;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.deployment.util.EjbBundleValidator;
import com.sun.enterprise.deployment.util.ModuleContentValidator;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.Set;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class EjbArchivist
extends Archivist<EjbBundleDescriptor> {
    DeploymentDescriptorFile standardDD = new EjbDeploymentDescriptorFile();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbArchivist.class);

    @Override
    public XModuleType getModuleType() {
        return XModuleType.EJB;
    }

    @Override
    public void setDescriptor(Application descriptor) {
        Set<EjbBundleDescriptor> ejbBundles = descriptor.getEjbBundleDescriptors();
        if (ejbBundles.size() > 0) {
            this.descriptor = ejbBundles.iterator().next();
            if (((EjbBundleDescriptor)this.descriptor).getModuleDescriptor().isStandalone()) {
                return;
            }
            this.descriptor = null;
        }
    }

    @Override
    public DeploymentDescriptorFile getStandardDDFile() {
        return this.standardDD;
    }

    @Override
    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new GFEjbRuntimeDDFile();
    }

    @Override
    public DeploymentDescriptorFile getSunConfigurationDDFile() {
        return new EjbRuntimeDDFile();
    }

    @Override
    public String getWebServicesDeploymentDescriptorPath() {
        return "META-INF/webservices.xml";
    }

    @Override
    public EjbBundleDescriptor getDefaultBundleDescriptor() {
        return new EjbBundleDescriptor();
    }

    @Override
    protected void postOpen(EjbBundleDescriptor descriptor, ReadableArchive archive) throws IOException {
        super.postOpen(descriptor, archive);
        EjbBundleDescriptor ejbBundle = descriptor;
        ModuleContentValidator mdv = new ModuleContentValidator(archive);
        ejbBundle.visit(mdv);
    }

    @Override
    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((EjbBundleDescriptor)this.descriptor).setClassLoader(cl);
        ((EjbBundleDescriptor)this.descriptor).visit(new EjbBundleValidator());
    }

    @Override
    protected String getArchiveExtension() {
        return ".jar";
    }

    @Override
    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        AnnotationDetector detector = new AnnotationDetector(new EjbComponentAnnotationScanner());
        return !DeploymentUtils.isWebArchive((ReadableArchive)abstractArchive) && detector.hasAnnotationInArchive(abstractArchive);
    }
}

