/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.taglibs.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class CacheUtil {
    private static final Logger logger = LogDomains.getLogger(CacheUtil.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle _rb = logger.getResourceBundle();
    private static final String PAGE_SCOPE = "page";
    private static final String REQUEST_SCOPE = "request";
    private static final String SESSION_SCOPE = "session";
    private static final String APPLICATION_SCOPE = "application";

    public static Cache getCache(PageContext pc, int scope) {
        return (Cache)pc.getAttribute("com.sun.appserv.web.taglibs.cache.tag_cache", scope);
    }

    public static String generateKey(String key, PageContext pc) {
        HttpServletRequest req = (HttpServletRequest)pc.getRequest();
        String suffix = key;
        if (suffix == null) {
            String saved = (String)req.getAttribute("com.sun.appserv.web.taglibs.cache.tag_counter");
            suffix = saved == null ? "1" : Integer.toString(Integer.parseInt(saved) + 1);
            req.setAttribute("com.sun.appserv.web.taglibs.cache.tag_counter", suffix);
        }
        return req.getServletPath() + '_' + suffix;
    }

    public static int convertScope(String scope) {
        int ret;
        if (REQUEST_SCOPE.equalsIgnoreCase(scope)) {
            ret = 2;
        } else if (SESSION_SCOPE.equalsIgnoreCase(scope)) {
            ret = 3;
        } else if (APPLICATION_SCOPE.equalsIgnoreCase(scope)) {
            ret = 4;
        } else {
            String msg = _rb.getString("taglibs.cache.illegalScope");
            msg = MessageFormat.format(msg, scope);
            throw new IllegalArgumentException(msg);
        }
        return ret;
    }
}

