/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.Min;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Server
extends ConfigBeanProxy,
Injectable,
PropertyBag,
Named,
SystemPropertyBag,
ReferenceContainer,
RefContainer {
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Attribute
    public String getConfigRef();

    @Param(name="config", optional=true)
    public void setConfigRef(String var1) throws PropertyVetoException;

    @Attribute
    public String getNodeAgentRef();

    @Param(name="nodeagent")
    public void setNodeAgentRef(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="100")
    @Min(value=1L)
    public String getLbWeight();

    public void setLbWeight(String var1) throws PropertyVetoException;

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal system properties")
    @Element
    @Param(name="systemproperties", optional=true)
    public List<SystemProperty> getSystemProperty();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    @Param(name="properties", optional=true)
    public List<Property> getProperty();

    @DuckTyped
    public String getReference();

    @DuckTyped
    public ResourceRef getResourceRef(String var1);

    @DuckTyped
    public boolean isResourceRefExists(String var1);

    @DuckTyped
    public void deleteResourceRef(String var1) throws TransactionFailure;

    @DuckTyped
    public void createResourceRef(String var1, String var2) throws TransactionFailure;

    @DuckTyped
    public ApplicationRef getApplicationRef(String var1);

    @DuckTyped
    public Cluster getCluster();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class Decorator
    implements CreationDecorator<Server> {
        @Param(name="cluster", optional=true)
        String clusterName;
        @Inject
        Domain domain;

        @Override
        public void decorate(AdminCommandContext context, Server instance) throws TransactionFailure, PropertyVetoException {
            Config specifiedConfig;
            Logger logger = LogDomains.getLogger(Cluster.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Server.class);
            String configRef = instance.getConfigRef();
            if (this.domain.getClusterNamed(instance.getName()) != null || this.domain.getConfigNamed(instance.getName()) != null) {
                throw new TransactionFailure(localStrings.getLocalString("cannotAddDuplicate", "There is an instance {0} already present.", new Object[]{instance.getName()}));
            }
            if (this.clusterName != null) {
                if (configRef != null) {
                    throw new TransactionFailure(localStrings.getLocalString("Server.cannotSpecifyBothConfigAndCluster", "A configuration name and cluster name cannot both be specified."));
                }
                boolean clusterExists = false;
                Clusters clusters = this.domain.getClusters();
                if (clusters != null) {
                    for (Cluster cluster : clusters.getCluster()) {
                        if (cluster == null || !this.clusterName.equals(cluster.getName())) continue;
                        instance.setConfigRef(cluster.getConfigRef());
                        clusterExists = true;
                        break;
                    }
                }
                if (!clusterExists) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchCluster", "Cluster {0} does not exist.", new Object[]{this.clusterName}));
                }
            }
            if (configRef != null && (specifiedConfig = this.domain.getConfigs().getConfigByName(configRef)) == null) {
                throw new TransactionFailure(localStrings.getLocalString("noSuchConfig", "Configuration {0} does not exist.", new Object[]{configRef}));
            }
            if (configRef == null && this.clusterName == null) {
                Config configCopy;
                Config defaultConfig = this.domain.getConfigs().getConfigByName("default-config");
                if (defaultConfig == null) {
                    String msg = localStrings.getLocalString(Server.class, "Cluster.noDefaultConfig", "Can''t find the default config (an element named \"default-config\") in domain.xml.  You may specify the name of an existing config element next time.");
                    logger.log(Level.SEVERE, msg);
                    throw new TransactionFailure(msg);
                }
                try {
                    configCopy = (Config)defaultConfig.deepCopy();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, localStrings.getLocalString(Server.class, "Cluster.error_while_copying", "Error while copying the default configuration {0}", new Object[]{e.toString(), e}));
                    throw new TransactionFailure(e.toString(), e);
                }
                final String configName = instance.getName() + "-config";
                instance.setConfigRef(configName);
                ConfigSupport.apply(new ConfigCode(){

                    public Object run(ConfigBeanProxy[] w) throws PropertyVetoException, TransactionFailure {
                        ((Configs)w[0]).getConfig().add(configCopy);
                        ((Config)w[1]).setName(configName);
                        return null;
                    }
                }, this.domain.getConfigs(), configCopy);
            }
            for (Resource resource : this.domain.getResources().getResources()) {
                if (!resource.getObjectType().equals("system-all")) continue;
                String name = null;
                if (resource instanceof BindableResource) {
                    name = ((BindableResource)resource).getJndiName();
                }
                if (resource instanceof Named) {
                    name = ((Named)resource).getName();
                }
                if (name == null) {
                    throw new TransactionFailure("Cannot add un-named resources to the new server instance");
                }
                ResourceRef newResourceRef = instance.createChild(ResourceRef.class);
                newResourceRef.setRef(name);
                instance.getResourceRef().add(newResourceRef);
            }
            for (Application application : this.domain.getApplications().getApplications()) {
                if (!application.getObjectType().equals("system-all")) continue;
                ApplicationRef newAppRef = instance.createChild(ApplicationRef.class);
                newAppRef.setRef(application.getName());
                instance.getApplicationRef().add(newAppRef);
            }
        }
    }

    public static class Duck {
        public static Cluster getCluster(Server server) {
            Dom serverDom = Dom.unwrap(server);
            Clusters clusters = serverDom.getHabitat().getComponent(Clusters.class);
            if (clusters != null) {
                for (Cluster cluster : clusters.getCluster()) {
                    for (ServerRef serverRef : cluster.getServerRef()) {
                        if (!serverRef.getRef().equals(server.getName())) continue;
                        return cluster;
                    }
                }
            }
            return null;
        }

        public static String getReference(Server server) {
            return server.getConfigRef();
        }

        public static ApplicationRef getApplicationRef(Server server, String appName) {
            for (ApplicationRef appRef : server.getApplicationRef()) {
                if (!appRef.getRef().equals(appName)) continue;
                return appRef;
            }
            return null;
        }

        public static ResourceRef getResourceRef(Server server, String refName) {
            for (ResourceRef ref : server.getResourceRef()) {
                if (!ref.getRef().equals(refName)) continue;
                return ref;
            }
            return null;
        }

        public static boolean isResourceRefExists(Server server, String refName) {
            return Duck.getResourceRef(server, refName) != null;
        }

        public static void deleteResourceRef(Server server, String refName) throws TransactionFailure {
            final ResourceRef ref = Duck.getResourceRef(server, refName);
            if (ref != null) {
                ConfigSupport.apply(new SingleConfigCode<Server>(){

                    @Override
                    public Object run(Server param) {
                        return param.getResourceRef().remove(ref);
                    }
                }, server);
            }
        }

        public static void createResourceRef(Server server, final String enabled, final String refName) throws TransactionFailure {
            ConfigSupport.apply(new SingleConfigCode<Server>(){

                @Override
                public Object run(Server param) throws PropertyVetoException, TransactionFailure {
                    ResourceRef newResourceRef = param.createChild(ResourceRef.class);
                    newResourceRef.setEnabled(enabled);
                    newResourceRef.setRef(refName);
                    param.getResourceRef().add(newResourceRef);
                    return newResourceRef;
                }
            }, server);
        }
    }
}

