/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.GenericCommandModel;
import org.glassfish.config.support.GenericCrudCommand;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.TransactionFailure;

@Scoped(value=PerLookup.class)
public class GenericDeleteCommand
extends GenericCrudCommand
implements AdminCommand,
PostConstruct,
CommandModelProvider {
    @Inject
    Habitat habitat;
    Class<? extends CrudResolver> resolverType;
    CommandModel model;
    String elementName;
    Delete delete;

    public CommandModel getModel() {
        return this.model;
    }

    public void postConstruct() {
        super.postConstruct();
        this.delete = this.targetMethod.getAnnotation(Delete.class);
        this.resolverType = this.delete.resolver();
        try {
            this.model = new GenericCommandModel(this.targetType, this.delete.cluster(), this.habitat.getComponent(DomDocument.class), this.commandName, this.delete.resolver(), null);
            if (logger.isLoggable(this.level)) {
                for (String paramName : this.model.getParametersNames()) {
                    CommandModel.ParamModel param = this.model.getModelFor(paramName);
                    logger.fine("I take " + param.getName() + " parameters");
                }
            }
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericCreateCommand.command_model_exception", "Exception while creating the command model for the generic command {0} : {1}", new Object[]{this.commandName, e.getMessage()});
            logger.severe(msg);
            throw new ComponentException(msg, e);
        }
    }

    public void execute(AdminCommandContext context) {
        ActionReport result = context.getActionReport();
        InjectionManager manager = new InjectionManager();
        CrudResolver resolver = this.habitat.getComponent(this.resolverType);
        manager.inject((Object)resolver, this.getInjectionResolver());
        Object target = resolver.resolve(context, this.targetType);
        if (target == null) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericDeleteCommand.target_object_not_found", "The CrudResolver {0} could not find the configuration object of type {1} where instances of {2} should be removed", new Object[]{resolver.getClass().toString(), this.parentType, this.targetType});
            result.failure(logger, msg);
            return;
        }
        ConfigBean child = (ConfigBean)ConfigBean.unwrap(target);
        try {
            ConfigSupport.deleteChild((ConfigBean)child.parent(), child);
        }
        catch (TransactionFailure e) {
            String msg = localStrings.getLocalString(GenericCrudCommand.class, "GenericDeleteCommand.transaction_exception", "Exception while deleting the configuration {0} :{1}", new Object[]{child.typeName(), e.getMessage()});
            result.failure(logger, msg, (Throwable)e);
        }
    }
}

