/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.CompoundExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.ReportQuery;

public class RelationExpression
extends CompoundExpression {
    protected Boolean isObjectComparisonExpression;

    protected boolean allChildrenAreFields() {
        return this.firstChild.getFields().size() == 1 && this.secondChild.getFields().size() == 1;
    }

    protected void convertNodeToUseOuterJoin() {
        if (this.operator.getSelector() == 4 && this.allChildrenAreFields()) {
            this.setOperator(this.getOperator(6));
        }
    }

    public String descriptionOfNodeType() {
        return "Relation";
    }

    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        if (this.secondChild.getBuilder().getSession() == null || this.firstChild.getBuilder().getSession() == null) {
            throw QueryException.cannotConformExpression();
        }
        Object rightValue = this.secondChild.valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        Object leftValue = this.firstChild.valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        if (rightValue instanceof Collection) {
            if (this.operator.getSelector() == 13 || this.operator.getSelector() == 14) {
                if (this.isObjectComparison()) {
                    throw QueryException.cannotConformExpression();
                }
                if (leftValue instanceof Vector) {
                    return this.doesAnyOfLeftValuesConform((Vector)leftValue, rightValue, session);
                }
                return this.operator.doesRelationConform(leftValue, rightValue);
            }
            Enumeration rightEnum = ((Vector)rightValue).elements();
            while (rightEnum.hasMoreElements()) {
                Object tempRight = rightEnum.nextElement();
                if (leftValue instanceof Vector && this.doesAnyOfLeftValuesConform((Vector)leftValue, tempRight, session)) {
                    return true;
                }
                if (!this.doValuesConform(leftValue, tempRight, session)) continue;
                return true;
            }
            return false;
        }
        if (leftValue instanceof Vector) {
            return this.doesAnyOfLeftValuesConform((Vector)leftValue, rightValue, session);
        }
        return this.doValuesConform(leftValue, rightValue, session);
    }

    protected boolean doesAnyOfLeftValuesConform(Vector leftValues, Object rightValue, AbstractSession session) {
        for (int index = 0; index < leftValues.size(); ++index) {
            Object leftValue = leftValues.get(index);
            if (!this.doValuesConform(leftValue, rightValue, session)) continue;
            return true;
        }
        return false;
    }

    protected boolean doValuesConform(Object leftValue, Object rightValue, AbstractSession session) {
        if (this.isObjectComparison()) {
            return this.doesObjectConform(leftValue, rightValue, session);
        }
        return this.operator.doesRelationConform(leftValue, rightValue);
    }

    public boolean doesObjectConform(Object leftValue, Object rightValue, AbstractSession session) {
        if (leftValue == null && rightValue == null) {
            return this.performSelector(true);
        }
        if (leftValue == null || rightValue == null) {
            return this.performSelector(false);
        }
        Class<?> javaClass = leftValue.getClass();
        if (javaClass != rightValue.getClass()) {
            return this.performSelector(false);
        }
        ClassDescriptor descriptor = session.getDescriptor(javaClass);
        if (descriptor.isAggregateDescriptor()) {
            throw QueryException.cannotConformExpression();
        }
        Object leftPrimaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(leftValue, session);
        Object rightPrimaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(rightValue, session);
        return this.performSelector(leftPrimaryKey.equals(rightPrimaryKey));
    }

    public boolean extractPrimaryKeyValues(boolean requireExactMatch, ClassDescriptor descriptor, AbstractRecord primaryKeyRow, AbstractRecord translationRow) {
        if (requireExactMatch && this.operator.getSelector() != 4) {
            return false;
        }
        if (!requireExactMatch && this.operator.getSelector() == 13) {
            return false;
        }
        DatabaseField field = null;
        Object value = null;
        if (this.secondChild.isConstantExpression()) {
            value = ((ConstantExpression)this.secondChild).getValue();
        } else if (this.secondChild.isParameterExpression() && translationRow != null) {
            value = translationRow.get(((ParameterExpression)this.secondChild).getField());
        } else if (this.firstChild.isConstantExpression()) {
            value = ((ConstantExpression)this.firstChild).getValue();
        } else if (this.firstChild.isParameterExpression() && translationRow != null) {
            value = translationRow.get(((ParameterExpression)this.firstChild).getField());
        }
        if (value == null) {
            return false;
        }
        if (this.firstChild.isFieldExpression()) {
            FieldExpression child = (FieldExpression)this.firstChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            field = child.getField();
        } else if (this.firstChild.isQueryKeyExpression()) {
            QueryKeyExpression child = (QueryKeyExpression)this.firstChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(child.getName());
            if (mapping != null) {
                if (!mapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping()) {
                    mapping.writeFromAttributeIntoRow(value, primaryKeyRow, this.getSession());
                    return true;
                }
                if (!mapping.isDirectToFieldMapping()) {
                    return false;
                }
                field = ((AbstractDirectMapping)mapping).getField();
            } else {
                field = descriptor.getObjectBuilder().getFieldForQueryKeyName(child.getName());
            }
        } else if (this.secondChild.isFieldExpression()) {
            FieldExpression child = (FieldExpression)this.secondChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            field = child.getField();
        } else if (this.secondChild.isQueryKeyExpression()) {
            QueryKeyExpression child = (QueryKeyExpression)this.secondChild;
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(child.getName());
            if (mapping != null) {
                if (!mapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping()) {
                    mapping.writeFromAttributeIntoRow(value, primaryKeyRow, this.getSession());
                    return true;
                }
                if (!mapping.isDirectToFieldMapping()) {
                    return false;
                }
                field = ((AbstractDirectMapping)mapping).getField();
            } else {
                field = descriptor.getObjectBuilder().getFieldForQueryKeyName(child.getName());
            }
        } else {
            return false;
        }
        if (field == null || !descriptor.getPrimaryKeyFields().contains(field)) {
            return false;
        }
        primaryKeyRow.put(field, value);
        return true;
    }

    public boolean isEqualNull(ExpressionSQLPrinter printer) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.operator.getSelector() != 4) {
            return false;
        }
        if (this.secondChild.isConstantExpression() && ((ConstantExpression)this.secondChild).getValue() == null) {
            return true;
        }
        return this.secondChild.isParameterExpression() && printer.getTranslationRow() != null && ((ParameterExpression)this.secondChild).getValue(printer.getTranslationRow(), printer.getSession()) == null;
    }

    public boolean isNotEqualNull(ExpressionSQLPrinter printer) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.operator.getSelector() != 5) {
            return false;
        }
        if (this.secondChild.isConstantExpression() && ((ConstantExpression)this.secondChild).getValue() == null) {
            return true;
        }
        return this.secondChild.isParameterExpression() && printer.getTranslationRow() != null && ((ParameterExpression)this.secondChild).getValue(printer.getTranslationRow(), printer.getSession()) == null;
    }

    protected boolean isObjectComparison() {
        if (this.isObjectComparisonExpression == null) {
            DatabaseMapping mapping;
            this.isObjectComparisonExpression = !this.firstChild.isObjectExpression() || ((ObjectExpression)this.firstChild).isAttribute() ? Boolean.FALSE : ((mapping = ((ObjectExpression)this.firstChild).getMapping()) != null && mapping.isDirectCollectionMapping() && !this.firstChild.isMapEntryExpression() ? Boolean.FALSE : Boolean.valueOf(this.secondChild.isObjectExpression() || this.secondChild.isValueExpression() || this.secondChild.isFunctionExpression() && ((FunctionExpression)this.secondChild).operator.isAnyOrAll()));
        }
        return this.isObjectComparisonExpression;
    }

    public boolean isRelationExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        if (!this.isObjectComparison()) {
            return super.normalize(normalizer);
        }
        this.validateNode();
        if (this.operator.getSelector() != 4 && this.operator.getSelector() != 5) {
            throw QueryException.invalidOperatorForObjectComparison(this);
        }
        if (this.secondChild.isFunctionExpression()) {
            FunctionExpression funcExp = (FunctionExpression)this.secondChild;
            if (funcExp.operator.isAnyOrAll()) {
                Expression newExp;
                SubSelectExpression subSelectExp = (SubSelectExpression)funcExp.getChildren().elementAt(1);
                ReportQuery subQuery = subSelectExp.getSubQuery();
                subQuery.getItems().clear();
                subQuery.addItem("one", new ConstantExpression(1, subQuery.getExpressionBuilder()));
                Expression subSelectCriteria = subQuery.getSelectionCriteria();
                ExpressionBuilder subBuilder = subQuery.getExpressionBuilder();
                ExpressionBuilder builder = this.firstChild.getBuilder();
                if (funcExp.operator.isAny()) {
                    subSelectCriteria = this.operator.getSelector() == 4 ? subBuilder.equal(this.firstChild).and(subSelectCriteria) : subBuilder.notEqual(this.firstChild).and(subSelectCriteria);
                    subQuery.setSelectionCriteria(subSelectCriteria);
                    newExp = builder.exists(subQuery);
                } else {
                    subSelectCriteria = this.operator.getSelector() == 4 ? subBuilder.notEqual(this.firstChild).and(subSelectCriteria) : subBuilder.equal(this.firstChild).and(subSelectCriteria);
                    subQuery.setSelectionCriteria(subSelectCriteria);
                    newExp = builder.notExists(subQuery);
                }
                return newExp.normalize(normalizer);
            }
        }
        Expression foreignKeyJoin = null;
        ObjectExpression first = (ObjectExpression)this.firstChild;
        if (first.isExpressionBuilder() && this.secondChild.isQueryKeyExpression() && !((QueryKeyExpression)this.secondChild).hasDerivedExpressions()) {
            first = (ExpressionBuilder)first.normalize(normalizer);
            Vector foreignKeyJoinPointer = new Vector(1);
            QueryKeyExpression second = (QueryKeyExpression)this.secondChild;
            if (second.hasBeenNormalized()) {
                second.setHasBeenNormalized(false);
            }
            second = (QueryKeyExpression)second.normalize(normalizer, foreignKeyJoinPointer);
            if (!foreignKeyJoinPointer.isEmpty()) {
                foreignKeyJoin = (Expression)foreignKeyJoinPointer.firstElement();
                if (first.getTableAliases() == null) {
                    TableAliasLookup tableAliases = new TableAliasLookup();
                    first.setTableAliases(tableAliases);
                    second.setTableAliases(tableAliases);
                } else {
                    second.setTableAliases(first.getTableAliases());
                }
            }
        } else if (!first.isExpressionBuilder() && !((QueryKeyExpression)first).shouldQueryToManyRelationship() && ((QueryKeyExpression)first).getMapping() != null) {
            if (first.getBaseExpression() != null) {
                first.setBaseExpression(first.getBaseExpression().normalize(normalizer));
            }
            if (this.secondChild.isConstantExpression()) {
                Object targetObject = ((ConstantExpression)this.secondChild).getValue();
                foreignKeyJoin = first.getMapping().buildObjectJoinExpression((Expression)first, targetObject, this.getSession());
            } else if (this.secondChild.isObjectExpression() || this.secondChild.isParameterExpression()) {
                foreignKeyJoin = first.getMapping().buildObjectJoinExpression((Expression)first, this.secondChild, this.getSession());
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (foreignKeyJoin == null) {
            first = (ObjectExpression)first.normalize(normalizer);
            if (this.secondChild.isConstantExpression()) {
                Expression keyExpression = first.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromObject(((ConstantExpression)this.secondChild).getValue(), this.getSession());
                foreignKeyJoin = first.twist(keyExpression, first);
            } else if (this.secondChild.isObjectExpression() || this.secondChild.isParameterExpression()) {
                foreignKeyJoin = first.twist(first.getDescriptor().getObjectBuilder().getPrimaryKeyExpression(), this.secondChild);
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (this.operator.getSelector() == 5) {
            foreignKeyJoin = foreignKeyJoin.not();
        }
        return foreignKeyJoin.normalize(normalizer);
    }

    public boolean performSelector(boolean areValuesEqual) {
        if (this.operator.getSelector() == 4) {
            return areValuesEqual;
        }
        if (this.operator.getSelector() == 5) {
            return !areValuesEqual;
        }
        throw QueryException.cannotConformExpression();
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        if (printer.getPlatform().isDynamicSQLRequiredForFunctions() && (this.firstChild.isParameterExpression() || this.firstChild.isConstantExpression()) && (this.secondChild.isParameterExpression() || this.secondChild.isConstantExpression())) {
            printer.getCall().setUsesBinding(false);
        }
        if (this.isEqualNull(printer)) {
            this.firstChild.isNull().printSQL(printer);
        } else if (this.isNotEqualNull(printer)) {
            this.firstChild.notNull().printSQL(printer);
        } else {
            super.printSQL(printer);
        }
    }

    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        Expression tempFirstChild = this.firstChild;
        Expression tempSecondChild = this.secondChild;
        realOperator.printJavaDuo(tempFirstChild, tempSecondChild, printer);
    }

    public void printSQLNoParens(ExpressionSQLPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printDuo(this.firstChild, this.secondChild, printer);
    }

    public void validateNode() {
        if (this.firstChild.isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.firstChild).getTable());
        }
        if (this.secondChild.isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.secondChild).getTable());
        }
    }
}

