/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class BatchValueHolder
extends QueryBasedValueHolder {
    protected transient ForeignReferenceMapping mapping;
    protected transient ObjectLevelReadQuery originalQuery;

    public BatchValueHolder(ReadQuery query, AbstractRecord row, ForeignReferenceMapping mapping, ObjectLevelReadQuery originalQuery) {
        super(query, row, originalQuery.getSession());
        this.mapping = mapping;
        this.originalQuery = originalQuery;
    }

    protected ForeignReferenceMapping getMapping() {
        return this.mapping;
    }

    protected Object instantiate(AbstractSession session) throws EclipseLinkException {
        return this.mapping.extractResultFromBatchQuery(this.query, this.row, session, this.originalQuery);
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        UnitOfWorkImpl unitOfWork = unitOfWorkValueHolder.getUnitOfWork();
        ReadQuery localQuery = unitOfWork.getBatchQueries().get(this.query);
        if (localQuery == null) {
            localQuery = (ReadQuery)this.query.clone();
            unitOfWork.getBatchQueries().put(this.query, localQuery);
        }
        return this.mapping.extractResultFromBatchQuery(localQuery, this.row, unitOfWorkValueHolder.getUnitOfWork(), this.originalQuery);
    }

    public boolean isEasilyInstantiated() {
        return this.isInstantiated;
    }

    protected void resetFields() {
        super.resetFields();
        this.mapping = null;
        this.originalQuery = null;
    }

    protected void setMapping(ForeignReferenceMapping mapping) {
        this.mapping = mapping;
    }
}

