/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;

public class UnitOfWorkQueryValueHolder
extends UnitOfWorkValueHolder {
    protected UnitOfWorkQueryValueHolder(ValueHolderInterface attributeValue, Object clone, DatabaseMapping mapping, UnitOfWorkImpl unitOfWork) {
        super(attributeValue, clone, mapping, unitOfWork);
    }

    public UnitOfWorkQueryValueHolder(ValueHolderInterface attributeValue, Object clone, ForeignReferenceMapping mapping, AbstractRecord row, UnitOfWorkImpl unitOfWork) {
        this(attributeValue, clone, mapping, unitOfWork);
        this.row = row;
    }

    protected Object buildBackupCloneFor(Object cloneAttributeValue) {
        return this.mapping.buildBackupCloneForPartObject(cloneAttributeValue, null, null, this.getUnitOfWork());
    }

    public Object buildCloneFor(Object originalAttributeValue) {
        return this.mapping.buildCloneForPartObject(originalAttributeValue, null, this.relationshipSourceObject, this.getUnitOfWork(), true);
    }

    public void setValue(Object theValue) {
        if (!this.isInstantiated) {
            this.instantiate();
        }
        Object oldValue = this.getValue();
        super.setValue(theValue);
        this.updateForeignReferenceSet(theValue, oldValue);
    }

    public void updateForeignReferenceRemove(Object value) {
        DatabaseMapping sourceMapping = this.getMapping();
        if (sourceMapping == null) {
            return;
        }
        if (sourceMapping.isPrivateOwned()) {
            return;
        }
        ForeignReferenceMapping partner = this.getRelationshipPartnerFor(value);
        if (partner != null && value != null) {
            Object unwrappedValue = partner.getDescriptor().getObjectBuilder().unwrapObject(value, this.getSession());
            Object oldParent = partner.getRealAttributeValueFromObject(unwrappedValue, this.getSession());
            Object sourceObject = this.getRelationshipSourceObject();
            if (oldParent == null) {
                return;
            }
            if (partner.isCollectionMapping() && (!(oldParent instanceof IndirectContainer) || ((IndirectContainer)oldParent).isInstantiated()) && !partner.getContainerPolicy().contains(sourceObject, oldParent, this.getSession())) {
                return;
            }
            if (partner.isObjectReferenceMapping()) {
                partner.setRealAttributeValueInObject(unwrappedValue, null);
            } else if (partner.isCollectionMapping()) {
                partner.getContainerPolicy().removeFrom(sourceObject, oldParent, this.getSession());
            }
        }
    }

    public void updateForeignReferenceSet(Object value, Object oldValue) {
        if (value != null && ClassConstants.Collection_Class.isAssignableFrom(value.getClass())) {
            return;
        }
        if (this.getMapping() == null) {
            return;
        }
        ForeignReferenceMapping partner = this.getRelationshipPartnerFor(value);
        if (partner != null) {
            if (value != null) {
                Object unwrappedValue = partner.getDescriptor().getObjectBuilder().unwrapObject(value, this.getSession());
                Object oldParent = partner.getRealAttributeValueFromObject(unwrappedValue, this.getSession());
                Object sourceObject = this.getRelationshipSourceObject();
                Object wrappedSource = this.getMapping().getDescriptor().getObjectBuilder().wrapObject(sourceObject, this.getSession());
                if (oldParent == sourceObject) {
                    return;
                }
                if (partner.isCollectionMapping() && (!(oldParent instanceof IndirectContainer) || ((IndirectContainer)oldParent).isInstantiated()) && partner.getContainerPolicy().contains(sourceObject, oldParent, this.getSession())) {
                    return;
                }
                if (oldParent != null) {
                    if (this.getMapping().isObjectReferenceMapping()) {
                        if (!partner.isCollectionMapping()) {
                            ((ObjectReferenceMapping)this.getMapping()).setRealAttributeValueInObject(oldParent, null);
                        }
                    } else if (this.getMapping().isCollectionMapping() && !partner.isManyToManyMapping()) {
                        this.getMapping().getContainerPolicy().removeFrom(unwrappedValue, this.getMapping().getRealAttributeValueFromObject(oldParent, this.getSession()), this.getSession());
                    }
                }
                if (oldValue != null) {
                    Object unwrappedOldValue = partner.getDescriptor().getObjectBuilder().unwrapObject(oldValue, this.getSession());
                    if (partner.isObjectReferenceMapping()) {
                        partner.setRealAttributeValueInObject(unwrappedOldValue, null);
                    } else if (partner.isCollectionMapping()) {
                        partner.getContainerPolicy().removeFrom(sourceObject, partner.getRealAttributeValueFromObject(unwrappedOldValue, this.getSession()), this.getSession());
                    }
                }
                if (partner.isObjectReferenceMapping()) {
                    partner.setRealAttributeValueInObject(unwrappedValue, wrappedSource);
                } else if (partner.isCollectionMapping()) {
                    partner.getContainerPolicy().addInto(wrappedSource, oldParent, this.getSession());
                }
            } else {
                this.updateForeignReferenceRemove(oldValue);
            }
        }
    }

    private ForeignReferenceMapping getRelationshipPartnerFor(Object partnerObject) {
        ForeignReferenceMapping partner = (ForeignReferenceMapping)this.getMapping().getRelationshipPartner();
        if (partner == null || partnerObject == null) {
            return partner;
        }
        if (partner.getDescriptor().hasInheritance()) {
            ClassDescriptor partnerObjectDescriptor = this.getSession().getDescriptor(partnerObject);
            if (!partner.getDescriptor().getJavaClass().isAssignableFrom(partnerObjectDescriptor.getJavaClass())) {
                return (ForeignReferenceMapping)partnerObjectDescriptor.getObjectBuilder().getMappingForAttributeName(partner.getAttributeName());
            }
        }
        return partner;
    }
}

