/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Vector;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class FieldResult {
    protected String attributeName;
    protected String[] multipleFieldIdentifiers;
    Vector fieldResults;
    protected DatabaseField column;

    public FieldResult(String attributeName, String columnName) {
        if (attributeName == null || columnName == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_values_for_field_result"));
        }
        this.column = new DatabaseField(columnName);
        this.multipleFieldIdentifiers = attributeName.split("\\.", 0);
        this.attributeName = this.multipleFieldIdentifiers[0];
    }

    public FieldResult(String attributeName, DatabaseField column) {
        if (attributeName == null || column == null || column.getName() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_values_for_field_result"));
        }
        this.column = column;
        this.multipleFieldIdentifiers = attributeName.split("\\.", 0);
        this.attributeName = this.multipleFieldIdentifiers[0];
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public DatabaseField getColumn() {
        return this.column;
    }

    public Object getValueFromRecord(DatabaseRecord record) {
        return record.get(this.column);
    }

    public Vector getFieldResults() {
        return this.fieldResults;
    }

    public String[] getMultipleFieldIdentifiers() {
        return this.multipleFieldIdentifiers;
    }

    public void add(FieldResult newFieldResult) {
        if (this.fieldResults == null) {
            this.fieldResults = new Vector();
            this.fieldResults.add(this);
        }
        this.fieldResults.add(newFieldResult);
    }
}

