/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;

public class PopulationManager {
    protected Hashtable registeredObjects = new Hashtable();
    protected static PopulationManager defaultManager;

    public void addAllObjectsForAbstractClass(Class objectsClass, AbstractSession session, Vector allObjects) {
        ClassDescriptor descriptor = session.getDescriptor(objectsClass);
        this.addAllObjectsForClass(objectsClass, allObjects);
        for (ClassDescriptor child : descriptor.getInheritancePolicy().getChildDescriptors()) {
            this.addAllObjectsForAbstractClass(child.getJavaClass(), session, allObjects);
        }
    }

    public void addAllObjectsForAbstractClass(Class objectsClass, Session session, Vector allObjects) {
        this.addAllObjectsForAbstractClass(objectsClass, (AbstractSession)session, allObjects);
    }

    public void addAllObjectsForClass(Class objectsClass, Vector allObjects) {
        if (!this.getRegisteredObjects().containsKey(objectsClass)) {
            return;
        }
        Enumeration enumeration = ((Hashtable)this.getRegisteredObjects().get(objectsClass)).elements();
        while (enumeration.hasMoreElements()) {
            allObjects.addElement(enumeration.nextElement());
        }
    }

    public boolean containsObject(Class objectsClass, String objectsName) {
        return this.getRegisteredObjects().containsKey(objectsClass) && ((Hashtable)this.getRegisteredObjects().get(objectsClass)).containsKey(objectsName);
    }

    public boolean containsObject(Object objectToCheck, String objectsName) {
        return this.containsObject(objectToCheck.getClass(), objectsName);
    }

    public Vector getAllClasses() {
        Vector allClasses = new Vector();
        Enumeration e = this.getRegisteredObjects().keys();
        while (e.hasMoreElements()) {
            allClasses.addElement(e.nextElement());
        }
        return allClasses;
    }

    public Vector getAllObjects() {
        Vector allObjects = new Vector();
        Enumeration e = this.getAllClasses().elements();
        while (e.hasMoreElements()) {
            Class eachClass = (Class)e.nextElement();
            this.addAllObjectsForClass(eachClass, allObjects);
        }
        return allObjects;
    }

    public Vector getAllObjectsForAbstractClass(Class objectsClass) {
        Vector allObjects = new Vector();
        return allObjects;
    }

    public Vector getAllObjectsForAbstractClass(Class objectsClass, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(objectsClass);
        Vector allObjects = new Vector();
        this.addAllObjectsForClass(objectsClass, allObjects);
        if (descriptor.hasInheritance()) {
            for (ClassDescriptor child : descriptor.getInheritancePolicy().getChildDescriptors()) {
                this.addAllObjectsForClass(child.getJavaClass(), allObjects);
            }
        }
        return allObjects;
    }

    public Vector getAllObjectsForClass(Class objectsClass) {
        Vector allObjects = new Vector();
        this.addAllObjectsForClass(objectsClass, allObjects);
        return allObjects;
    }

    public static PopulationManager getDefaultManager() {
        if (defaultManager == null) {
            defaultManager = new PopulationManager();
        }
        return defaultManager;
    }

    public Object getObject(Class objectsClass, String objectsName) {
        if (!this.getRegisteredObjects().containsKey(objectsClass)) {
            return null;
        }
        return ((Hashtable)this.getRegisteredObjects().get(objectsClass)).get(objectsName);
    }

    public Hashtable getRegisteredObjects() {
        return this.registeredObjects;
    }

    public Object registerObject(Class javaClass, Object objectToRegister, String objectsName) {
        if (!this.getRegisteredObjects().containsKey(javaClass)) {
            this.getRegisteredObjects().put(javaClass, new Hashtable());
        }
        ((Hashtable)this.getRegisteredObjects().get(javaClass)).put(objectsName, objectToRegister);
        return objectToRegister;
    }

    public Object registerObject(Object objectToRegister, String objectsName) {
        if (!this.getRegisteredObjects().containsKey(objectToRegister.getClass())) {
            this.getRegisteredObjects().put(objectToRegister.getClass(), new Hashtable());
        }
        ((Hashtable)this.getRegisteredObjects().get(objectToRegister.getClass())).put(objectsName, objectToRegister);
        return objectToRegister;
    }

    public void removeObject(Class classToRemove, String objectsName) {
        if (this.getRegisteredObjects().containsKey(classToRemove)) {
            ((Hashtable)this.getRegisteredObjects().get(classToRemove)).remove(objectsName);
        }
    }

    public Object removeObject(Object objectToRemove, String objectsName) {
        this.removeObject(objectToRemove.getClass(), objectsName);
        return objectToRemove;
    }

    public static void resetDefaultManager() {
        defaultManager = null;
    }

    public static void setDefaultManager(PopulationManager theDefaultManager) {
        defaultManager = theDefaultManager;
    }

    public void setRegisteredObjects(Hashtable registeredObjects) {
        this.registeredObjects = registeredObjects;
    }
}

