/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.logging.Level;

public abstract class ASMainNonOSGi
extends PlatformMain {
    protected void flushAndCreate(File cacheDir, long lastModified) throws IOException {
        if (cacheDir.exists() && cacheDir.isDirectory()) {
            this.getLogger().info("Removing cache dir " + cacheDir + " left from a previous run");
            if (!ASMainHelper.deleteRecursive(cacheDir)) {
                this.getLogger().warning("Not able to delete " + cacheDir);
            }
        }
        if (!this.createCache(cacheDir)) {
            throw new IOException("Could not create cache");
        }
        try {
            this.saveCacheInformation(cacheDir, cacheDir.toURI().toURL().toString(), lastModified);
        }
        catch (MalformedURLException e) {
            this.getLogger().log(Level.SEVERE, "Could not save cache metadata, cache will be reset at next startup", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadCacheInformation(File cacheDir) {
        long recordedLastModified = 0L;
        Properties persistedInfo = new Properties();
        File lastModifiedFile = new File(cacheDir.getParentFile(), cacheDir.getName() + ".lastmodified");
        if (lastModifiedFile.exists()) {
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(lastModifiedFile));
                persistedInfo.load(is);
                try {
                    recordedLastModified = Long.parseLong(persistedInfo.getProperty("LastModified"));
                    String location = persistedInfo.getProperty("Location");
                    if (!cacheDir.toURI().toURL().toString().equals(location)) {
                        recordedLastModified = 0L;
                    }
                }
                catch (NumberFormatException e) {
                    recordedLastModified = 0L;
                }
            }
            catch (IOException e) {
                this.getLogger().info("Cannot read recorded lastModified, OSGi cache will be flushed");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return persistedInfo;
    }

    private long parse(Properties info, String name) {
        try {
            return Long.parseLong(info.getProperty(name));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCacheInformation(File cacheDir, String location, long lastModified) {
        ObjectOutputStream os = null;
        File lastModifiedFile = new File(cacheDir.getParentFile(), cacheDir.getName() + ".lastmodified");
        try {
            lastModifiedFile.delete();
            if (!lastModifiedFile.createNewFile()) {
                this.getLogger().warning("Cannot create new lastModified file");
                return;
            }
            os = new ObjectOutputStream(new FileOutputStream(lastModifiedFile));
            Properties persistedInfo = new Properties();
            persistedInfo.put("LastModified", new Long(lastModified).toString());
            persistedInfo.put("Location", cacheDir.toURI().toURL().toString());
            persistedInfo.store(os, null);
        }
        catch (IOException e) {
            this.getLogger().info("Cannot create record of lastModified file");
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    boolean isCacheOutdated(long lastModified, File cacheDir) {
        Properties persistedInfo = this.loadCacheInformation(cacheDir);
        long recordedLastModified = this.parse(persistedInfo, "LastModified");
        String location = persistedInfo.getProperty("Location");
        try {
            if (!cacheDir.toURI().toURL().toString().equals(location)) {
                recordedLastModified = 0L;
            }
        }
        catch (MalformedURLException e) {
            this.getLogger().log(Level.SEVERE, "Could not load cache metadata, cache will be reset", e);
            recordedLastModified = 0L;
        }
        return recordedLastModified != lastModified;
    }

    abstract boolean createCache(File var1) throws IOException;
}

