/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.ThreadPool;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-threadpool")
@Scoped(value=PerLookup.class)
@I18n(value="delete.threadpool")
public class DeleteThreadpool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteThreadpool.class);
    @Param(name="threadpool_id", primary=true)
    String threadpool_id;
    @Param(optional=true)
    String target = "server";
    @Inject
    Configs configs;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        ThreadPools threadPools = config.getThreadPools();
        if (!this.isThreadPoolExists(threadPools)) {
            report.setMessage(localStrings.getLocalString("delete.threadpool.notexists", "Thread Pool named {0} does not exist.", new Object[]{this.threadpool_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ThreadPool pool = (ThreadPool)this.habitat.getComponent(ThreadPool.class, this.threadpool_id);
        List nwlsnrList = pool.findNetworkListeners();
        for (NetworkListener nwlsnr : nwlsnrList) {
            if (!pool.getName().equals(nwlsnr.getThreadPool())) continue;
            report.setMessage(localStrings.getLocalString("delete.threadpool.beingused", "{0} threadpool is being used in the network listener {1}", new Object[]{this.threadpool_id, nwlsnr.getName()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<ThreadPools>(){

                @Override
                public Object run(ThreadPools param) throws PropertyVetoException, TransactionFailure {
                    List poolList = param.getThreadPool();
                    for (ThreadPool pool : poolList) {
                        String currPoolId = pool.getName();
                        if (currPoolId == null || !currPoolId.equals(DeleteThreadpool.this.threadpool_id)) continue;
                        poolList.remove(pool);
                        break;
                    }
                    return poolList;
                }
            }, threadPools);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            String str = e.getMessage();
            report.setMessage(localStrings.getLocalString("delete.threadpool.failed", "Delete Thread Pool failed because of: ", new Object[]{str}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }

    private boolean isThreadPoolExists(ThreadPools threadPools) {
        for (ThreadPool pool : threadPools.getThreadPool()) {
            String currPoolId = pool.getName();
            if (currPoolId == null || !currPoolId.equals(this.threadpool_id)) continue;
            return true;
        }
        return false;
    }
}

