/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.container.Sniffer;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=Singleton.class)
public class WebContainerStarter
implements Startup,
PostConstruct,
ConfigListener {
    private static final Logger logger = LogDomains.getLogger(WebContainerStarter.class, (String)"javax.enterprise.system.container.web");
    private static final String AUTH_PASSTHROUGH_ENABLED_PROP = "authPassthroughEnabled";
    private static final String PROXY_HANDLER_PROP = "proxyHandler";
    private static final String TRACE_ENABLED_PROP = "traceEnabled";
    @Inject
    Domain domain;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    ContainerStarter containerStarter;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    HttpService httpService;
    @Inject
    NetworkConfig networkConfig;
    @Inject
    private Habitat habitat;

    public void postConstruct() {
        boolean isStartNeeded = false;
        List configs = this.domain.getConfigs().getConfig();
        for (Config config : configs) {
            if (this.isStartNeeded(config.getHttpService())) {
                isStartNeeded = true;
                break;
            }
            if (!this.isStartNeeded(config.getNetworkConfig())) continue;
            isStartNeeded = true;
            break;
        }
        if (isStartNeeded) {
            this.startWebContainer();
        } else {
            ObservableBean bean = (ObservableBean)((Object)ConfigSupport.getImpl((ConfigBeanProxy)this.httpService));
            bean.addListener(this);
            bean = (ObservableBean)((Object)ConfigSupport.getImpl((ConfigBeanProxy)this.networkConfig.getNetworkListeners()));
            bean.addListener(this);
        }
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (t instanceof HttpService) {
                    if (type == Changed.TYPE.CHANGE && WebContainerStarter.this.isStartNeeded((HttpService)t)) {
                        WebContainerStarter.this.startWebContainer();
                    }
                } else if (t instanceof VirtualServer) {
                    if ((type == Changed.TYPE.ADD || type == Changed.TYPE.CHANGE) && WebContainerStarter.this.isStartNeeded((VirtualServer)t)) {
                        WebContainerStarter.this.startWebContainer();
                    }
                } else if (t instanceof NetworkListener && (type == Changed.TYPE.ADD || type == Changed.TYPE.CHANGE) && WebContainerStarter.this.isStartNeeded((NetworkListener)t)) {
                    WebContainerStarter.this.startWebContainer();
                }
                return null;
            }
        }, logger);
    }

    private void startWebContainer() {
        Sniffer webSniffer = (Sniffer)this.habitat.getComponent(Sniffer.class, "web");
        if (webSniffer == null) {
            logger.info("Web container not installed");
            return;
        }
        if (this.containerRegistry.getContainer(webSniffer.getContainersNames()[0]) != null) {
            this.containerRegistry.getContainer(webSniffer.getContainersNames()[0]).getContainer();
        } else {
            Module snifferModule = this.modulesRegistry.find(webSniffer.getClass());
            try {
                Collection<EngineInfo> containersInfo = this.containerStarter.startContainer(webSniffer, snifferModule);
                if (containersInfo != null && !containersInfo.isEmpty()) {
                    for (EngineInfo info : containersInfo) {
                        info.getContainer();
                        if (!logger.isLoggable(Level.INFO)) continue;
                        logger.info("Done with starting " + webSniffer.getModuleType() + " container");
                    }
                } else {
                    logger.severe("Unable to start container (no exception provided)");
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to start container " + webSniffer.getContainersNames()[0], e);
            }
        }
    }

    private boolean isStartNeeded(HttpService httpService) {
        List hosts;
        if (httpService == null) {
            return false;
        }
        if (ConfigBeansUtilities.toBoolean((String)httpService.getAccessLoggingEnabled()) || ConfigBeansUtilities.toBoolean((String)httpService.getSsoEnabled())) {
            return true;
        }
        List props = httpService.getProperty();
        if (props != null) {
            for (Property prop : props) {
                String propName = prop.getName();
                String propValue = prop.getValue();
                if (AUTH_PASSTHROUGH_ENABLED_PROP.equals(propName)) {
                    if (!ConfigBeansUtilities.toBoolean((String)propValue)) continue;
                    return true;
                }
                if (PROXY_HANDLER_PROP.equals(propName)) {
                    return true;
                }
                if (!TRACE_ENABLED_PROP.equals(propName) || ConfigBeansUtilities.toBoolean((String)propValue)) continue;
                return true;
            }
        }
        if ((hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if (!this.isStartNeeded(host)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStartNeeded(VirtualServer host) {
        if (host == null) {
            return false;
        }
        if (ConfigBeansUtilities.toBoolean((String)host.getAccessLoggingEnabled()) || ConfigBeansUtilities.toBoolean((String)host.getSsoEnabled())) {
            return true;
        }
        String state = host.getState();
        if (state != null && ("disabled".equals(state) || !ConfigBeansUtilities.toBoolean((String)state))) {
            return true;
        }
        List props = host.getProperty();
        return props != null && !props.isEmpty();
    }

    private boolean isStartNeeded(NetworkConfig networkConfig) {
        if (networkConfig == null) {
            return false;
        }
        NetworkListeners networkListeners = networkConfig.getNetworkListeners();
        if (networkListeners == null) {
            return false;
        }
        for (NetworkListener networkListener : networkListeners.getNetworkListener()) {
            if (!this.isStartNeeded(networkListener)) continue;
            return true;
        }
        return false;
    }

    private boolean isStartNeeded(NetworkListener networkListener) {
        if (networkListener == null) {
            return false;
        }
        return ConfigBeansUtilities.toBoolean((String)networkListener.getJkEnabled());
    }
}

