/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.PoolException;
import com.sun.enterprise.util.Utility;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;

public class NonBlockingPool
extends AbstractPool {
    private String poolName;
    private TimerTask poolTimerTask;
    protected boolean addedResizeTask = false;
    protected volatile boolean addedIdleBeanWork = false;
    protected boolean inResizing = false;
    private boolean maintainSteadySize = false;
    private boolean poolClosed = false;
    private int resizeTaskCount;
    private int timerTaskCount;

    protected NonBlockingPool() {
    }

    public NonBlockingPool(long beanId, String poolName, ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this.poolName = poolName;
        this.beanId = beanId;
        this.initializePool(factory, steadyPoolSize, resizeQuantity, maxPoolSize, idleTimeoutInSeconds, loader);
    }

    protected void initializePool(ObjectFactory factory, int steadyPoolSize, int resizeQuantity, int maxPoolSize, int idleTimeoutInSeconds, ClassLoader loader) {
        this.list = new ArrayList();
        this.factory = factory;
        this.steadyPoolSize = steadyPoolSize <= 0 ? 0 : steadyPoolSize;
        this.resizeQuantity = resizeQuantity <= 0 ? 0 : resizeQuantity;
        this.maxPoolSize = maxPoolSize <= 0 ? Integer.MAX_VALUE : maxPoolSize;
        this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        this.idleTimeoutInSeconds = idleTimeoutInSeconds <= 0 ? 0 : idleTimeoutInSeconds;
        this.containerClassLoader = loader;
        boolean bl = this.maintainSteadySize = this.steadyPoolSize > 0;
        if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) {
            try {
                this.poolTimerTask = new PoolResizeTimerTask();
                EjbContainerUtilImpl.getInstance().getTimer().scheduleAtFixedRate(this.poolTimerTask, (long)idleTimeoutInSeconds * 1000L, (long)idleTimeoutInSeconds * 1000L);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                }
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Could not add" + " PoolTimerTask. Continuing anyway...", th);
            }
        }
    }

    public void setContainerClassLoader(ClassLoader loader) {
        this.containerClassLoader = loader;
    }

    public Object getObject(boolean canWait, Object param) throws PoolException {
        return this.getObject(param);
    }

    public Object getObject(long maxWaitTime, Object param) throws PoolException {
        return this.getObject(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object getObject(Object param) {
        Object obj;
        boolean toAddResizeTask;
        block13: {
            toAddResizeTask = false;
            obj = null;
            ArrayList arrayList = this.list;
            // MONITORENTER : arrayList
            int size = this.list.size();
            if (size > this.steadyPoolSize) {
                ++this.poolSuccess;
                // MONITOREXIT : arrayList
                return this.list.remove(size - 1);
            }
            if (size > 0) {
                ++this.poolSuccess;
                if (this.maintainSteadySize && !this.addedResizeTask) {
                    this.addedResizeTask = true;
                    toAddResizeTask = true;
                    obj = this.list.remove(size - 1);
                    break block13;
                } else {
                    // MONITOREXIT : arrayList
                    return this.list.remove(size - 1);
                }
            }
            if (this.maintainSteadySize && !this.addedResizeTask) {
                this.addedResizeTask = true;
                toAddResizeTask = true;
            }
            this.poolProbeNotifier.ejbObjectAddedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.createdCount;
        }
        // MONITOREXIT : arrayList
        if (toAddResizeTask) {
            this.addResizeTaskForImmediateExecution();
        }
        if (obj != null) {
            return obj;
        }
        try {
            return this.factory.create(param);
        }
        catch (RuntimeException th) {
            ArrayList arrayList = this.list;
            // MONITORENTER : arrayList
            this.poolProbeNotifier.ejbObjectAddFailedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            --this.createdCount;
            // MONITOREXIT : arrayList
            throw th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResizeTaskForImmediateExecution() {
        block6: {
            try {
                ReSizeWork work = new ReSizeWork();
                EjbContainerUtilImpl.getInstance().addWork(work);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                }
                ++this.resizeTaskCount;
            }
            catch (Exception ex) {
                ArrayList arrayList = this.list;
                synchronized (arrayList) {
                    this.addedResizeTask = false;
                }
                if (!_logger.isLoggable(Level.WARNING)) break block6;
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Cannot perform " + " pool resize task", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.list.size() < this.maxPoolSize) {
                this.list.add(object);
                return;
            }
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in returnObj", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "exception in destroyObject", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload(int count) {
        int sz;
        ArrayList<Object> instances = new ArrayList<Object>(count);
        try {
            for (int i = 0; i < count; ++i) {
                instances.add(this.factory.create(null));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if ((sz = instances.size()) == 0) {
            return;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            for (int i = 0; i < sz; ++i) {
                this.list.add(instances.get(i));
                this.poolProbeNotifier.ejbObjectAddedEvent(this.beanId, this.appName, this.modName, this.ejbName);
            }
            this.createdCount += sz;
        }
    }

    public void prepopulate(int count) {
        this.steadyPoolSize = count <= 0 ? 0 : count;
        int n = this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        if (this.steadyPoolSize > 0) {
            this.preload(this.steadyPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Cancelled pool timer task " + " at: " + new Date());
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Destroying " + this.list.size() + " beans from the pool...");
            }
            ClassLoader origLoader = Utility.setContextClassLoader((ClassLoader)this.containerClassLoader);
            Object[] array = this.list.toArray();
            for (int i = 0; i < array.length; ++i) {
                try {
                    this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                    ++this.destroyedCount;
                    try {
                        this.factory.destroy(array[i]);
                    }
                    catch (Throwable th) {
                        _logger.log(Level.FINE, "exception in close", th);
                    }
                    continue;
                }
                catch (Throwable th) {
                    _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Error while destroying", th);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Pool-" + this.poolName + "]: Pool closed....");
            }
            this.list.clear();
            this.unregisterProbeProvider();
            Utility.setContextClassLoader((ClassLoader)origLoader);
            this.poolClosed = true;
            this.list = null;
            this.factory = null;
            this.poolTimerTask = null;
            this.containerClassLoader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int count) {
        ArrayList removeList = new ArrayList();
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            for (int i = 0; i < count && size > 0; ++i) {
                removeList.add(this.list.remove(--size));
                this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                ++this.destroyedCount;
            }
        }
        int sz = removeList.size();
        for (int i = 0; i < sz; ++i) {
            try {
                this.factory.destroy(removeList.get(i));
                continue;
            }
            catch (Throwable th) {
                _logger.log(Level.FINE, "exception in remove", th);
            }
        }
    }

    protected void removeIdleObjects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doResize() {
        long startTime;
        block52: {
            if (this.poolClosed) {
                return;
            }
            final Thread currentThread = Thread.currentThread();
            ClassLoader previousClassLoader = currentThread.getContextClassLoader();
            final ClassLoader ctxClassLoader = this.containerClassLoader;
            startTime = 0L;
            boolean enteredResizeBlock = false;
            try {
                block51: {
                    try {
                        if (System.getSecurityManager() == null) {
                            currentThread.setContextClassLoader(ctxClassLoader);
                        } else {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    currentThread.setContextClassLoader(ctxClassLoader);
                                    return null;
                                }
                            });
                        }
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize started at: " + new Date() + " steadyPoolSize ::" + this.steadyPoolSize + " resizeQuantity ::" + this.resizeQuantity + " maxPoolSize ::" + this.maxPoolSize);
                        }
                        startTime = System.currentTimeMillis();
                        ArrayList removeList = new ArrayList();
                        long populateCount = 0L;
                        ArrayList arrayList = this.list;
                        // MONITORENTER : arrayList
                        if (this.inResizing || this.poolClosed) {
                            // MONITOREXIT : arrayList
                            Object var19_12 = null;
                            if (enteredResizeBlock) {
                                ArrayList arrayList2 = this.list;
                                // MONITORENTER : arrayList2
                                this.inResizing = false;
                                // MONITOREXIT : arrayList2
                            }
                            if (System.getSecurityManager() == null) {
                                currentThread.setContextClassLoader(previousClassLoader);
                                return;
                            }
                            AccessController.doPrivileged(new PrivilegedAction(currentThread, previousClassLoader){
                                final /* synthetic */ Thread val$currentThread;
                                final /* synthetic */ ClassLoader val$previousClassLoader;
                                {
                                    this.val$currentThread = thread;
                                    this.val$previousClassLoader = classLoader;
                                }

                                public Object run() {
                                    this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                                    return null;
                                }
                            });
                            return;
                        }
                        enteredResizeBlock = true;
                        this.inResizing = true;
                        int curSize = this.list.size();
                        if (curSize > this.steadyPoolSize) {
                            EJBContextImpl ctx;
                            if (this.idleTimeoutInSeconds <= 0 || this.resizeQuantity <= 0) {
                                // MONITOREXIT : arrayList
                                Object var19_13 = null;
                                if (enteredResizeBlock) {
                                    ArrayList arrayList3 = this.list;
                                    // MONITORENTER : arrayList3
                                    this.inResizing = false;
                                    // MONITOREXIT : arrayList3
                                }
                                if (System.getSecurityManager() == null) {
                                    currentThread.setContextClassLoader(previousClassLoader);
                                    return;
                                }
                                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            int victimCount = curSize > this.steadyPoolSize + this.resizeQuantity ? this.resizeQuantity : curSize - this.steadyPoolSize;
                            long allowedIdleTime = System.currentTimeMillis() - (long)this.idleTimeoutInSeconds * 1000L;
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize:: reducing " + " pool size by: " + victimCount);
                            }
                            for (int i = 0; i < victimCount && (ctx = (EJBContextImpl)this.list.get(0)).getLastTimeUsed() <= allowedIdleTime; ++this.destroyedCount, ++i) {
                                removeList.add(this.list.remove(0));
                                this.poolProbeNotifier.ejbObjectDestroyedEvent(this.beanId, this.appName, this.modName, this.ejbName);
                            }
                        } else if (curSize < this.steadyPoolSize) {
                            if (!this.maintainSteadySize) {
                                // MONITOREXIT : arrayList
                                Object var19_14 = null;
                                if (enteredResizeBlock) {
                                    ArrayList arrayList4 = this.list;
                                    // MONITORENTER : arrayList4
                                    this.inResizing = false;
                                    // MONITOREXIT : arrayList4
                                }
                                if (System.getSecurityManager() == null) {
                                    currentThread.setContextClassLoader(previousClassLoader);
                                    return;
                                }
                                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            if (this.resizeQuantity <= 0) {
                                populateCount = this.steadyPoolSize - curSize;
                            } else {
                                while ((long)curSize + populateCount < (long)this.steadyPoolSize) {
                                    populateCount += (long)this.resizeQuantity;
                                }
                                if ((long)curSize + populateCount > (long)this.maxPoolSize) {
                                    populateCount -= (long)curSize + populateCount - (long)this.maxPoolSize;
                                }
                            }
                        }
                        // MONITOREXIT : arrayList
                        if (removeList.size() > 0) {
                            int sz = removeList.size();
                            for (int i = 0; i < sz; ++i) {
                                try {
                                    this.factory.destroy(removeList.get(i));
                                    continue;
                                }
                                catch (Throwable th) {
                                    _logger.log(Level.FINE, "exception in doResize", th);
                                }
                            }
                        }
                        if (populateCount <= 0L) break block51;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Attempting to preload " + populateCount + " beans. CurSize/MaxPoolSize: " + this.list.size() + "/" + this.maxPoolSize);
                        }
                        this.preload((int)populateCount);
                        if (!_logger.isLoggable(Level.FINE)) break block51;
                        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: After preload " + "CurSize/MaxPoolSize: " + this.list.size() + "/" + this.maxPoolSize);
                    }
                    catch (Throwable th) {
                        _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Exception during reSize", th);
                        Object var19_16 = null;
                        if (enteredResizeBlock) {
                            ArrayList arrayList = this.list;
                            // MONITORENTER : arrayList
                            this.inResizing = false;
                            // MONITOREXIT : arrayList
                        }
                        if (System.getSecurityManager() == null) {
                            currentThread.setContextClassLoader(previousClassLoader);
                            break block52;
                        } else {
                            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                }
                Object var19_15 = null;
                if (enteredResizeBlock) {
                    ArrayList arrayList = this.list;
                    // MONITORENTER : arrayList
                    this.inResizing = false;
                    // MONITOREXIT : arrayList
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                } else {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
            }
            catch (Throwable throwable) {
                Object var19_17 = null;
                if (enteredResizeBlock) {
                    ArrayList arrayList = this.list;
                    // MONITORENTER : arrayList
                    this.inResizing = false;
                    // MONITOREXIT : arrayList
                }
                if (System.getSecurityManager() == null) {
                    currentThread.setContextClassLoader(previousClassLoader);
                    throw throwable;
                }
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        long endTime = System.currentTimeMillis();
        if (!_logger.isLoggable(Level.FINE)) return;
        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize completed at: " + new Date() + "; after reSize: " + this.getAllAttrValues());
        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize took: " + (double)(endTime - startTime) / 1000.0 + " seconds.");
    }

    public String getAllAttrValues() {
        StringBuffer sbuf = new StringBuffer("[Pool-" + this.poolName + "] ");
        sbuf.append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("CS=").append(this.list.size()).append("; ").append("SS=").append(this.steadyPoolSize).append("; ").append("MS=").append(this.maxPoolSize).append(";");
        return sbuf.toString();
    }

    private class IdleBeanWork
    implements Runnable {
        private IdleBeanWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    NonBlockingPool.this.doResize();
                }
                catch (Exception exception) {
                    Object var3_2 = null;
                    NonBlockingPool.this.addedIdleBeanWork = false;
                }
                Object var3_1 = null;
                NonBlockingPool.this.addedIdleBeanWork = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                NonBlockingPool.this.addedIdleBeanWork = false;
                throw throwable;
            }
        }
    }

    private class PoolResizeTimerTask
    extends TimerTask {
        Object lock;

        PoolResizeTimerTask() {
        }

        PoolResizeTimerTask(Object lock) {
            this.lock = lock;
        }

        public void run() {
            try {
                if (NonBlockingPool.this.addedIdleBeanWork) {
                    return;
                }
                NonBlockingPool.this.addedIdleBeanWork = true;
                IdleBeanWork work = new IdleBeanWork();
                EjbContainerUtilImpl.getInstance().addWork(work);
            }
            catch (Exception ex) {
                NonBlockingPool.this.addedIdleBeanWork = false;
                AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Cannot perform " + " pool idle bean cleanup", ex);
            }
        }
    }

    private class ReSizeWork
    implements Runnable {
        private ReSizeWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ArrayList arrayList;
            try {
                try {
                    NonBlockingPool.this.doResize();
                }
                catch (Exception ex) {
                    AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Exception during reSize", ex);
                    Object var3_2 = null;
                    ArrayList arrayList3 = NonBlockingPool.this.list;
                    synchronized (arrayList3) {
                        NonBlockingPool.this.addedResizeTask = false;
                        return;
                    }
                }
                Object var3_1 = null;
                arrayList = NonBlockingPool.this.list;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ArrayList arrayList2 = NonBlockingPool.this.list;
                synchronized (arrayList2) {
                    NonBlockingPool.this.addedResizeTask = false;
                    throw throwable;
                }
            }
            synchronized (arrayList) {
                NonBlockingPool.this.addedResizeTask = false;
                return;
            }
        }
    }
}

