/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.PrintStream;
import java.util.logging.Level;

class AckQueue
extends SessionQueue
implements Traceable {
    protected static long DEFAULT_TIMEOUT = 120000L;
    private boolean debug = Debug.debug;
    private static int DEFAULT_DUMP_COUNTER = 3;
    private static boolean dumpConnectionState = true;

    public AckQueue() {
    }

    public AckQueue(boolean bl, int n) {
        super(bl, n);
    }

    protected synchronized Object dequeueWait(ConnectionImpl connectionImpl, ReadWritePacket readWritePacket, long l) {
        long l2 = 0L;
        long l3 = DEFAULT_TIMEOUT;
        long l4 = l;
        int n = 0;
        if (l > 0L && l < DEFAULT_TIMEOUT) {
            l3 = l;
        }
        while (this.isEmpty() && !this.isClosed) {
            if (n > 0) {
                // empty if block
            }
            try {
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isEmpty() || this.isClosed) continue;
            if (this.shouldExit(connectionImpl)) {
                return null;
            }
            String string = String.valueOf((l2 += l3) / 1000L);
            this.printInfo(connectionImpl, readWritePacket, string);
            if (++n == DEFAULT_DUMP_COUNTER) {
                String string2 = "[Informational]: \n" + readWritePacket.toVerboseString();
                ConnectionImpl.connectionLogger.log(Level.WARNING, string2);
                if (dumpConnectionState) {
                    connectionImpl.printDebugState();
                }
            }
            if (l > 0L) {
                if ((l4 -= l3) > 0L) {
                    if (l4 < (l3 *= 2L)) {
                        l3 = l4;
                    }
                } else {
                    this.isClosed = true;
                }
            } else {
                l3 *= 2L;
            }
            if (!this.debug) continue;
            Debug.println("*** wait time out: " + l3);
        }
        if (this.isClosed) {
            return null;
        }
        return this.dequeue();
    }

    private boolean shouldExit(ConnectionImpl connectionImpl) {
        return connectionImpl.connectionIsBroken || connectionImpl.protocolHandler == null || connectionImpl.recoverInProcess;
    }

    protected void resend(ConnectionImpl connectionImpl, ReadWritePacket readWritePacket) {
        try {
            boolean bl = this.checkPacketType(connectionImpl, readWritePacket);
            if (bl) {
                connectionImpl.protocolHandler.resend(readWritePacket);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.isClosed = true;
        }
    }

    private boolean checkPacketType(ConnectionImpl connectionImpl, ReadWritePacket readWritePacket) {
        if (!connectionImpl.isConnectedToHABroker) {
            return false;
        }
        boolean bl = false;
        int n = readWritePacket.getPacketType();
        switch (n) {
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 28: 
            case 34: 
            case 46: 
            case 48: 
            case 50: 
            case 56: 
            case 68: 
            case 76: 
            case 78: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    protected void printInfo(ConnectionImpl connectionImpl, ReadWritePacket readWritePacket, String string) {
        String string2 = PacketType.getString(readWritePacket.getPacketType());
        String string3 = AdministeredObject.cr.getKString("W2003", string2, string);
        string3 = string3 + ", broker addr=" + connectionImpl.getProtocolHandler().getConnectionHandler().getBrokerAddress() + ", connectionID=" + connectionImpl.connectionID + ", clientID=" + connectionImpl.clientID + ", consumerID=" + readWritePacket.getConsumerID();
        ConnectionImpl.connectionLogger.log(Level.WARNING, string3);
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ AckQueue dump ------");
        printStream.println("isEmpty: " + this.isEmpty());
        printStream.println("isClosed: " + this.isClosed);
        if (this.size() > 0) {
            printStream.println("^^^^^^ ack queue super class dump ^^^^^^");
            super.dump(printStream);
            printStream.println("^^^^^^ end ack queue super class dump ^^^^^^");
        }
    }

    static {
        try {
            boolean bl;
            String string;
            String string2 = System.getProperty("imq.ackWaitTime");
            if (string2 != null) {
                DEFAULT_TIMEOUT = Long.parseLong(string2);
            }
            if ((string = System.getProperty("imq.ackDumpCount")) != null) {
                DEFAULT_DUMP_COUNTER = Integer.parseInt(string);
            }
            if (bl = Boolean.getBoolean("imq.noConnectionState")) {
                dumpConnectionState = false;
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }
}

