/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerMetricsMonitor;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.DestListMonitor;
import com.sun.messaging.jmq.jmsserver.core.DestMonitor;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.JVMMonitor;
import com.sun.messaging.jmq.jmsserver.core.Monitor;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimerTask;

public class BrokerMonitor {
    private static final long DEFAULT_INTERVAL = 60L;
    private static final boolean DEFAULT_PERSIST = false;
    private static final long DEFAULT_TTL = 300L;
    private static final boolean DEFAULT_ENABLED = true;
    private static String METRICS_PROP_PREFIX = "imq.metrics.topic.";
    private static String METRICS_TIME_PROP = METRICS_PROP_PREFIX + "interval";
    private static String PERSIST_PROP = METRICS_PROP_PREFIX + "persist";
    private static String TTL_PROP = METRICS_PROP_PREFIX + "timetolive";
    private static String ENABLED_PROP = METRICS_PROP_PREFIX + "enabled";
    public static long METRICS_TIME = Globals.getConfig().getLongProperty(METRICS_TIME_PROP, 60L) * 1000L;
    public static boolean PERSIST = Globals.getConfig().getBooleanProperty(PERSIST_PROP, false);
    public static long TTL = Globals.getConfig().getLongProperty(TTL_PROP, 300L) * 1000L;
    public static boolean ENABLED = Globals.getConfig().getBooleanProperty(ENABLED_PROP, true);
    private static MQTimer timer = Globals.getTimer();
    Logger logger = Globals.getLogger();
    Monitor monitor = null;
    private static HashSet active = new HashSet();
    private static TimerTask task = null;
    boolean valid = true;
    boolean started = false;
    private static ConfigListener cl = new ConfigListener(){

        public void validate(String string, String string2) throws PropertyUpdateException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean update(String string, String string2) {
            BrokerConfig brokerConfig = Globals.getConfig();
            if (string.equals(METRICS_TIME_PROP)) {
                METRICS_TIME = Globals.getConfig().getLongProperty(METRICS_TIME_PROP, 60L) * 1000L;
                HashSet hashSet = active;
                synchronized (hashSet) {
                    if (task != null) {
                        task.cancel();
                        task = new NotificationTask();
                        try {
                            timer.schedule(task, METRICS_TIME, METRICS_TIME);
                        }
                        catch (IllegalStateException illegalStateException) {
                            Globals.getLogger().log(8, "Internal Error: Shutting down metrics, timer has been canceled", (Throwable)illegalStateException);
                        }
                    }
                }
            }
            if (string.equals(PERSIST_PROP)) {
                PERSIST = Globals.getConfig().getBooleanProperty(PERSIST_PROP, false);
            } else if (string.equals(TTL_PROP)) {
                TTL = Globals.getConfig().getLongProperty(TTL_PROP, 300L) * 1000L;
            } else if (string.equals(ENABLED_PROP)) {
                ENABLED = Globals.getConfig().getBooleanProperty(ENABLED_PROP, true);
            }
            return true;
        }
    };

    public static void shutdownMonitor() {
        if (task != null) {
            task.cancel();
        }
        active.clear();
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.removeListener(METRICS_TIME_PROP, cl);
        brokerConfig.removeListener(PERSIST_PROP, cl);
        brokerConfig.removeListener(TTL_PROP, cl);
        cl = null;
    }

    public static void init() {
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener(METRICS_TIME_PROP, cl);
        brokerConfig.addListener(PERSIST_PROP, cl);
        brokerConfig.addListener(TTL_PROP, cl);
        brokerConfig.addListener(ENABLED_PROP, cl);
    }

    public BrokerMonitor(Destination destination) throws IllegalArgumentException, BrokerException {
        this.monitor = this.createMonitor(destination);
    }

    public static boolean isInternal(String string) {
        return DestType.destNameIsInternal((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this;
        synchronized (object) {
            if (!this.valid) {
                return;
            }
            if (this.started) {
                return;
            }
            this.started = true;
        }
        object = active;
        synchronized (object) {
            active.add(this.monitor);
            if (task == null) {
                task = new NotificationTask();
                try {
                    timer.schedule(task, METRICS_TIME, METRICS_TIME);
                }
                catch (IllegalStateException illegalStateException) {
                    this.logger.log(8, "InternalError: Shutting down metrics, timer has been canceled", (Throwable)illegalStateException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this;
        synchronized (object) {
            if (!this.valid) {
                return;
            }
            if (!this.started) {
                return;
            }
            this.started = false;
        }
        object = active;
        synchronized (object) {
            active.remove(this.monitor);
            if (active.size() == 0) {
                task.cancel();
                task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.stop();
        BrokerMonitor brokerMonitor = this;
        synchronized (brokerMonitor) {
            this.valid = false;
            this.started = false;
            this.monitor = null;
        }
    }

    private Monitor createMonitor(Destination destination) throws IllegalArgumentException, BrokerException {
        String string = destination.getDestinationName();
        if (!DestType.destNameIsInternal((String)string)) {
            throw new IllegalArgumentException("Illegal Internal Name" + string);
        }
        String string2 = string.substring("mq.".length());
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        if (!stringTokenizer.hasMoreElements()) {
            throw new IllegalArgumentException("Missing type  for monitoring " + string);
        }
        String string3 = (String)stringTokenizer.nextElement();
        if (!string3.equals("metrics")) {
            throw new IllegalArgumentException("Illegal type " + string3 + " for monitoring. Only Metrics is valid [" + string + "]");
        }
        if (!stringTokenizer.hasMoreElements()) {
            throw new IllegalArgumentException("Missing area  for monitoring " + string);
        }
        String string4 = (String)stringTokenizer.nextElement();
        if (string4.equals("broker")) {
            if (stringTokenizer.hasMoreElements()) {
                throw new IllegalArgumentException("Bad name  for broker monitoring " + string + " should be " + "mq." + "broker");
            }
            this.monitor = new BrokerMetricsMonitor(destination);
        } else if (string4.equals("jvm")) {
            if (stringTokenizer.hasMoreElements()) {
                throw new IllegalArgumentException("Bad name  for broker monitoring " + string + " should be " + "mq." + "jvm");
            }
            this.monitor = new JVMMonitor(destination);
        } else if (string4.equals("destination")) {
            if (!stringTokenizer.hasMoreElements()) {
                throw new IllegalArgumentException("Missing destination type or list for broker destination monitoring " + string);
            }
            String string5 = (String)stringTokenizer.nextElement();
            if (string5.equals("queue")) {
                if (!stringTokenizer.hasMoreElements()) {
                    throw new IllegalArgumentException("Missing name  for broker queue monitoring " + string);
                }
                String string6 = "metrics.destination.queue.";
                String string7 = string2.substring(string6.length());
                DestinationUID destinationUID = DestinationUID.getUID(string7, true);
                if (!Destination.canAutoCreate(true) && Destination.getDestination(destinationUID) == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4185", destinationUID.getName(), destinationUID.getDestType()), 403);
                }
                this.monitor = new DestMonitor(destination, destinationUID);
            } else if (string5.equals("topic")) {
                if (!stringTokenizer.hasMoreElements()) {
                    throw new IllegalArgumentException("Missing name  for broker topic monitoring " + string);
                }
                String string8 = "metrics.destination.topic.";
                String string9 = string2.substring(string8.length());
                DestinationUID destinationUID = DestinationUID.getUID(string9, false);
                if (!Destination.canAutoCreate(false) && Destination.getDestination(destinationUID) == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4185", destinationUID.getName(), destinationUID.getDestType()), 403);
                }
                this.monitor = new DestMonitor(destination, destinationUID);
            }
        } else if (string4.equals("destination_list")) {
            this.monitor = new DestListMonitor(destination);
        } else {
            throw new IllegalArgumentException("Illegal area " + string4 + " for monitoring " + string);
        }
        return this.monitor;
    }

    public void updateNewConsumer(Consumer consumer) {
        this.monitor.writeToSpecificMonitorConsumer(consumer);
    }

    static class NotificationTask
    extends TimerTask {
        NotificationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Iterator iterator = null;
            Object object = active;
            synchronized (object) {
                iterator = new HashSet(active).iterator();
            }
            while (iterator.hasNext()) {
                object = (Monitor)iterator.next();
                ((Monitor)object).run();
            }
        }
    }
}

