/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.ext;

import com.sun.messaging.bridge.service.DupKeyException;
import com.sun.messaging.bridge.service.KeyNotFoundException;
import com.sun.messaging.bridge.service.UpdateOpaqueDataCallback;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ext.TMLogRecordDAO;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TMLogRecordDAOJMSBG
extends BaseDAOImpl
implements TMLogRecordDAO {
    private String tableName = null;
    public static final String TABLE = "MQTMLRJMSBG";
    public static final String TABLE_NAME_PREFIX = "MQTMLRJMSBG41";
    protected String insertSQL;
    protected String updateLogRecordSQL;
    protected String deleteSQL;
    protected String selectLogRecordSQL;
    protected String selectUpdatedTimeSQL;
    protected String selectCreatedTimeSQL;
    protected String selectLogRecordsByNameByBrokerSQL;
    protected String selectTMNamesByBrokerSQL;
    protected String selectLogRecordsByBrokerSQL;

    public TMLogRecordDAOJMSBG() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName(TABLE_NAME_PREFIX);
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("XID").append(", ").append("LOG_RECORD").append(", ").append("NAME").append(", ").append("BROKER_ID").append(", ").append("CREATED_TS").append(", ").append("UPDATED_TS").append(") VALUES ( ?, ?, ?, ?, ?, ?)").toString();
        this.updateLogRecordSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("LOG_RECORD").append(" = ?, ").append("UPDATED_TS").append(" = ? ").append(" WHERE ").append("XID").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("XID").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.selectLogRecordSQL = new StringBuffer(128).append("SELECT ").append("LOG_RECORD").append(" FROM ").append(this.tableName).append(" WHERE ").append("XID").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.selectUpdatedTimeSQL = new StringBuffer(128).append("SELECT ").append("UPDATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("XID").append(" = ?").toString();
        this.selectCreatedTimeSQL = new StringBuffer(128).append("SELECT ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("XID").append(" = ?").toString();
        this.selectLogRecordsByNameByBrokerSQL = new StringBuffer(128).append("SELECT ").append("XID").append(", ").append("LOG_RECORD").append(" FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.selectTMNamesByBrokerSQL = new StringBuffer(128).append("SELECT ").append("NAME").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return TABLE_NAME_PREFIX;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, String string, byte[] byArray, String string2, Logger logger) throws DupKeyException, Exception {
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        Exception exception = null;
        try {
            try {
                DBManager dBManager = DBManager.getDBManager();
                if (connection == null) {
                    connection2 = connection = dBManager.getConnection(true);
                }
                try {
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setBytes(2, byArray);
                    preparedStatement.setString(3, string2);
                    preparedStatement.setString(4, dBManager.getBrokerID());
                    preparedStatement.setLong(5, System.currentTimeMillis());
                    preparedStatement.setLong(6, 0L);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception2) {
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        String string3 = "B4080";
                        this.logger.log(32, string3, (Throwable)sQLException);
                        Util.logExt(logger, Level.SEVERE, string3, sQLException);
                    }
                    this.checkDupKeyOnException(connection, string, logger);
                    throw exception2;
                }
                Object var14_14 = null;
                this.closeSQL(null, preparedStatement, connection2, exception, logger);
            }
            catch (Exception exception3) {
                exception = exception3;
                throw exception3;
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.closeSQL(null, preparedStatement, connection2, exception, logger);
            throw throwable;
        }
    }

    public void updateLogRecord(Connection connection, String string, byte[] byArray, String string2, UpdateOpaqueDataCallback updateOpaqueDataCallback, boolean bl, Logger logger) throws KeyNotFoundException, StoreBeingTakenOverException, Exception {
        Exception exception;
        PreparedStatement preparedStatement;
        Connection connection2;
        block11: {
            connection2 = null;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection2 = connection = dBManager.getConnection(false);
                    }
                    if (connection.getAutoCommit()) {
                        throw new BrokerException("Broker Internal Error: Unexpected auto commit SQL connection for update TM log record: " + string);
                    }
                    byte[] byArray2 = null;
                    byArray2 = this.getLogRecord(connection, string, string2, logger);
                    if (byArray2 == null) {
                        if (bl) {
                            this.insert(connection, string, byArray, string2, logger);
                            Object var15_15 = null;
                            this.closeSQL(null, preparedStatement, connection2, exception, logger);
                            return;
                        }
                        throw new KeyNotFoundException("TM log record not found for " + string);
                    }
                    byte[] byArray3 = (byte[])updateOpaqueDataCallback.update(byArray2);
                    preparedStatement = connection.prepareStatement(this.updateLogRecordSQL);
                    preparedStatement.setBytes(1, byArray3);
                    preparedStatement.setLong(2, System.currentTimeMillis());
                    preparedStatement.setString(3, string);
                    preparedStatement.setString(4, dBManager.getBrokerID());
                    if (preparedStatement.executeUpdate() == 0) {
                        Util.checkBeingTakenOver(connection, dBManager, this.logger, logger);
                        throw new BrokerException(this.br.getKString("TM Log record not found in store for " + string), 404);
                    }
                    if (connection2 == null) break block11;
                    connection.commit();
                }
                catch (Exception exception2) {
                    exception = exception2;
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        String string3 = "B4080";
                        this.logger.log(32, string3, (Throwable)sQLException);
                        Util.logExt(logger, Level.SEVERE, string3, sQLException);
                    }
                    throw exception2;
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                this.closeSQL(null, preparedStatement, connection2, exception, logger);
                throw throwable;
            }
        }
        Object var15_16 = null;
        this.closeSQL(null, preparedStatement, connection2, exception, logger);
    }

    public void delete(Connection connection, String string, String string2, Logger logger) throws KeyNotFoundException, Exception {
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        Exception exception = null;
        try {
            try {
                DBManager dBManager = DBManager.getDBManager();
                if (connection == null) {
                    connection2 = connection = dBManager.getConnection(true);
                }
                preparedStatement = connection.prepareStatement(this.deleteSQL);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, dBManager.getBrokerID());
                if (preparedStatement.executeUpdate() == 0) {
                    throw new KeyNotFoundException("TM log record not found in store for " + string);
                }
                Object var12_10 = null;
                this.closeSQL(null, preparedStatement, connection2, exception, logger);
            }
            catch (Exception exception2) {
                exception = exception2;
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    String string3 = "B4080";
                    this.logger.log(32, string3, (Throwable)sQLException);
                    Util.logExt(logger, Level.SEVERE, string3, sQLException);
                }
                throw exception2;
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.closeSQL(null, preparedStatement, connection2, exception, logger);
            throw throwable;
        }
    }

    public void deleteAllByName(Connection connection, String string, Logger logger) throws KeyNotFoundException, Exception {
        DBManager dBManager = DBManager.getDBManager();
        String string2 = new StringBuffer(128).append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("'").append(" AND ").append("NAME").append(" = '").append(string).append("'").toString();
        this.deleteAll(connection, string2, null, 0);
    }

    public void deleteAll(Connection connection) throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        String string = new StringBuffer(128).append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("'").toString();
        this.deleteAll(connection, string, null, 0);
    }

    public byte[] getLogRecord(Connection connection, String string, String string2, Logger logger) throws Exception {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        byte[] byArray;
        block9: {
            byArray = null;
            connection2 = null;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            DBManager dBManager = DBManager.getDBManager();
            if (connection == null) {
                connection2 = connection = dBManager.getConnection(true);
            }
            preparedStatement = connection.prepareStatement(this.selectLogRecordSQL);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, dBManager.getBrokerID());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block9;
            byte[] byArray2 = null;
            Object var13_14 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
            return byArray2;
        }
        try {
            try {
                byArray = Util.readBytes(resultSet, 1);
            }
            catch (Exception exception2) {
                exception = exception2;
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080[" + this.selectLogRecordSQL + "]", (Throwable)sQLException);
                }
                throw exception2;
            }
            Object var13_15 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
            throw throwable;
        }
        return byArray;
    }

    public long getUpdatedTime(Connection connection, String string, String string2, Logger logger) throws KeyNotFoundException, Exception {
        long l = -1L;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Exception exception = null;
        try {
            try {
                if (connection == null) {
                    connection2 = connection = DBManager.getDBManager().getConnection(true);
                }
                preparedStatement = connection.prepareStatement(this.selectUpdatedTimeSQL);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw new KeyNotFoundException("TM Log record not found in store for xid " + string);
                }
                l = resultSet.getLong(1);
            }
            catch (Exception exception2) {
                exception = exception2;
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080[" + this.selectUpdatedTimeSQL + "]", (Throwable)sQLException);
                }
                throw exception2;
            }
            Object var14_10 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
            throw throwable;
        }
        return l;
    }

    public long getCreatedTime(Connection connection, String string, String string2, Logger logger) throws KeyNotFoundException, Exception {
        long l = -1L;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Exception exception = null;
        try {
            try {
                if (connection == null) {
                    connection2 = connection = DBManager.getDBManager().getConnection(true);
                }
                preparedStatement = connection.prepareStatement(this.selectCreatedTimeSQL);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw new KeyNotFoundException("TM Log record not found in store for xid " + string);
                }
                l = resultSet.getLong(1);
            }
            catch (Exception exception2) {
                exception = exception2;
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080[" + this.selectCreatedTimeSQL + "]", (Throwable)sQLException);
                }
                throw exception2;
            }
            Object var14_10 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
            throw throwable;
        }
        return l;
    }

    public List getLogRecordsByNameByBroker(Connection connection, String string, String string2, Logger logger) throws Exception {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Exception exception = null;
        try {
            try {
                DBManager dBManager = DBManager.getDBManager();
                if (connection == null) {
                    connection2 = connection = dBManager.getConnection(true);
                }
                preparedStatement = connection.prepareStatement(this.selectLogRecordsByNameByBrokerSQL);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    arrayList.add(Util.readBytes(resultSet, 2));
                }
                Object var13_12 = null;
                this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
            }
            catch (Exception exception2) {
                exception = exception2;
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080[" + this.selectLogRecordsByNameByBrokerSQL + "]", (Throwable)sQLException);
                }
                throw exception2;
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
            throw throwable;
        }
        return arrayList;
    }

    public List getNamesByBroker(Connection connection, String string, Logger logger) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Exception exception = null;
        try {
            try {
                DBManager dBManager = DBManager.getDBManager();
                if (connection == null) {
                    connection2 = connection = dBManager.getConnection(true);
                }
                preparedStatement = connection.prepareStatement(this.selectTMNamesByBrokerSQL);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
                Object var12_11 = null;
                this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
            }
            catch (Exception exception2) {
                exception = exception2;
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080[" + this.selectTMNamesByBrokerSQL + "]", (Throwable)sQLException);
                }
                throw exception2;
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, exception, logger);
            throw throwable;
        }
        return arrayList;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("JMSBridgeTMLogRecord(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    private void checkDupKeyOnException(Connection connection, String string, Logger logger) throws DupKeyException {
        if (connection == null) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.selectCreatedTimeSQL);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                throw new DupKeyException("Xid " + string + " already exists in DB");
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080[" + this.selectCreatedTimeSQL + "]", (Throwable)sQLException);
            }
            if (exception instanceof DupKeyException) {
                throw (DupKeyException)exception;
            }
            String string2 = this.br.getKString("B4117", "Exception on checkDupKey for xid " + string);
            this.logger.log(16, string2, (Throwable)exception);
            Util.logExt(logger, Level.WARNING, string2, exception);
        }
    }

    private void closeSQL(ResultSet resultSet, PreparedStatement preparedStatement, Connection connection, Throwable throwable, Logger logger) {
        try {
            Util.close(resultSet, preparedStatement, connection, throwable);
        }
        catch (Exception exception) {
            Throwable throwable2 = exception.getCause();
            String string = "Unable to close SQL connection or statement: " + exception.getMessage() + (throwable2 == null ? "" : " - " + throwable2.getMessage());
            this.logger.log(16, string, (Throwable)exception);
            Util.logExt(logger, Level.WARNING, string, exception);
        }
    }
}

