/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.Womb;
import org.jvnet.hk2.component.Wombs;
import org.jvnet.hk2.junit.Hk2TestServices;

public class Hk2Runner
extends Runner {
    final Class<?> testClass;
    final Description description;
    static final Hk2TestServices singleton = new Hk2TestServices();

    public Hk2Runner(Class testClass) {
        this.testClass = testClass;
        this.description = Description.createSuiteDescription((Class)testClass);
    }

    public Description getDescription() {
        return this.description;
    }

    public void run(RunNotifier notifier) {
        Failure failure;
        Object instance;
        if (this.testClass.isAnnotationPresent(Ignore.class)) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        for (Method m : this.testClass.getMethods()) {
            Failure failure2;
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || m.getAnnotation(BeforeClass.class) == null || m.getAnnotation(Ignore.class) != null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure2 = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure2);
            }
            catch (InvocationTargetException e) {
                failure2 = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure2);
            }
        }
        Habitat habitat = singleton.getHabitat();
        Womb<?> womb = Wombs.create(this.testClass, habitat, new MultiMap<String, String>());
        try {
            instance = womb.get();
        }
        catch (ComponentException e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
            return;
        }
        for (Method m : this.testClass.getDeclaredMethods()) {
            Description testDescription = Description.createTestDescription(this.testClass, (String)m.getName());
            System.out.println("Running " + m.toGenericString());
            if (m.isAnnotationPresent(Ignore.class)) {
                notifier.fireTestIgnored(testDescription);
                continue;
            }
            if (m.isAnnotationPresent(Test.class)) {
                try {
                    m.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    failure = new Failure(testDescription, (Throwable)e);
                    notifier.fireTestFailure(failure);
                }
                catch (InvocationTargetException e) {
                    failure = new Failure(testDescription, (Throwable)e);
                    notifier.fireTestFailure(failure);
                }
            }
            notifier.fireTestFinished(testDescription);
        }
        for (Method m : this.testClass.getMethods()) {
            int mod = m.getModifiers();
            if (!Modifier.isStatic(mod) || m.getAnnotation(AfterClass.class) == null || m.getAnnotation(Ignore.class) != null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                failure = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
            catch (InvocationTargetException e) {
                failure = new Failure(null, (Throwable)e);
                notifier.fireTestFailure(failure);
            }
        }
    }

    public static Habitat getHabitat() {
        return singleton.getHabitat();
    }
}

