/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import java.io.IOException;
import java.util.logging.Level;

public abstract class GrizzlyAdapter
extends StaticResourcesAdapter {
    protected static final int ADAPTER_NOTES = 31;
    protected static final boolean ALLOW_BACKSLASH = false;
    protected boolean chunkingDisabled = false;
    private boolean handleStaticResources = false;
    private boolean allowEncodedSlash = UDecoder.ALLOW_ENCODED_SLASH;
    private boolean decodeURL = true;

    public GrizzlyAdapter() {
        this.commitErrorResponse = false;
    }

    public GrizzlyAdapter(String publicDirectory) {
        super(publicDirectory);
        this.commitErrorResponse = false;
    }

    public final void service(Request req, Response res) throws Exception {
        req.getURLDecoder().setAllowEncodedSlash(this.allowEncodedSlash);
        if (this.isHandleStaticResources()) {
            super.service(req, res);
            if (res.getStatus() == 404) {
                res.setStatus(200);
                res.setMessage("OK");
            } else {
                return;
            }
        }
        GrizzlyRequest request = (GrizzlyRequest)req.getNote(31);
        GrizzlyResponse response = (GrizzlyResponse)res.getNote(31);
        if (request == null) {
            request = new GrizzlyRequest();
            request.setRequest(req);
            response = new GrizzlyResponse(this.chunkingDisabled, false);
            response.setResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(31, request);
            res.setNote(31, response);
        }
        try {
            if (this.decodeURL) {
                MessageBytes decodedURI = req.decodedURI();
                decodedURI.duplicate(req.requestURI());
                try {
                    HttpRequestURIDecoder.decode(decodedURI, req.getURLDecoder());
                }
                catch (IOException ioe) {
                    res.setStatus(400);
                    res.setMessage("Invalid URI: " + ioe.getMessage());
                    return;
                }
            }
            request.parseSessionId();
            this.service(request, response);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "service exception", t);
            res.setStatus(500);
            res.setMessage("Internal Error");
            return;
        }
    }

    public abstract void service(GrizzlyRequest var1, GrizzlyResponse var2);

    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void afterService(Request req, Response res) throws Exception {
        GrizzlyRequest request = (GrizzlyRequest)req.getNote(31);
        GrizzlyResponse response = (GrizzlyResponse)res.getNote(31);
        try {
            if (request != null && response != null) {
                this.afterService(request, response);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "afterService", ex);
            throw ex;
        }
        try {
            if (response != null) {
                response.finishResponse();
            }
            super.afterService(req, res);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "afterService exception", t);
        }
        finally {
            if (request != null) {
                request.recycle();
            }
            if (response != null) {
                response.recycle();
            }
        }
    }

    public void start() {
    }

    public void destroy() {
    }

    public boolean isHandleStaticResources() {
        return this.handleStaticResources;
    }

    public void setHandleStaticResources(boolean handleStaticResources) {
        this.handleStaticResources = handleStaticResources;
    }

    public boolean isAllowEncodedSlash() {
        return this.allowEncodedSlash;
    }

    public void setAllowEncodedSlash(boolean allowEncodedSlash) {
        this.allowEncodedSlash = allowEncodedSlash;
    }

    protected void setDecodeUrl(boolean decodeURL) {
        this.decodeURL = decodeURL;
    }

    public boolean isDecodeURL() {
        return this.decodeURL;
    }
}

