/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.ThreadPoolMonitoringProbe;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractThreadPool
extends AbstractExecutorService
implements ExtendedThreadPool,
Thread.UncaughtExceptionHandler {
    public static int DEFAULT_MIN_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_TASKS_QUEUED = Integer.MAX_VALUE;
    public static int DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT = 30000;
    protected static final Runnable poison = new Runnable(){

        public void run() {
        }
    };
    protected volatile int initialByteBufferSize = 8192;
    protected volatile ByteBufferFactory.ByteBufferType byteBufferType = WorkerThreadImpl.DEFAULT_BYTEBUFFER_TYPE;
    protected volatile String name = "GrizzlyWorker";
    protected volatile int priority = 5;
    protected volatile int corePoolSize;
    protected volatile int maxPoolSize;
    protected volatile long keepAliveTime;
    protected volatile ThreadFactory threadFactory;
    private final AtomicInteger nextthreadID = new AtomicInteger();
    protected final ThreadPoolMonitoringProbe probe;
    protected final Object statelock = new Object();
    protected final Map<Worker, Long> workers = new HashMap<Worker, Long>();
    protected volatile boolean running = true;
    protected int currentPoolSize;
    protected int activeThreadsCount;

    public AbstractThreadPool(ThreadPoolMonitoringProbe probe, String name, ThreadFactory threadFactory, int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("poolsize < 1");
        }
        this.setName(name);
        this.corePoolSize = -1;
        this.maxPoolSize = maxPoolSize;
        this.probe = probe;
        this.threadFactory = threadFactory != null ? threadFactory : this.getDefaultThreadFactory();
    }

    protected void startWorker(Worker wt) {
        Thread thread = this.threadFactory.newThread(wt);
        thread.setName(this.getName() + "(" + this.nextThreadId() + ")");
        thread.setUncaughtExceptionHandler(this);
        thread.setPriority(this.getPriority());
        thread.setDaemon(true);
        if (thread instanceof WorkerThreadImpl) {
            WorkerThreadImpl workerThread = (WorkerThreadImpl)thread;
            workerThread.setByteBufferType(this.getByteBufferType());
            workerThread.setInitialByteBufferSize(this.getInitialByteBufferSize());
        }
        wt.t = thread;
        this.workers.put(wt, System.currentTimeMillis());
        wt.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        Object object = this.statelock;
        synchronized (object) {
            ArrayList<Runnable> drained = new ArrayList<Runnable>();
            if (this.running) {
                this.running = false;
                AbstractThreadPool.drain(this.getQueue(), drained);
                for (Runnable task : drained) {
                    this.onTaskDequeued(task);
                }
                this.poisonAll();
                for (Worker w : this.workers.keySet()) {
                    w.t.interrupt();
                }
            }
            return drained;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.statelock;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                this.poisonAll();
                this.statelock.notifyAll();
            }
        }
    }

    @Override
    public boolean isShutdown() {
        return !this.running;
    }

    private void poisonAll() {
        int size = Math.max(this.maxPoolSize, this.workers.size()) * 4 / 3;
        Queue<Runnable> q = this.getQueue();
        while (size-- > 0) {
            q.offer(poison);
        }
    }

    protected static final void drain(Queue<Runnable> from, Collection<Runnable> too) {
        boolean cont = true;
        while (cont) {
            Runnable r = from.poll();
            cont = r != null;
            if (!cont || r == poison) continue;
            too.add(r);
        }
    }

    protected String nextThreadId() {
        return String.valueOf(this.nextthreadID.incrementAndGet());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name 0 length");
        }
        this.name = name;
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maxPoolSize = maximumPoolSize;
    }

    @Override
    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setKeepAliveTime(long time, TimeUnit unit) {
        this.keepAliveTime = TimeUnit.MILLISECONDS.convert(time, unit);
    }

    @Override
    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new IllegalArgumentException("threadFactory is null");
        }
        this.threadFactory = threadFactory;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ByteBufferFactory.ByteBufferType getByteBufferType() {
        return this.byteBufferType;
    }

    public void setByteBufferType(ByteBufferFactory.ByteBufferType byteBufferType) {
        this.byteBufferType = byteBufferType;
    }

    public int getInitialByteBufferSize() {
        return this.initialByteBufferSize;
    }

    public void setInitialByteBufferSize(int initialByteBufferSize) {
        this.initialByteBufferSize = initialByteBufferSize;
    }

    protected void validateNewPoolSize(int corePoolsize, int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolsize < 1 :" + maxPoolSize);
        }
        if (corePoolsize < 1) {
            throw new IllegalArgumentException("corePoolsize < 1 :" + corePoolsize);
        }
        if (corePoolsize > maxPoolSize) {
            throw new IllegalArgumentException("corePoolsize > maxPoolSize: " + corePoolsize + " > " + maxPoolSize);
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
        if (t instanceof WorkerThreadImpl) {
            ((WorkerThreadImpl)t).createByteBuffer(false);
        }
    }

    protected void afterExecute(Thread thread, Runnable r, Throwable t) {
        if (thread instanceof WorkerThreadImpl) {
            ((WorkerThreadImpl)thread).reset();
        }
    }

    protected void onTaskCompletedEvent(Runnable task) {
        if (this.probe != null) {
            this.probe.onTaskCompletedEvent(task);
        }
    }

    protected void onWorkerStarted(Worker worker) {
        if (this.probe != null) {
            this.probe.threadAllocatedEvent(this.name, worker.t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onWorkerExit(Worker worker) {
        Object object = this.statelock;
        synchronized (object) {
            --this.currentPoolSize;
            --this.activeThreadsCount;
            this.workers.remove(worker);
        }
        if (this.probe != null) {
            this.probe.threadReleasedEvent(this.name, worker.t);
        }
    }

    protected void onMaxNumberOfThreadsReached() {
        if (this.probe != null) {
            this.probe.maxNumberOfThreadsReachedEvent(this.name, this.maxPoolSize);
        }
    }

    protected void onTaskQueued(Runnable task) {
        if (this.probe != null) {
            this.probe.onTaskQueuedEvent(task);
        }
    }

    protected void onTaskDequeued(Runnable task) {
        if (this.probe != null) {
            this.probe.onTaskDequeuedEvent(task);
        }
    }

    protected void onTaskQueueOverflow() {
        if (this.probe != null) {
            this.probe.onTaskQueueOverflowEvent(this.name);
        }
        throw new RejectedExecutionException("The thread pool's task queue is full, limit: " + this.getMaxQueuedTasksCount());
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        LoggerUtils.getLogger().log(Level.WARNING, "Uncaught thread exception. Thread: " + thread, throwable);
    }

    protected ThreadFactory getDefaultThreadFactory() {
        return new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new WorkerThreadImpl(AbstractThreadPool.this, AbstractThreadPool.this.getName() + "-WorkerThread(" + AbstractThreadPool.this.nextThreadId() + ")", r, AbstractThreadPool.this.getInitialByteBufferSize());
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.getClass().getSimpleName() + ":");
        sb.append("name=").append(this.name);
        sb.append(", queuesize=").append(this.getQueueSize());
        sb.append(", is-shutdown=").append(this.isShutdown());
        return sb.toString();
    }

    public abstract class Worker
    implements Runnable {
        protected Thread t;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AbstractThreadPool.this.onWorkerStarted(this);
                this.doWork();
            }
            finally {
                AbstractThreadPool.this.onWorkerExit(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected void doWork() {
            t_ = this.t;
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        Thread.interrupted();
                        r = this.getTask();
                        if (r == AbstractThreadPool.poison || r == null) {
                            return;
                        }
                        AbstractThreadPool.this.onTaskDequeued(r);
                        error = null;
                        try {
                            AbstractThreadPool.this.beforeExecute(t_, r);
                            r.run();
                            AbstractThreadPool.this.onTaskCompletedEvent(r);
                        }
                        catch (Throwable throwable) {
                            error = throwable;
                        }
                        finally {
                            AbstractThreadPool.this.afterExecute(t_, r, error);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var2_3) {
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }

        protected abstract Runnable getTask() throws InterruptedException;
    }
}

