/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.DataStructures;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.Utils;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectorFactory {
    public static final int DEFAULT_MAX_SELECTORS = 20;
    private static volatile int maxSelectors = 20;
    private static final Queue<Selector> selectors = DataStructures.getCLQinstance(Selector.class);
    private static volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxSelectors(int size) throws IOException {
        Queue<Selector> queue = selectors;
        synchronized (queue) {
            int toAdd;
            if (size < 0) {
                LoggerUtils.getLogger().log(Level.WARNING, "tried to remove too many selectors " + size + ">=" + maxSelectors, new Exception());
                return;
            }
            int n = toAdd = initialized ? size - maxSelectors : size;
            if (toAdd > 0) {
                while (toAdd-- > 0) {
                    selectors.add(Utils.openSelector());
                }
            } else {
                SelectorFactory.reduce(-toAdd);
            }
            maxSelectors = size;
            initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeSelectorsBy(int delta) throws IOException {
        Queue<Selector> queue = selectors;
        synchronized (queue) {
            SelectorFactory.setMaxSelectors(maxSelectors + delta);
        }
    }

    public static int getMaxSelectors() {
        return maxSelectors;
    }

    public static Selector getSelector() {
        if (!initialized) {
            try {
                SelectorFactory.setMaxSelectors(maxSelectors);
            }
            catch (IOException ex) {
                LoggerUtils.getLogger().log(Level.WARNING, "static init of SelectorFactory failed", ex);
            }
        }
        Selector selector = null;
        selector = selectors.poll();
        if (selector == null) {
            LoggerUtils.getLogger().warning("No Selector available. Increase default: " + maxSelectors);
        }
        return selector;
    }

    public static void returnSelector(Selector s) {
        selectors.offer(s);
    }

    public static void selectNowAndReturnSelector(Selector s) {
        try {
            s.selectNow();
            SelectorFactory.returnSelector(s);
        }
        catch (IOException e) {
            Logger logger = LoggerUtils.getLogger();
            logger.log(Level.WARNING, "Unexpected problem when releasing temporary Selector", e);
            try {
                s.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            try {
                SelectorFactory.reimburseSelector();
            }
            catch (IOException ee) {
                logger.log(Level.WARNING, "Problematic Selector could not be reimbursed!", ee);
            }
        }
    }

    public static void reimburseSelector() throws IOException {
        SelectorFactory.returnSelector(Utils.openSelector());
    }

    private static void reduce(int tokill) {
        while (tokill-- > 0) {
            try {
                Selector selector = selectors.poll();
                if (selector != null) {
                    selector.close();
                    continue;
                }
                LoggerUtils.getLogger().warning("SelectorFactory cache could not remove the desired number, too few selectors in cache.");
                return;
            }
            catch (IOException e) {
                Logger logger = LoggerUtils.getLogger();
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "SelectorFactory.reduce", e);
            }
        }
    }
}

