/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.types.Property;

@Service(name="change-admin-password")
@Scoped(value=PerLookup.class)
@I18n(value="change.admin.password")
public class ChangeAdminPassword
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ChangeAdminPassword.class);
    @Param(name="password", password=true)
    String oldpassword;
    @Param(name="newpassword", password=true)
    String newpassword;
    @Param(name="username", primary=true)
    String userName;
    @Inject
    Configs configs;
    private static final String ADMIN_REALM = "admin-realm";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        SecurityService securityService = config.getSecurityService();
        AuthRealm fileAuthRealm = null;
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            if (!authRealm.getName().equals(ADMIN_REALM)) continue;
            fileAuthRealm = authRealm;
            break;
        }
        if (fileAuthRealm == null) {
            report.setMessage(localStrings.getLocalString("change.admin.password.adminrealmnotfound", "Server Error: There is no admin realm to perform this operation"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String fileRealmClassName = fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("change.admin.password.adminrealmnotsupported", "Configured admin realm is not supported."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("change.admin.password.keyfilenotfound", "There is no physical file associated with admin realm"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        FileRealm fr = null;
        try {
            fr = new FileRealm(keyFile);
        }
        catch (BadRealmException e) {
            report.setMessage(localStrings.getLocalString("change.admin.password.realmcorrupted", "Configured admin realm is corrupted.") + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        catch (NoSuchRealmException e) {
            report.setMessage(localStrings.getLocalString("change.admin.password.realmnotsupported", "Configured admin realm does not exist.") + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        try {
            Enumeration en = fr.getGroupNames(this.userName);
            int size = 0;
            while (en.hasMoreElements()) {
                ++size;
                en.nextElement();
            }
            String[] groups = new String[size];
            en = fr.getGroupNames(this.userName);
            for (int i = 0; i < size; ++i) {
                groups[i] = (String)en.nextElement();
            }
            fr.updateUser(this.userName, this.newpassword.toCharArray(), groups);
            fr.writeKeyFile(keyFile);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("change.admin.password.userupdatefailed", "Password change failed for user named {0}", new Object[]{this.userName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

