/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.cluster.InstanceCommandExecutor;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.ClusterExecutor;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="GlassFishClusterExecutor")
public class GlassFishClusterExecutor
implements ClusterExecutor {
    @Inject
    private Domain domain;
    @Inject
    private ExecutorService threadExecutor;
    @Inject
    private Habitat habitat;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(GlassFishClusterExecutor.class);
    private ArrayList<RuntimeType> runtimeTypes = new ArrayList();
    private FailurePolicy onFailure = FailurePolicy.Error;
    private FailurePolicy ifOffline = FailurePolicy.Warn;

    public ActionReport.ExitCode execute(String commandName, AdminCommand command, AdminCommandContext context, ParameterMap parameters) {
        CommandModel model;
        try {
            CommandModelProvider c = (CommandModelProvider)command;
            model = c.getModel();
        }
        catch (ClassCastException e) {
            model = new CommandModelImpl(command.getClass());
        }
        Cluster clAnnotation = model.getClusteringAttributes();
        if (clAnnotation == null) {
            this.runtimeTypes.add(RuntimeType.DAS);
            this.runtimeTypes.add(RuntimeType.INSTANCE);
        } else {
            if (clAnnotation.value().length == 0) {
                this.runtimeTypes.add(RuntimeType.DAS);
                this.runtimeTypes.add(RuntimeType.INSTANCE);
            } else {
                for (RuntimeType t : clAnnotation.value()) {
                    this.runtimeTypes.add(t);
                }
            }
            if (clAnnotation.ifFailure() != null) {
                this.onFailure = clAnnotation.ifFailure();
            }
            if (clAnnotation.ifOffline() != null) {
                this.ifOffline = clAnnotation.ifOffline();
            }
        }
        if (!this.runtimeTypes.contains(RuntimeType.INSTANCE)) {
            return ActionReport.ExitCode.SUCCESS;
        }
        String target = (String)parameters.getOne((Object)"target");
        ArrayList<Server> instancesForReplication = new ArrayList<Server>();
        if (this.domain.getServerNamed(target) != null) {
            instancesForReplication.add(this.domain.getServerNamed(target));
        } else {
            instancesForReplication.addAll(this.getInstancesForCluster(target));
        }
        if (instancesForReplication.size() == 0) {
            ActionReport aReport = context.getActionReport().addSubActionsReport();
            aReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.notargets", "Unable to find instances for target {0}", new Object[]{target}));
            return this.getReturnValueFor(this.onFailure);
        }
        ActionReport.ExitCode returnValue = this.replicateCommand(commandName, instancesForReplication, context, parameters);
        if (ActionReport.ExitCode.FAILURE.equals((Object)returnValue)) {
            return returnValue;
        }
        this.doSupplementalCommands(commandName, context);
        return returnValue;
    }

    private ActionReport.ExitCode replicateCommand(String commandName, List<Server> instancesForReplication, AdminCommandContext context, ParameterMap parameters) {
        ActionReport.ExitCode returnValue;
        block5: {
            returnValue = ActionReport.ExitCode.SUCCESS;
            try {
                List<InstanceCommandExecutor> execList = this.getInstanceCommandList(commandName, instancesForReplication, context.getLogger());
                for (InstanceCommandExecutor rac : execList) {
                    ActionReport aReport = context.getActionReport().addSubActionsReport();
                    try {
                        String result = rac.executeCommand(parameters);
                        aReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandSuccessful", "Command " + commandName + "executed successfully on server instance " + rac.getServer().getName() + ";" + result, new Object[]{commandName, rac.getServer().getName()}));
                    }
                    catch (CommandException cmdEx) {
                        aReport.setActionExitCode(this.getReturnValueFor(this.onFailure));
                        aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.commandFailed", "Command " + commandName + "failed on server instance " + rac.getServer().getName() + ":", new Object[]{commandName, rac.getServer().getName()}));
                        aReport.setFailureCause((Throwable)cmdEx);
                        if (returnValue.compareTo((Enum)ActionReport.ExitCode.SUCCESS) != 0) continue;
                        returnValue = this.getReturnValueFor(this.onFailure);
                    }
                }
            }
            catch (Exception ex) {
                ActionReport aReport = context.getActionReport().addSubActionsReport();
                aReport.setActionExitCode(this.getReturnValueFor(this.onFailure));
                aReport.setMessage(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication; Reason : " + ex.getLocalizedMessage(), new Object[]{ex.getLocalizedMessage()}));
                aReport.setFailureCause((Throwable)ex);
                context.getLogger().severe(strings.getLocalString("glassfish.clusterexecutor.replicationfailed", "Error during command replication; Reason : " + ex.getLocalizedMessage(), new Object[]{ex.getLocalizedMessage()}));
                if (returnValue.compareTo((Enum)ActionReport.ExitCode.SUCCESS) != 0) break block5;
                returnValue = this.getReturnValueFor(this.onFailure);
            }
        }
        return returnValue;
    }

    private void doSupplementalCommands(String commandName, AdminCommandContext context) {
        ArrayList<AdminCommand> cmdList = new ArrayList<AdminCommand>();
        Collection<Inhabitant<Supplemental>> supplementals = this.habitat.getInhabitants(Supplemental.class);
        if (!supplementals.isEmpty()) {
            for (Inhabitant<Supplemental> inh : supplementals) {
                MultiMap<String, String> map = inh.metadata();
                if (!commandName.equals(map.getOne("target"))) continue;
                cmdList.add((AdminCommand)inh.get());
            }
        }
        if (cmdList.size() != 0) {
            for (AdminCommand cmd : cmdList) {
                cmd.execute(context);
            }
        }
    }

    private List<Server> getInstancesForCluster(String clusterName) {
        ArrayList<Server> instanceList = new ArrayList<Server>();
        com.sun.enterprise.config.serverbeans.Cluster cluster = null;
        List clList = this.domain.getClusters().getCluster();
        for (com.sun.enterprise.config.serverbeans.Cluster cl : clList) {
            if (!clusterName.equals(cl.getName())) continue;
            cluster = cl;
            break;
        }
        if (cluster != null) {
            String clusterConfigName = cluster.getConfigRef();
            List svrList = this.domain.getServers().getServer();
            for (Server svr : svrList) {
                if (!clusterConfigName.equals(svr.getConfigRef())) continue;
                instanceList.add(svr);
            }
        }
        return instanceList;
    }

    private List<InstanceCommandExecutor> getInstanceCommandList(String commandName, List<Server> servers, Logger logger) throws CommandException {
        ArrayList<InstanceCommandExecutor> list = new ArrayList<InstanceCommandExecutor>();
        for (Server svr : servers) {
            NetworkListener adminListener = this.domain.getConfigs().getConfigByName(svr.getConfigRef()).getNetworkConfig().getNetworkListener("admin-listener");
            String host = svr.getNodeAgentRef();
            int port = Integer.parseInt("4848");
            if ("instance1".equals(svr.getName())) {
                port = Integer.parseInt("14848");
            }
            if ("instance2".equals(svr.getName())) {
                port = Integer.parseInt("24848");
            }
            NetworkListener httpListener = this.domain.getConfigs().getConfigByName(svr.getConfigRef()).getNetworkConfig().getNetworkListener("http-listener-1");
            String portStr = svr.getPropertyValue("ASADMIN_LISTENER_PORT");
            portStr = svr.getPropertyValue("JMS_PROVIDER_PORT");
            portStr = svr.getPropertyValue("HTTP_SSL_LISTENER_PORT");
            if (httpListener != null) {
                portStr = httpListener.getPort();
            }
            String adminListPort = adminListener.getPort();
            list.add(new InstanceCommandExecutor(commandName, svr, host, port, logger));
        }
        return list;
    }

    private ActionReport.ExitCode getReturnValueFor(FailurePolicy policy) {
        ActionReport.ExitCode retValue = ActionReport.ExitCode.FAILURE;
        switch (policy) {
            case Ignore: {
                retValue = ActionReport.ExitCode.SUCCESS;
                break;
            }
            case Error: {
                retValue = ActionReport.ExitCode.FAILURE;
                break;
            }
            case Warn: {
                retValue = ActionReport.ExitCode.WARNING;
            }
        }
        return retValue;
    }
}

