/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.grizzly.config.dom.NetworkListener;
import java.util.List;
import org.glassfish.api.admin.ServerEnvironment;

final class RemoteInstanceCommandHelper {
    private final ServerEnvironment env;
    private final List<Server> servers;
    private final List<Config> configs;
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteInstanceCommandHelper.class);

    RemoteInstanceCommandHelper(ServerEnvironment env0, Servers servers0, Configs configs0) {
        this.env = env0;
        this.configs = configs0.getConfig();
        this.servers = servers0.getServer();
    }

    final boolean isDas() {
        return this.env.isDas();
    }

    final boolean isInstance() {
        return this.env.isInstance();
    }

    final int getAdminPort(String serverName) {
        return this.getAdminPort(this.getServer(serverName));
    }

    final String getHost(String serverName) {
        return this.getHost(this.getServer(serverName));
    }

    final String getHost(Server server) {
        if (server == null) {
            return null;
        }
        return server.getNodeAgentRef();
    }

    final Server getServer(String serverName) {
        for (Server server : this.servers) {
            String name = server.getName();
            if (!(serverName == null ? name == null : serverName.equals(name))) continue;
            return server;
        }
        return null;
    }

    final int getAdminPort(Server server) {
        if (server == null) {
            return -1;
        }
        try {
            Config config = this.getConfig(server);
            if (config != null) {
                List listeners = config.getNetworkConfig().getNetworkListeners().getNetworkListener();
                for (NetworkListener listener : listeners) {
                    if (!"admin-listener".equals(listener.getProtocol())) continue;
                    return Integer.parseInt(listener.getPort());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private Config getConfig(Server server) {
        if (server == null) {
            return null;
        }
        String cfgName = server.getConfigRef();
        if (cfgName == null) {
            return null;
        }
        for (Config config : this.configs) {
            if (!cfgName.equals(config.getName())) continue;
            return config;
        }
        return null;
    }
}

