/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.cluster.SyncRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ApplicationName;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="_synchronize-files")
@I18n(value="synchronize.command")
public class SynchronizeFiles
implements AdminCommand {
    @Param(name="file_list", primary=true)
    private File fileList;
    @Param(name="syncarchive", optional=true)
    private boolean syncArchive;
    @Param(name="syncallapps", optional=true)
    private boolean syncAllApps;
    @Inject
    private ServerEnvironment env;
    @Inject(optional=true)
    private Applications applications;
    @Inject(optional=true)
    private Servers servers;
    private URI domainRootUri;
    private Logger logger;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(SynchronizeFiles.class);
    private String[] configFiles = new String[]{"domain.xml", "admin-keyfile", "cacerts.jks", "default-web.xml", "domain-passwords", "keyfile", "keystore.jks", "logging.properties", "login.conf", "server.policy", "sun-acc.xml", "wss-server-config-1.0.xml", "wss-server-config-2.0.xml"};

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.logger = context.getLogger();
        System.out.println("SynchronizeFiles: logger " + this.logger.getName());
        this.logger.setLevel(Level.FINEST);
        this.domainRootUri = this.env.getDomainRoot().toURI();
        SyncRequest sr = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{SyncRequest.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(null);
            sr = (SyncRequest)unmarshaller.unmarshal(this.fileList);
            this.logger.finer("SynchronizeFiles: synchronize dir " + sr.dir);
        }
        catch (Exception ex) {
            this.logger.fine("SynchronizeFiles: Exception reading request");
            this.logger.fine(ex.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("sync.exception.reading", "SynchronizeFiles: Exception reading request"));
            report.setFailureCause((Throwable)ex);
            return;
        }
        try {
            Server server = null;
            if (this.servers != null) {
                server = this.servers.getServer(sr.instance);
            }
            if (server == null) {
                this.logger.fine("SynchronizeFiles: instance unknown: " + sr.instance);
                server = this.servers.getServer("server");
            }
            if (sr.dir.equals("config")) {
                this.synchronizeConfig(context, sr);
            } else if (sr.dir.equals("applications")) {
                this.synchronizeApplications(context, server, sr);
            } else if (sr.dir.equals("lib")) {
                this.synchronizeLib(context, server, sr);
            } else if (sr.dir.equals("docroot")) {
                this.synchronizeDocroot(context, server, sr);
            } else if (sr.dir.equals("config-specific")) {
                this.synchronizeConfigSpecificDir(context, server, sr);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(strings.getLocalString("sync.unknown.dir", "Unknown directory: {0}", new Object[]{sr.dir}));
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception ex) {
            this.logger.fine("SynchronizeFiles: Exception processing request");
            this.logger.fine(ex.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("sync.exception.processing", "SynchronizeFiles: Exception processing request"));
            report.setFailureCause((Throwable)ex);
        }
    }

    private void synchronizeConfig(AdminCommandContext context, SyncRequest sr) throws URISyntaxException {
        Payload.Outbound outboundPayload;
        File configDir;
        this.logger.finer("SynchronizeFiles: synchronize config");
        SyncRequest.ModTime domainXmlMT = null;
        for (SyncRequest.ModTime mt : sr.files) {
            if (!mt.name.equals("domain.xml")) continue;
            domainXmlMT = mt;
            break;
        }
        if (domainXmlMT == null) {
            domainXmlMT = new SyncRequest.ModTime("domain.xml", 0L);
        }
        if (!this.syncFile(this.domainRootUri, configDir = this.env.getConfigDirPath(), domainXmlMT, outboundPayload = context.getOutboundPayload())) {
            this.logger.finer("SynchronizeFiles: domain.xml HAS NOT CHANGED");
            return;
        }
        Set<String> configFileSet = this.getConfigFileNames();
        configFileSet.remove("domain.xml");
        for (SyncRequest.ModTime mt : sr.files) {
            if (mt.name.equals("domain.xml")) continue;
            if (configFileSet.contains(mt.name)) {
                configFileSet.remove(mt.name);
                this.syncFile(this.domainRootUri, configDir, mt, outboundPayload);
                continue;
            }
            this.removeFile(this.domainRootUri, configDir, mt, outboundPayload);
        }
        for (String name : configFileSet) {
            this.syncFile(this.domainRootUri, configDir, new SyncRequest.ModTime(name, 0L), outboundPayload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getConfigFileNames() {
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        BufferedReader in = null;
        try {
            String line;
            File configDir = this.env.getConfigDirPath();
            File f = new File(configDir, "config-files");
            if (!f.exists()) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(this.configFiles));
                return linkedHashSet;
            }
            in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                files.add(line.trim());
            }
        }
        catch (IOException ex) {
            this.logger.fine("SynchronizeFiles: IOException in getConfigFileNames");
            this.logger.fine(ex.toString());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return files;
    }

    private boolean syncFile(URI root, File base, SyncRequest.ModTime mt, Payload.Outbound outboundPayload) throws URISyntaxException {
        File f = this.fileOf(base, mt.name);
        if (mt.time != 0L && f.lastModified() == mt.time) {
            return false;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("SynchronizeFiles: file " + mt.name + " out of date, time " + f.lastModified());
        }
        try {
            outboundPayload.attachFile("application/octet-stream", root.relativize(f.toURI()), "configChange", f);
        }
        catch (IOException ioex) {
            this.logger.fine("SynchronizeFiles: IOException attaching file: " + f);
            this.logger.fine(ioex.toString());
        }
        return true;
    }

    private void removeFile(URI root, File base, SyncRequest.ModTime mt, Payload.Outbound outboundPayload) throws URISyntaxException {
        File f = this.fileOf(base, mt.name);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("SynchronizeFiles: file " + mt.name + " removed from client");
        }
        try {
            outboundPayload.requestFileRemoval(root.relativize(f.toURI()), "configChange", null);
        }
        catch (IOException ioex) {
            this.logger.fine("SynchronizeFiles: IOException removing file: " + f);
            this.logger.fine(ioex.toString());
        }
    }

    private void synchronizeApplications(AdminCommandContext context, Server server, SyncRequest sr) throws URISyntaxException {
        this.logger.finer("SynchronizeFiles: synchronize application instance " + sr.instance);
        Map<String, Application> apps = this.getApps(server);
        Payload.Outbound outboundPayload = context.getOutboundPayload();
        File appsDir = this.env.getApplicationRepositoryPath();
        for (SyncRequest.ModTime modTime : sr.files) {
            if (apps.containsKey(modTime.name)) {
                this.syncApp(apps.get(modTime.name), appsDir, modTime, outboundPayload);
                apps.remove(modTime.name);
                continue;
            }
            this.removeApp(apps.get(modTime.name), appsDir, modTime, outboundPayload);
        }
        for (Map.Entry entry : apps.entrySet()) {
            this.syncApp((Application)entry.getValue(), appsDir, new SyncRequest.ModTime((String)entry.getKey(), 0L), outboundPayload);
        }
    }

    private Map<String, Application> getApps(Server server) {
        if (this.syncAllApps) {
            return this.getAllApps();
        }
        HashMap<String, Application> apps = new HashMap<String, Application>();
        if (this.applications == null) {
            return apps;
        }
        Cluster cluster = server.getCluster();
        List appRefs = cluster != null ? cluster.getApplicationRef() : server.getApplicationRef();
        for (ApplicationRef ref : appRefs) {
            apps.put(ref.getRef(), this.applications.getApplication(ref.getRef()));
        }
        return apps;
    }

    private Map<String, Application> getAllApps() {
        HashMap<String, Application> apps = new HashMap<String, Application>();
        if (this.applications == null) {
            return apps;
        }
        for (ApplicationName module : this.applications.getModules()) {
            this.logger.finest("SynchronizeFiles: found module " + module.getName());
            if (!(module instanceof Application)) continue;
            Application app = (Application)module;
            if (app.getObjectType().equals("user")) {
                this.logger.finest("SynchronizeFiles: got app " + app.getName());
                if (Boolean.parseBoolean(app.getDirectoryDeployed())) {
                    this.logger.finest("SynchronizeFiles: skipping directory deployed app: " + app.getName());
                    continue;
                }
                apps.put(app.getName(), app);
                continue;
            }
            this.logger.finest("SynchronizeFiles: found wrong app " + app.getName() + ", type " + app.getObjectType());
        }
        return apps;
    }

    private boolean syncApp(Application app, File base, SyncRequest.ModTime mt, Payload.Outbound outboundPayload) throws URISyntaxException {
        this.logger.finer("SynchronizeFiles: sync app " + mt.name);
        try {
            File appDir = this.fileOf(base, mt.name);
            if (this.syncArchive) {
                File archive = app.application();
                this.logger.finest("SynchronizeFiles: check archive " + archive);
                if (mt.time != 0L && archive.lastModified() == mt.time) {
                    return false;
                }
                this.attachAppArchive(archive, outboundPayload);
            } else {
                this.logger.finest("SynchronizeFiles: check app dir " + appDir);
                if (mt.time != 0L && appDir.lastModified() == mt.time) {
                    return false;
                }
                this.attachAppDir(appDir, outboundPayload);
            }
            File gdir = this.env.getApplicationCompileJspPath();
            this.attachAppDir(this.fileOf(gdir, mt.name), outboundPayload);
            gdir = this.env.getApplicationGeneratedXMLPath();
            this.attachAppDir(this.fileOf(gdir, mt.name), outboundPayload);
            gdir = this.env.getApplicationEJBStubPath();
            this.attachAppDir(this.fileOf(gdir, mt.name), outboundPayload);
            gdir = new File(this.env.getApplicationStubPath(), "policy");
            this.attachAppDir(this.fileOf(gdir, mt.name), outboundPayload);
        }
        catch (IOException ioex) {
            this.logger.fine("SynchronizeFiles: IOException syncing app " + mt.name);
            this.logger.fine(ioex.toString());
        }
        return true;
    }

    private void synchronizeLib(AdminCommandContext context, Server server, SyncRequest sr) throws URISyntaxException {
        this.synchronizeDirectory(context, server, sr, this.env.getLibPath(), SyncLevel.RECURSIVE);
    }

    private void synchronizeDocroot(AdminCommandContext context, Server server, SyncRequest sr) throws URISyntaxException {
        this.synchronizeDirectory(context, server, sr, new File(this.env.getDomainRoot(), "docroot"), SyncLevel.TOP);
    }

    private void synchronizeDirectory(AdminCommandContext context, Server server, SyncRequest sr, File dir, SyncLevel level) throws URISyntaxException {
        this.logger.finest("SynchronizeFiles: directory is " + dir);
        List<String> fileSet = this.getFileNames(dir, level);
        this.synchronizeDirectory(context, server, sr, dir, fileSet);
    }

    private void synchronizeDirectory(AdminCommandContext context, Server server, SyncRequest sr, File dir, List<String> fileSet) throws URISyntaxException {
        Payload.Outbound outboundPayload = context.getOutboundPayload();
        for (SyncRequest.ModTime mt : sr.files) {
            if (fileSet.contains(mt.name)) {
                fileSet.remove(mt.name);
                this.syncFile(this.domainRootUri, dir, mt, outboundPayload);
                continue;
            }
            this.removeFile(this.domainRootUri, dir, mt, outboundPayload);
        }
        for (String name : fileSet) {
            this.syncFile(this.domainRootUri, dir, new SyncRequest.ModTime(name, 0L), outboundPayload);
        }
    }

    private void synchronizeConfigSpecificDir(AdminCommandContext context, Server server, SyncRequest sr) throws URISyntaxException {
        String configDirName = server.getConfigRef();
        File configDir = this.env.getConfigDirPath();
        File configSpecificDir = new File(configDir, configDirName);
        this.logger.finest("SynchronizeFiles: config-specific directory is " + configSpecificDir);
        if (!configSpecificDir.exists()) {
            return;
        }
        ArrayList<String> fileSet = new ArrayList<String>();
        this.getFileNames(configSpecificDir, configDir, fileSet, SyncLevel.DIRECTORY);
        this.synchronizeDirectory(context, server, sr, configDir, fileSet);
    }

    private List<String> getFileNames(File dir, SyncLevel level) {
        ArrayList<String> names = new ArrayList<String>();
        if (dir.exists()) {
            this.getFileNames(dir, dir, names, level);
        } else {
            this.logger.finest("SynchronizeFiles: directory doesn't exist: " + dir);
        }
        return names;
    }

    private void getFileNames(File dir, File baseDir, List<String> names, SyncLevel level) {
        if (level == SyncLevel.TOP || level == SyncLevel.DIRECTORY) {
            String name = baseDir.toURI().relativize(dir.toURI()).getPath();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            names.add(name);
        }
        if (level == SyncLevel.TOP) {
            return;
        }
        for (String file : dir.list()) {
            File f = new File(dir, file);
            if (f.isDirectory() && level == SyncLevel.RECURSIVE) {
                this.getFileNames(f, baseDir, names, level);
                continue;
            }
            String name = baseDir.toURI().relativize(f.toURI()).getPath();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            names.add(name);
        }
    }

    private void attachAppArchive(File file, Payload.Outbound outboundPayload) throws IOException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("SynchronizeFiles: domainRootUri " + this.domainRootUri);
            this.logger.finer("SynchronizeFiles: file.toURI() " + file.toURI());
            this.logger.finer("SynchronizeFiles: attach file " + this.domainRootUri.relativize(file.toURI()));
        }
        outboundPayload.attachFile("application/octet-stream", this.domainRootUri.relativize(file.toURI()), "configChange", file);
    }

    private void attachAppDir(File dir, Payload.Outbound outboundPayload) throws IOException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("SynchronizeFiles: attach directory " + this.domainRootUri.relativize(dir.toURI()));
        }
        outboundPayload.requestFileReplacement("application/octet-stream", this.domainRootUri.relativize(dir.toURI()), "configChange", null, dir, true);
    }

    private void removeApp(Application app, File base, SyncRequest.ModTime mt, Payload.Outbound outboundPayload) throws URISyntaxException {
        this.logger.finer("SynchronizeFiles: remove app " + mt.name);
        try {
            File dir = this.fileOf(base, mt.name);
            this.removeDir(dir, outboundPayload);
            dir = this.env.getApplicationCompileJspPath();
            this.removeDir(this.fileOf(dir, mt.name), outboundPayload);
            dir = this.env.getApplicationGeneratedXMLPath();
            this.removeDir(this.fileOf(dir, mt.name), outboundPayload);
            dir = this.env.getApplicationEJBStubPath();
            this.removeDir(this.fileOf(dir, mt.name), outboundPayload);
            dir = new File(this.env.getApplicationStubPath(), "policy");
            this.removeDir(this.fileOf(dir, mt.name), outboundPayload);
        }
        catch (IOException ioex) {
            this.logger.fine("SynchronizeFiles: IOException removing app " + mt.name);
            this.logger.fine(ioex.toString());
        }
    }

    private void removeDir(File file, Payload.Outbound outboundPayload) throws IOException {
        outboundPayload.requestFileRemoval(this.domainRootUri.relativize(file.toURI()), "configChange", null, true);
    }

    private File fileOf(File base, String uri) throws URISyntaxException {
        return new File(new URI(base.toURI().toString() + "/" + uri));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SyncLevel {
        TOP,
        DIRECTORY,
        RECURSIVE;

    }
}

