/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.optional.DomainXmlVerifier;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.net.URL;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Service(name="verify-domain-xml")
@Scoped(value=PerLookup.class)
public final class VerifyDomainXmlCommand
extends LocalDomainCommand {
    @Param(name="domain_name", primary=true, optional=true)
    private String domainName0;
    private static final LocalStringsImpl strings = new LocalStringsImpl(VerifyDomainXmlCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.domainName0);
        super.validate();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        File domainXMLFile = this.getDomainXml();
        logger.printDebugMessage("Domain XML file = " + domainXMLFile);
        try {
            Habitat habitat = Globals.getStaticHabitat();
            ConfigParser parser = new ConfigParser(habitat);
            URL domainURL = domainXMLFile.toURI().toURL();
            DomDocument doc = parser.parse(domainURL);
            Dom domDomain = doc.getRoot();
            Domain domain = (Domain)domDomain.createProxy(Domain.class);
            DomainXmlVerifier validator = new DomainXmlVerifier(domain);
            validator.invokeConfigValidator();
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
        return 0;
    }
}

