/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.config.serverbeans.Domain;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.glassfish.admin.rest.RestService;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Path(value="/generator/")
public class GeneratorResource {
    private DomDocument document;
    protected String genDir;
    private HashMap<String, String> genSingleFiles = new HashMap();
    private HashMap<String, String> genListFiles = new HashMap();
    private HashMap<String, String> genCommandResourceFiles = new HashMap();
    private static String[][] MappingConfigBeansToPOSTCommands = new String[][]{{"ListApplication", "deploy"}, {"Application", "redeploy"}, {"ListAdminObjectResource", "create-admin-object"}, {"ListCustomResource", "create-custom-resource"}, {"ListJdbcResource", "create-jdbc-resource"}, {"ListJdbcConnectionPool", "create-jdbc-connection-pool"}, {"ListConnectorResource", "create-connector-resource"}, {"ListMailResource", "create-javamail-resource"}, {"ListResourceAdapterConfig", "create-resource-adapter-config"}, {"ListConnectorConnectionPool", "create-connector-connection-pool"}, {"ListAuthRealm", "create-auth-realm"}, {"ListAuditModule", "create-audit-module"}, {"ListHttpListener", "create-http-listener"}, {"ListIiopListener", "create-iiop-listener"}, {"ListNetworkListener", "create-network-listener"}, {"ListTransport", "create-transport"}, {"ListProtocol", "create-protocol"}, {"ListJmsHost", "create-jms-host"}, {"ListMessageSecurityConfig", "create-message-security-provider"}, {"JavaConfig", "create-profiler"}, {"ListResourceRef", "create-resource-ref"}, {"ListSystemProperty", "create-system-properties"}, {"ListVirtualServer", "create-virtual-server"}, {"ListThreadPool", "create-threadpool"}};
    private static String[][] MappingConfigBeansToDELETECommands = new String[][]{{"Transport", "delete-transport"}, {"ThreadPool", "delete-threadpool"}, {"NetworkListener", "delete-network-listener"}, {"Protocol", "delete-protocol"}};
    private static String[][] ConfigBeansToCommands = new String[][]{{"JvmOptions", "create-jvm-options", "delete-jvm-options", "JvmOption"}};
    private static String[][] ConfigBeansToCommandResourcesMap = new String[][]{{"Domain", "stop-domain", "POST", "stop", "Stop"}, {"Domain", "restart-domain", "POST", "restart", "Restart"}, {"Domain", "uptime", "GET", "uptime", "Uptime"}, {"Domain", "version", "GET", "version", "Version"}, {"Domain", "rotate-log", "POST", "rotate-log", "RotateLog"}, {"Domain", "get-host-and-port", "GET", "host-port", "HostPort"}, {"Application", "enable", "POST", "enable", "Enable", "id=$parent"}, {"Application", "disable", "POST", "disable", "Disable", "id=$parent"}, {"ConnectionPool", "ping-connection-pool", "GET", "ping", "Ping"}, {"IiopService", "create-ssl", "POST", "create-ssl", "Create", "type=iiop-service"}, {"IiopService", "delete-ssl", "DELETE", "delete-ssl", "Delete", "type=iiop-service"}, {"IiopListener", "create-ssl", "POST", "create-ssl", "Create", "id=$parent", "type=iiop-listener"}, {"IiopListener", "delete-ssl", "DELETE", "delete-ssl", "Delete", "id=$parent", "type=iiop-listener"}, {"AuthRealm", "create-file-user", "POST", "create-user", "Create", "authrealmname=$parent"}, {"AuthRealm", "delete-file-user", "DELETE", "delete-user", "Delete", "authrealmname=$parent"}, {"AuthRealm", "list-file-users", "GET", "list-users", "List", "authrealmname=$parent"}, {"NetworkListener", "create-ssl", "POST", "create-ssl", "Create", "id=$parent", "type=http-listener"}, {"NetworkListener", "delete-ssl", "DELETE", "delete-ssl", "Delete", "id=$parent", "type=http-listener"}, {"Protocol", "create-http", "POST", "create-http", "Create", "id=$parent"}, {"Protocol", "delete-http", "DELETE", "delete-http", "Delete", "id=$parent"}};

    @GET
    @Produces(value={"text/plain"})
    public String get() {
        Domain entity = RestService.getDomain();
        File loc = new File(System.getProperty("user.home") + "/acvs/v3/admin/rest/src/main/java/org/glassfish/admin/rest/resources");
        loc.mkdirs();
        this.genDir = loc.getAbsolutePath();
        File file = new File(this.genDir + "/codegeneration.properties");
        try {
            file.createNewFile();
            FileWriter fstream = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("generation_date=" + new Date() + "\n");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Dom dom1 = Dom.unwrap((ConfigBeanProxy)entity);
        Dom root = dom1.document.getRoot();
        this.document = dom1.document;
        ConfigModel rootModel = root.model;
        try {
            this.generateSingle(rootModel);
        }
        catch (Exception ex) {
            Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "Code Generation done at : " + this.genDir;
    }

    private void processRedirectsAnnotation(ConfigModel model) {
        Class<?> cbp = null;
        System.out.println("\n\nAnnotation" + model.targetTypeName);
        try {
            cbp = model.classLoaderHolder.get().loadClass(model.targetTypeName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("re Annotation" + model.targetTypeName);
        RestRedirects restRedirects = cbp.getAnnotation(RestRedirects.class);
        System.out.println("re Annotation restRedirects" + restRedirects);
        if (restRedirects != null) {
            RestRedirect[] values;
            System.out.println("LUDO: NOT NULL                Annotation restRedirects" + restRedirects);
            for (RestRedirect r : values = restRedirects.value()) {
                System.out.println(r.commandName());
                System.out.println(r.opType());
            }
        }
    }

    private void genHeader(BufferedWriter out) throws IOException {
        out.write("/*\n");
        out.write(" * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.\n");
        out.write(" *\n");
        out.write(" * Copyright 2009 Sun Microsystems, Inc. All rights reserved.\n");
        out.write(" *\n");
        out.write(" * The contents of this file are subject to the terms of either the GNU\n");
        out.write(" * General Public License Version 2 only (\"GPL\") or the Common Development\n");
        out.write(" * and Distribution License(\"CDDL\") (collectively, the \"License\").  You\n");
        out.write(" * may not use this file except in compliance with the License. You can obtain\n");
        out.write(" * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html\n");
        out.write(" * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific\n");
        out.write(" * language governing permissions and limitations under the License.\n");
        out.write(" *\n");
        out.write(" * When distributing the software, include this License Header Notice in each\n");
        out.write(" * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.\n");
        out.write(" * Sun designates this particular file as subject to the \"Classpath\" exception\n");
        out.write(" * as provided by Sun in the GPL Version 2 section of the License file that\n");
        out.write(" * accompanied this code.  If applicable, add the following below the License\n");
        out.write(" * Header, with the fields enclosed by brackets [] replaced by your own\n");
        out.write(" * identifying information: \"Portions Copyrighted [year]\n");
        out.write(" * [name of copyright owner]\"\n");
        out.write(" *\n");
        out.write(" * Contributor(s):\n");
        out.write(" *\n");
        out.write(" * If you wish your version of this file to be governed by only the CDDL or\n");
        out.write(" * only the GPL Version 2, indicate your decision by adding \"[Contributor]\n");
        out.write(" * elects to include this software in this distribution under the [CDDL or GPL\n");
        out.write(" * Version 2] license.\"  If you don't indicate a single choice of license, a\n");
        out.write(" * recipient has the option to distribute your version of this file under\n");
        out.write(" * either the CDDL, the GPL Version 2 or to extend the choice of license to\n");
        out.write(" * its licensees as provided above.  However, if you add GPL Version 2 code\n");
        out.write(" * and therefore, elected the GPL Version 2 license, then the option applies\n");
        out.write(" * only if the new code is made subject to such option by the copyright\n");
        out.write(" * holder.\n");
        out.write(" */\n");
    }

    public void generateList(ConfigModel model) throws IOException {
        String serverConfigName = model.targetTypeName.substring(model.targetTypeName.lastIndexOf(".") + 1, model.targetTypeName.length());
        if (this.genListFiles.containsKey(serverConfigName)) {
            return;
        }
        this.genListFiles.put(serverConfigName, serverConfigName);
        String beanName = this.getBeanName(serverConfigName);
        File file = new File(this.genDir + "/List" + beanName + "Resource.java");
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        FileWriter fstream = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fstream);
        this.genHeader(out);
        out.write("package org.glassfish.admin.rest.resources;\n");
        out.write("import javax.ws.rs.*;\n");
        out.write("import org.glassfish.admin.rest.TemplateListOfResource;\n");
        out.write("import " + model.targetTypeName + ";\n");
        out.write("public class List" + beanName + "Resource extends TemplateListOfResource<" + beanName + "> {\n\n");
        String keyAttributeName = null;
        if (model.key == null) {
            try {
                for (String s : model.getAttributeNames()) {
                    if (!s.equals("name")) continue;
                    keyAttributeName = this.getBeanName(s);
                }
                if (keyAttributeName == null) {
                    keyAttributeName = this.getBeanName(model.getAttributeNames().iterator().next());
                }
            }
            catch (Exception e) {
                keyAttributeName = "ThisIsAModelBug:NoKeyAttr";
            }
        } else {
            keyAttributeName = this.getBeanName(model.key.substring(1, model.key.length()));
        }
        out.write("\n");
        out.write("\t@Path(\"{" + keyAttributeName + "}/\")\n");
        out.write("\tpublic " + beanName + "Resource get" + beanName + "Resource(@PathParam(\"" + keyAttributeName + "\") String id) {\n");
        out.write("\t\t" + beanName + "Resource resource = resourceContext.getResource(" + beanName + "Resource.class);\n");
        out.write("\t\tfor (" + beanName + " c: entity){\n");
        if (model.key == null) {
            out.write("//THIS KEY IS THE FIRST Attribute ONE ludo\n");
        }
        out.write("\t\t\t//Using '-' for back-slash in resource names\n");
        out.write("\t\t\t//For example, jndi names has back-slash in it.\n");
        out.write("\t\t\tif(c.get" + keyAttributeName + "().replace('/', '-').equals(id)){\n");
        out.write("\t\t\t\tresource.setEntity(c);\n");
        out.write("\t\t\t}\n");
        out.write("\t\t}\n");
        out.write("\t\treturn resource;\n");
        out.write("\t}\n\n");
        this.generateCommandResources("List" + beanName, out);
        out.write("\n");
        this.generateGetPostCommandMethod("List" + beanName, out);
        out.write("}\n");
        out.close();
        System.out.println("created:" + file.getAbsolutePath());
        this.generateSingle(model);
    }

    public void generateSingle(ConfigModel model) throws IOException {
        this.processRedirectsAnnotation(model);
        String serverConfigName = model.targetTypeName.substring(model.targetTypeName.lastIndexOf(".") + 1, model.targetTypeName.length());
        if (this.genSingleFiles.containsKey(serverConfigName)) {
            return;
        }
        this.genSingleFiles.put(serverConfigName, serverConfigName);
        String beanName = this.getBeanName(serverConfigName);
        File file = new File(this.genDir + "/" + beanName + "Resource.java");
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        FileWriter fstream = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fstream);
        this.genHeader(out);
        out.write("package org.glassfish.admin.rest.resources;\n");
        out.write("import javax.ws.rs.*;\n");
        out.write("import org.glassfish.admin.rest.TemplateResource;\n");
        out.write("import " + model.targetTypeName + ";\n");
        if (beanName.equals("Domain")) {
            out.write("@Path(\"/domain/\")\n");
        }
        out.write("public class " + beanName + "Resource extends TemplateResource<" + beanName + "> {\n\n");
        if (beanName.equals("Domain")) {
            out.write("@Override public " + beanName + " getEntity() {\n");
            out.write("return org.glassfish.admin.rest.RestService.getDomain();\n");
            out.write("}\n");
        }
        this.generateCommandResources(beanName, out);
        this.generateGetDeleteCommandMethod(beanName, out);
        Set<String> elem = model.getElementNames();
        for (String a : elem) {
            System.out.println("a= " + a);
            ConfigModel.Property prop = model.getElement(a);
            if (prop != null && prop.isLeaf()) {
                System.out.println("proxy.getElement(a).isLeaf() " + a);
                if (prop.isCollection()) {
                    String name = this.getBeanName(a);
                    out.write("\t@Path(\"" + a + "/\")\n");
                    out.write("\tpublic " + name + "Resource get" + name + "Resource() {\n");
                    out.write("\t\t" + name + "Resource resource = resourceContext.getResource(" + name + "Resource.class);\n");
                    out.write("\t\tresource.setEntity(getEntity().get" + name + "() );\n");
                    out.write("\t\treturn resource;\n");
                    out.write("\t}\n");
                    this.createCollectionLeafResourceFile(name);
                }
                System.out.println("proxy.getElement(a).isCollection() " + a);
                continue;
            }
            ConfigModel.Node node = (ConfigModel.Node)prop;
            ConfigModel childModel = node.getModel();
            String getterName = this.getBeanName(a);
            System.out.println("Model.targetTypeName" + model.targetTypeName);
            System.out.println("newModel.targetTypeName" + childModel.targetTypeName);
            System.out.println("ConfigModel.Node node isCollection=" + prop.isCollection());
            System.out.println("ConfigModel.Node node isLeaf=" + prop.isLeaf());
            System.out.println("ConfigModel.Node node xlmname=" + prop.xmlName());
            if (childModel.targetTypeName.endsWith("ApplicationName")) {
                a = "application";
                getterName = "Applications";
                try {
                    Class<?> subType = childModel.classLoaderHolder.get().loadClass(childModel.targetTypeName);
                    List<ConfigModel> lcm = this.document.getAllModelsImplementing(subType);
                    if (lcm != null) {
                        for (ConfigModel childmodel : lcm) {
                            System.out.println("***childmodel.targetTypeName" + childmodel.targetTypeName);
                            if (!childmodel.targetTypeName.equals("com.sun.enterprise.config.serverbeans.Application")) continue;
                            childModel = childmodel;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, e.getMessage());
                }
            }
            String childbeanName = childModel.targetTypeName.substring(childModel.targetTypeName.lastIndexOf(".") + 1, childModel.targetTypeName.length());
            if (!childModel.targetTypeName.endsWith("Resource")) {
                String prefix = "";
                if (prop.isCollection()) {
                    prefix = "List";
                }
                if (a.equals("*")) {
                    getterName = childbeanName + "s";
                }
                out.write("\t@Path(\"" + childModel.getTagName() + "/\")\n");
                out.write("\tpublic " + prefix + childbeanName + "Resource get" + childbeanName + "Resource() {\n");
                out.write("\t\t" + prefix + childbeanName + "Resource resource = resourceContext.getResource(" + prefix + childbeanName + "Resource.class);\n");
                out.write("\t\tresource.setEntity(getEntity().get" + getterName + "() );\n");
                out.write("\t\treturn resource;\n");
                out.write("\t}\n");
                if (prop.isCollection()) {
                    this.generateList(childModel);
                    continue;
                }
                this.generateSingle(childModel);
                continue;
            }
            try {
                Class<?> subType = childModel.classLoaderHolder.get().loadClass(childModel.targetTypeName);
                List<ConfigModel> lcm = this.document.getAllModelsImplementing(subType);
                if (lcm == null) continue;
                for (ConfigModel childmodel : lcm) {
                    System.out.println("--->targetTypeName=" + childmodel.targetTypeName);
                    String newName = childmodel.targetTypeName.substring(childmodel.targetTypeName.lastIndexOf(".") + 1, childmodel.targetTypeName.length());
                    out.write("@Path(\"" + childmodel.getTagName() + "/\")\n");
                    out.write("public List" + newName + "Resource get" + newName + "Resource() {\n");
                    out.write("List" + newName + "Resource resource = resourceContext.getResource(List" + newName + "Resource.class);\n");
                    out.write("java.util.List<com.sun.enterprise.config.serverbeans.Resource> l = entity.getResources();\n");
                    out.write("java.util.List<" + childmodel.targetTypeName + "> newList = new java.util.ArrayList();\n");
                    out.write("for (com.sun.enterprise.config.serverbeans.Resource r: l){\n");
                    out.write("try {\n");
                    out.write("if (r instanceof " + childmodel.targetTypeName + ") {\n");
                    out.write("newList.add((" + childmodel.targetTypeName + ")r);\n");
                    out.write("}\n");
                    out.write("} catch (Exception e){\n");
                    out.write("}\n");
                    out.write("}\n");
                    out.write("resource.setEntity(newList );\n");
                    out.write("return resource;\n");
                    out.write("}\n\n\n");
                    this.generateList(childmodel);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        out.write("}\n");
        out.close();
        System.out.println("created:" + file.getAbsolutePath());
    }

    private String getBeanName(String elementName) {
        String ret = "";
        boolean nextisUpper = true;
        for (int i = 0; i < elementName.length(); ++i) {
            if (nextisUpper) {
                ret = ret + elementName.substring(i, i + 1).toUpperCase();
                nextisUpper = false;
                continue;
            }
            if (elementName.charAt(i) == '-') {
                nextisUpper = true;
                continue;
            }
            nextisUpper = false;
            ret = ret + elementName.substring(i, i + 1);
        }
        return ret;
    }

    void generateGetPostCommandMethod(String resourceName, BufferedWriter out) throws IOException {
        String commandName = this.getPostCommandName(resourceName);
        out.write("@Override\n");
        out.write("public String getPostCommand() {\n");
        if (commandName != null) {
            out.write("\treturn \"" + commandName + "\";\n");
        } else {
            out.write("\treturn " + commandName + ";\n");
        }
        out.write("}\n");
    }

    private String getPostCommandName(String resourceName) {
        for (int i = 0; i < MappingConfigBeansToPOSTCommands.length; ++i) {
            if (!resourceName.equals(MappingConfigBeansToPOSTCommands[i][0])) continue;
            return MappingConfigBeansToPOSTCommands[i][1];
        }
        return null;
    }

    void generateGetDeleteCommandMethod(String resourceName, BufferedWriter out) throws IOException {
        String commandName = this.getDeleteCommandName(resourceName);
        if (commandName != null) {
            out.write("@Override\n");
            out.write("public String getDeleteCommand() {\n");
            out.write("\treturn \"" + commandName + "\";\n");
            out.write("}\n");
        }
    }

    private String getDeleteCommandName(String resourceName) {
        for (int i = 0; i < MappingConfigBeansToDELETECommands.length; ++i) {
            if (!resourceName.equals(MappingConfigBeansToDELETECommands[i][0])) continue;
            return MappingConfigBeansToDELETECommands[i][1];
        }
        return null;
    }

    private String[] getCollectionLeafResourceInfo(String resourceName) {
        for (int i = 0; i < ConfigBeansToCommands.length; ++i) {
            if (!resourceName.equals(ConfigBeansToCommands[i][0])) continue;
            return ConfigBeansToCommands[i];
        }
        return null;
    }

    private void generateCommandResources(String resourceName, BufferedWriter out) throws IOException {
        if (this.genCommandResourceFiles.containsKey(resourceName)) {
            return;
        }
        this.genCommandResourceFiles.put(resourceName, resourceName);
        String commandResourcesPaths = "{";
        for (int i = 0; i < ConfigBeansToCommandResourcesMap.length; ++i) {
            if (!resourceName.equals(ConfigBeansToCommandResourcesMap[i][0])) continue;
            if (commandResourcesPaths.length() > 1) {
                commandResourcesPaths = commandResourcesPaths + ", ";
            }
            commandResourcesPaths = commandResourcesPaths + "{" + "\"" + ConfigBeansToCommandResourcesMap[i][3] + "\"" + ", " + "\"" + ConfigBeansToCommandResourcesMap[i][2] + "\"" + "}";
            String commandResourceFileName = this.genDir + "/" + resourceName + this.getBeanName(ConfigBeansToCommandResourcesMap[i][3]) + "Resource.java";
            String commandResourceName = resourceName + this.getBeanName(ConfigBeansToCommandResourcesMap[i][3]) + "Resource";
            this.createCommandResourceFile(commandResourceFileName, commandResourceName, ConfigBeansToCommandResourcesMap[i]);
            out.write("@Path(\"" + ConfigBeansToCommandResourcesMap[i][3] + "/\")\n");
            out.write("public " + commandResourceName + " get" + commandResourceName + "() {\n");
            out.write(commandResourceName + " resource = resourceContext.getResource(" + commandResourceName + ".class);\n");
            out.write("return resource;\n");
            out.write("}\n\n");
        }
        if (!(commandResourcesPaths = commandResourcesPaths + "}").equals("{}")) {
            out.write("@Override\n");
            out.write("public String[][] getCommandResourcesPaths() {\n");
            out.write("return new String[][]" + commandResourcesPaths + ";\n");
            out.write("}\n\n");
        }
    }

    private void createCommandResourceFile(String commandResourceFileName, String commandResourceName, String[] configBeansToCommandResourcesArray) throws IOException {
        String resourceName = configBeansToCommandResourcesArray[0] + this.getBeanName(configBeansToCommandResourcesArray[3]);
        String commandName = configBeansToCommandResourcesArray[1];
        String commandDisplayName = configBeansToCommandResourcesArray[3];
        String commandMethod = configBeansToCommandResourcesArray[2];
        String commandAction = configBeansToCommandResourcesArray[4];
        File file = new File(commandResourceFileName);
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        FileWriter fstream = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fstream);
        this.genHeader(out);
        out.write("package org.glassfish.admin.rest.resources;\n\n");
        out.write("//generated code...;\n\n");
        if (commandMethod.equals("GET")) {
            out.write("public class " + commandResourceName + " extends org.glassfish.admin.rest.TemplateCommandGetResource {\n");
        }
        if (commandMethod.equals("DELETE")) {
            out.write("public class " + commandResourceName + " extends org.glassfish.admin.rest.TemplateCommandDeleteResource {\n");
        }
        if (commandMethod.equals("POST")) {
            out.write("public class " + commandResourceName + " extends org.glassfish.admin.rest.TemplateCommandPostResource {\n");
        }
        out.write("   public " + commandResourceName + "() {\n");
        out.write("       super(\n");
        out.write("          \"" + resourceName + "\",\n");
        out.write("          \"" + commandName + "\",\n");
        out.write("          \"" + commandMethod + "\",\n");
        if (!commandMethod.equals("GET")) {
            out.write("          \"" + commandAction + "\",\n");
            out.write("          \"" + commandDisplayName + "\",\n");
        }
        boolean isLinkedToParent = false;
        if (configBeansToCommandResourcesArray.length > 5) {
            out.write("          new java.util.HashMap<String, String>() {{\n");
            for (int i = 5; i <= configBeansToCommandResourcesArray.length - 1; ++i) {
                String[] name_value = GeneratorResource.stringToArray(configBeansToCommandResourcesArray[i], "=");
                if (name_value[1].equals("$parent")) {
                    isLinkedToParent = true;
                }
                out.write("                    put(\"" + name_value[0] + "\",\"" + name_value[1] + "\");\n");
            }
            out.write("       }},\n");
        } else {
            out.write("          (java.util.HashMap<String, String>) null ,\n");
        }
        out.write("          " + isLinkedToParent + ");\n");
        out.write("    }\n");
        out.write("}\n");
        out.close();
        System.out.println("created:" + file.getAbsolutePath());
    }

    private void createCollectionLeafResourceFile(String beanName) throws IOException {
        String resourceFileName = this.genDir + "/" + beanName + "Resource.java";
        String resourceName = beanName + "Resource";
        File file = new File(resourceFileName);
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, e.getMessage());
        }
        FileWriter fstream = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fstream);
        this.genHeader(out);
        out.write("package org.glassfish.admin.rest.resources;\n\n");
        out.write("import org.glassfish.admin.rest.CollectionLeafResource;\n\n");
        out.write("public class " + resourceName + " extends CollectionLeafResource {\n\n");
        String[] collectionLeafResourceInfo = this.getCollectionLeafResourceInfo(beanName);
        if (collectionLeafResourceInfo != null) {
            if (collectionLeafResourceInfo[1] != null && !collectionLeafResourceInfo[1].equals("")) {
                out.write("@Override\n");
                out.write("protected String getPostCommand(){\n");
                out.write("return \"" + collectionLeafResourceInfo[1] + "\";\n");
                out.write("}\n");
            }
            if (collectionLeafResourceInfo[2] != null && !collectionLeafResourceInfo[2].equals("")) {
                out.write("@Override\n");
                out.write("protected String getDeleteCommand(){\n");
                out.write("return \"" + collectionLeafResourceInfo[2] + "\";\n");
                out.write("}\n");
            }
            out.write("@Override\n");
            out.write("protected String getName(){\n");
            out.write("return \"" + collectionLeafResourceInfo[3] + "\";\n");
            out.write("}\n");
        }
        out.write("}\n");
        out.close();
    }

    private static String[] stringToArray(String str, String delimiter) {
        String[] retString = new String[]{};
        if (str != null && delimiter != null) {
            StringTokenizer tokens = new StringTokenizer(str, delimiter);
            retString = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                retString[i++] = tokens.nextToken();
            }
        }
        return retString;
    }
}

