/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil
extends Util {
    public void adjustParameters(HashMap<String, String> data) {
        boolean isRenamed;
        if (data != null && !data.containsKey("DEFAULT") && !(isRenamed = this.renameParameter(data, "name", "DEFAULT"))) {
            this.renameParameter(data, "id", "DEFAULT");
        }
    }

    public void defineDefaultParameters(HashMap<String, String> data) {
        if (data != null && !data.containsKey("DEFAULT")) {
            this.renameParameter(data, "id", "DEFAULT");
        }
    }

    public String getCommand(RestRedirect.OpType type, ConfigBean configBean) {
        Class<?> cbp = null;
        try {
            cbp = configBean.model.classLoaderHolder.get().loadClass(configBean.model.targetTypeName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        RestRedirects restRedirects = cbp.getAnnotation(RestRedirects.class);
        if (restRedirects != null) {
            RestRedirect[] values;
            for (RestRedirect r : values = restRedirects.value()) {
                if (!r.opType().equals((Object)type)) continue;
                return r.commandName();
            }
        }
        return null;
    }

    public ActionReport runCommand(String commandName, HashMap<String, String> parameters, Habitat habitat) {
        CommandRunner cr = habitat.getComponent(CommandRunner.class);
        ActionReport ar = habitat.getComponent(ActionReport.class);
        ParameterMap p = new ParameterMap();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            p.set((Object)entry.getKey(), (Object)entry.getValue());
        }
        cr.getCommandInvocation(commandName, ar).parameters(p).execute();
        return ar;
    }

    public ActionReport runCommand(String commandName, Properties parameters, Habitat habitat) {
        CommandRunner cr = habitat.getComponent(CommandRunner.class);
        ActionReport ar = habitat.getComponent(ActionReport.class);
        ParameterMap p = new ParameterMap();
        for (String prop : parameters.stringPropertyNames()) {
            p.set((Object)prop, (Object)parameters.getProperty(prop));
        }
        cr.getCommandInvocation(commandName, ar).parameters(p).execute();
        return ar;
    }

    public MethodMetaData getMethodMetaData(String command, Habitat habitat, Logger logger) {
        return this.getMethodMetaData(command, 1, habitat, logger);
    }

    public MethodMetaData getMethodMetaData(String command, int pamameterType, Habitat habitat, Logger logger) {
        return this.getMethodMetaData(command, null, pamameterType, habitat, logger);
    }

    public MethodMetaData getMethodMetaData(String command, HashMap<String, String> commandParamsToSkip, int pamameterType, Habitat habitat, Logger logger) {
        MethodMetaData methodMetaData = new MethodMetaData();
        if (command != null) {
            Collection<CommandModel.ParamModel> params = commandParamsToSkip == null ? this.getParamMetaData(command, habitat, logger) : this.getParamMetaData(command, commandParamsToSkip.keySet(), habitat, logger);
            for (CommandModel.ParamModel paramModel : params) {
                String parameterName;
                Param param = paramModel.getParam();
                ParameterMetaData parameterMetaData = this.getParameterMetaData(paramModel);
                String string = parameterName = paramModel.getParam().primary() ? "id" : paramModel.getName();
                if (pamameterType == 0) {
                    methodMetaData.putQureyParamMetaData(parameterName, parameterMetaData);
                    continue;
                }
                methodMetaData.putParameterMetaData(parameterName, parameterMetaData);
            }
        }
        return methodMetaData;
    }

    public void resolveParentParamValue(HashMap<String, String> commandParams, UriInfo uriInfo) {
        String parent = this.getParentName(uriInfo);
        if (parent != null) {
            Set<String> keys = commandParams.keySet();
            for (String key : keys) {
                if (!commandParams.get(key).equals("$parent")) continue;
                commandParams.put(key, parent);
                break;
            }
        }
    }

    public MethodMetaData getMethodMetaData(ConfigBean configBean) {
        return this.getMethodMetaData(configBean, 1);
    }

    public MethodMetaData getMethodMetaData(ConfigBean configBean, int parameterType) {
        MethodMetaData methodMetaData = new MethodMetaData();
        if (configBean != null) {
            Class<?> configBeanProxy = null;
            try {
                configBeanProxy = configBean.model.classLoaderHolder.get().loadClass(configBean.model.targetTypeName);
                Set<String> attributeNames = configBean.model.getAttributeNames();
                for (String attributeName : attributeNames) {
                    String methodName = this.getAttributeMethodName(attributeName);
                    try {
                        Method method = configBeanProxy.getMethod(methodName, new Class[0]);
                        Attribute attribute = method.getAnnotation(Attribute.class);
                        if (attribute == null) continue;
                        ParameterMetaData parameterMetaData = this.getParameterMetaData(attribute);
                        if (parameterType == 0) {
                            methodMetaData.putQureyParamMetaData(attributeName, parameterMetaData);
                            continue;
                        }
                        methodMetaData.putParameterMetaData(attributeName, parameterMetaData);
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return methodMetaData;
    }

    public Collection<CommandModel.ParamModel> getParamMetaData(String commandName, Habitat habitat, Logger logger) {
        CommandRunner cr = habitat.getComponent(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, logger);
        Collection params = cm.getParameters();
        return params;
    }

    public Collection<CommandModel.ParamModel> getParamMetaData(String commandName, Collection<String> commandParamsToSkip, Habitat habitat, Logger logger) {
        CommandRunner cr = habitat.getComponent(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, logger);
        Collection parameterNames = cm.getParametersNames();
        ArrayList<CommandModel.ParamModel> metaData = new ArrayList<CommandModel.ParamModel>();
        for (String name : parameterNames) {
            CommandModel.ParamModel paramModel = cm.getModelFor(name);
            String parameterName = paramModel.getParam().primary() ? "id" : paramModel.getName();
            boolean skipParameter = false;
            try {
                skipParameter = commandParamsToSkip.contains(parameterName);
            }
            catch (Exception e) {
                String errorMessage = localStrings.getLocalString("rest.metadata.skip.error", "Parameter \"{0}\" may be redundant and not required.", new Object[]{parameterName});
                Logger.getLogger(ResourceUtil.class.getName()).log(Level.INFO, null, errorMessage);
                Logger.getLogger(ResourceUtil.class.getName()).log(Level.INFO, null, e);
            }
            if (skipParameter) continue;
            metaData.add(paramModel);
        }
        return metaData;
    }

    public void purgeEmptyEntries(HashMap<String, String> data) {
        Set<String> keys = data.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (data.get(key) != null && data.get(key).length() >= 1) continue;
            data.remove(key);
            iterator = keys.iterator();
        }
    }

    public Response getResponse(int status, String message, HttpHeaders requestHeaders, UriInfo uriInfo) {
        if (this.isBrowser(requestHeaders)) {
            message = this.getHtml(message, uriInfo);
        }
        return Response.status((int)status).entity((Object)message).build();
    }

    public String getMessage(ActionReport actionReport) {
        String message = "";
        if (actionReport != null && (message = actionReport.getMessage()) == null) {
            message = "";
            boolean first = true;
            for (ActionReport.MessagePart mp : actionReport.getTopMessagePart().getChildren()) {
                if (!first) {
                    message = message + ", ";
                }
                message = message + mp.getMessage();
                first = false;
            }
        }
        return message;
    }

    private ParameterMetaData getParameterMetaData(CommandModel.ParamModel paramModel) {
        Param param = paramModel.getParam();
        ParameterMetaData parameterMetaData = new ParameterMetaData();
        parameterMetaData.putAttribute("Type", this.getXsdType(paramModel.getType().toString()));
        parameterMetaData.putAttribute("Optional", Boolean.toString(param.optional()));
        parameterMetaData.putAttribute("Default Value", param.defaultValue());
        parameterMetaData.putAttribute("Acceptable Values", param.acceptableValues());
        return parameterMetaData;
    }

    private ParameterMetaData getParameterMetaData(Attribute attribute) {
        ParameterMetaData parameterMetaData = new ParameterMetaData();
        parameterMetaData.putAttribute("Type", this.getXsdType(attribute.dataType().toString()));
        parameterMetaData.putAttribute("Optional", Boolean.toString(!attribute.required()));
        if (!attribute.defaultValue().equals("\u0000")) {
            parameterMetaData.putAttribute("Default Value", attribute.defaultValue());
        }
        parameterMetaData.putAttribute("Key", Boolean.toString(attribute.key()));
        return parameterMetaData;
    }

    private boolean renameParameter(HashMap<String, String> data, String parameterToRename, String newName) {
        if (data.containsKey(parameterToRename)) {
            String value = data.get(parameterToRename);
            data.remove(parameterToRename);
            data.put(newName, value);
            return true;
        }
        return false;
    }

    private void print(Collection<CommandModel.ParamModel> params) {
        for (CommandModel.ParamModel pm : params) {
            System.out.println("Command Param: " + pm.getName());
            System.out.println("Command Param Type: " + pm.getType());
            System.out.println("Command Param Name: " + pm.getParam().name());
            System.out.println("Command Param Shortname: " + pm.getParam().shortName());
        }
    }

    private boolean isBrowser(HttpHeaders requestHeaders) {
        boolean isClientAcceptsHtml = false;
        MediaType media = requestHeaders.getMediaType();
        List acceptHeaders = requestHeaders.getRequestHeader("Accept");
        for (String header : acceptHeaders) {
            if (!header.contains("text/html")) continue;
            isClientAcceptsHtml = true;
            break;
        }
        return media != null && media.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && isClientAcceptsHtml;
    }

    private String getXsdType(String javaType) {
        if (javaType.indexOf("java.lang.String") != -1) {
            return "string";
        }
        if (javaType.indexOf("java.lang.Boolean") != -1) {
            return "boolean";
        }
        if (javaType.indexOf("java.lang.Integer") != -1) {
            return "int";
        }
        if (javaType.indexOf("java.util.Properties") != -1) {
            return "string";
        }
        return javaType;
    }

    private String getAttributeMethodName(String attributeName) {
        return this.methodNameFromDtdName(attributeName, "get");
    }
}

