/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.OptionsResult;
import org.glassfish.admin.rest.provider.StringResult;
import org.glassfish.api.ActionReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCommandGetResource {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceUtil.class);
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    private String resourceName;
    private String commandName;
    private String commandMethod;
    private HashMap<String, String> commandParams = null;
    private boolean isLinkedToParent = false;
    private ResourceUtil resourceUtil = new ResourceUtil();

    public TemplateCommandGetResource(String resourceName, String commandName, String commandMethod, HashMap<String, String> m, boolean b) {
        this.resourceName = resourceName;
        this.commandName = commandName;
        this.commandMethod = commandMethod;
        this.commandParams = m;
        this.isLinkedToParent = b;
    }

    @GET
    @Produces(value={"text/html", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    public StringResult executeCommand() {
        try {
            Properties properties = new Properties();
            if (this.commandParams != null) {
                if (this.isLinkedToParent) {
                    this.resourceUtil.resolveParentParamValue(this.commandParams, this.uriInfo);
                }
                properties.putAll((Map<?, ?>)this.commandParams);
            }
            ActionReport actionReport = this.resourceUtil.runCommand(this.commandName, properties, RestService.getHabitat());
            ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
            StringResult results = new StringResult(this.commandName, this.resourceUtil.getMessage(actionReport), this.options());
            if (exitCode == ActionReport.ExitCode.SUCCESS) {
                results.setStatusCode(200);
            } else {
                results.setStatusCode(400);
                results.setIsError(true);
                results.setErrorMessage(actionReport.getMessage());
            }
            return results;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html", "application/xml"})
    public OptionsResult options() {
        OptionsResult optionsResult = new OptionsResult(this.resourceName);
        try {
            MethodMetaData methodMetaData = this.resourceUtil.getMethodMetaData(this.commandName, this.commandParams, 0, RestService.getHabitat(), RestService.logger);
            optionsResult.putMethodMetaData(this.commandMethod, methodMetaData);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return optionsResult;
    }
}

