/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.TemplateResource;
import org.glassfish.admin.rest.provider.GetResultList;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.OptionsResult;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateListOfResource<E extends ConfigBeanProxy> {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    protected List<E> entity;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateListOfResource.class);
    private ResourceUtil __resourceUtil = new ResourceUtil();

    @GET
    @Produces(value={"text/html", "application/json", "application/xml"})
    public GetResultList get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        ArrayList<Dom> domList = new ArrayList<Dom>();
        List<E> entities = this.getEntity();
        if (entities == null) {
            return new GetResultList(domList, this.getPostCommand(), this.getCommandResourcesPaths(), this.options());
        }
        for (ConfigBeanProxy e : entities) {
            domList.add(Dom.unwrap(e));
        }
        return new GetResultList(domList, this.getPostCommand(), this.getCommandResourcesPaths(), this.options());
    }

    public void setEntity(List<E> p) {
        this.entity = p;
    }

    public List<E> getEntity() {
        return this.entity;
    }

    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response CreateResource(HashMap<String, String> data) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return this.__resourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            this.__resourceUtil.purgeEmptyEntries(data);
            String commandName = this.getPostCommand();
            this.__resourceUtil.adjustParameters(data);
            String resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + data.get("DEFAULT");
            if (null != commandName) {
                ActionReport actionReport = this.__resourceUtil.runCommand(commandName, data, RestService.getHabitat());
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode == ActionReport.ExitCode.SUCCESS) {
                    String successMessage = localStrings.getLocalString("rest.resource.create.message", "\"{0}\" created successfully.", new Object[]{resourceToCreate});
                    return this.__resourceUtil.getResponse(201, successMessage, this.requestHeaders, this.uriInfo);
                }
                String errorMessage = this.getErrorMessage(data, actionReport);
                return this.__resourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            String message = localStrings.getLocalString("rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.", new Object[]{resourceToCreate});
            return this.__resourceUtil.getResponse(403, message, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response CreateResource(HashMap<String, String> data, String resourceToCreate) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return this.__resourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            this.__resourceUtil.purgeEmptyEntries(data);
            String commandName = this.getPostCommand();
            this.__resourceUtil.defineDefaultParameters(data);
            if (resourceToCreate == null || resourceToCreate.equals("")) {
                String newResourceName = data.get("DEFAULT");
                if (newResourceName.contains("/")) {
                    newResourceName = this.__resourceUtil.getName(newResourceName, '/');
                } else if (newResourceName.contains("\\")) {
                    newResourceName = this.__resourceUtil.getName(newResourceName, '\\');
                }
                resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + newResourceName;
            } else {
                resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + resourceToCreate;
            }
            if (null != commandName) {
                ActionReport actionReport = this.__resourceUtil.runCommand(commandName, data, RestService.getHabitat());
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode == ActionReport.ExitCode.SUCCESS) {
                    String successMessage = localStrings.getLocalString("rest.resource.create.message", "\"{0}\" created successfully.", new Object[]{resourceToCreate});
                    return this.__resourceUtil.getResponse(201, successMessage, this.requestHeaders, this.uriInfo);
                }
                String errorMessage = this.getErrorMessage(data, actionReport);
                return this.__resourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            String message = localStrings.getLocalString("rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.", new Object[]{resourceToCreate});
            return this.__resourceUtil.getResponse(403, message, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response post(FormDataMultiPart formData) {
        HashMap<String, String> data = TemplateResource.createDataBasedOnForm(formData);
        return this.CreateResource(data, data.get("name"));
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html", "application/xml"})
    public OptionsResult options() {
        OptionsResult optionsResult = new OptionsResult(this.__resourceUtil.getResourceName(this.uriInfo));
        try {
            optionsResult.putMethodMetaData("GET", new MethodMetaData());
            String command = this.getPostCommand();
            if (command != null) {
                MethodMetaData postMethodMetaData = this.__resourceUtil.getMethodMetaData(command, RestService.getHabitat(), RestService.logger);
                postMethodMetaData.setDescription("Create");
                if (this.__resourceUtil.getResourceName(this.uriInfo).equals("Application")) {
                    postMethodMetaData.setIsFileUploadOperation(true);
                }
                optionsResult.putMethodMetaData("POST", postMethodMetaData);
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return optionsResult;
    }

    public abstract String getPostCommand();

    public String[][] getCommandResourcesPaths() {
        return new String[0][];
    }

    private String getErrorMessage(HashMap<String, String> data, ActionReport ar) {
        String message = ar.getMessage();
        return message;
    }
}

