/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.OptionsResult;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.provider.ProviderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
public class OptionsResultJsonProvider
extends ProviderUtil
implements MessageBodyWriter<OptionsResult> {
    @Context
    protected UriInfo uriInfo;

    public long getSize(OptionsResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(OptionsResult.class);
    }

    public void writeTo(OptionsResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.getJson(proxy).getBytes());
    }

    private String getJson(OptionsResult proxy) {
        String indent = "  ";
        String result = "{" + OptionsResultJsonProvider.quote(proxy.getName()) + ":";
        result = result + "\n" + indent + "{";
        result = result + this.getRespresenationForMethodMetaData(proxy, indent + "  ");
        result = result + "\n" + indent + "}";
        result = result + "\n}";
        return result;
    }

    String getRespresenationForMethodMetaData(OptionsResult proxy, String indent) {
        String result = "";
        Set<String> methods = proxy.methods();
        Iterator<String> iterator = methods.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            String method = iterator.next();
            if (!first) {
                result = result + ",";
            }
            MethodMetaData methodMetaData = proxy.getMethodMetaData(method);
            result = result + this.getMethod(method, methodMetaData, indent);
            first = false;
        }
        return result;
    }

    private String getMethod(String method, MethodMetaData methodMetaData, String indent) {
        String result = "\n" + indent;
        result = result + OptionsResultJsonProvider.quote("Method") + ":{";
        result = result + "\n" + indent + "  " + OptionsResultJsonProvider.quote("Name") + ":" + OptionsResultJsonProvider.quote(method);
        result = result + this.getQueryParams(methodMetaData, indent + "  ");
        result = result + this.getMessageParams(methodMetaData, indent + "  ");
        result = result + "\n" + indent + "}";
        return result;
    }

    private String getQueryParams(MethodMetaData methodMetaData, String indent) {
        String result = "";
        if (methodMetaData.sizeQueryParamMetaData() > 0) {
            result = result + "," + "\n" + indent;
            result = result + OptionsResultJsonProvider.quote("Query Parameters") + ":{";
            Set<String> queryParams = methodMetaData.queryParams();
            Iterator<String> iterator = queryParams.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (!first) {
                    result = result + ",";
                }
                String queryParam = iterator.next();
                ParameterMetaData parameterMetaData = methodMetaData.getQureyParamMetaData(queryParam);
                result = result + this.getParameter(queryParam, parameterMetaData, indent + "  ");
                first = false;
            }
            result = result + "\n" + indent + "}";
        }
        return result;
    }

    private String getMessageParams(MethodMetaData methodMetaData, String indent) {
        String result = "";
        if (methodMetaData.sizeParameterMetaData() > 0) {
            result = result + "," + "\n" + indent;
            result = result + OptionsResultJsonProvider.quote("Message Parameters") + ":{";
            Set<String> parameters = methodMetaData.parameters();
            Iterator<String> iterator = parameters.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (!first) {
                    result = result + ",";
                }
                String parameter = iterator.next();
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                result = result + this.getParameter(parameter, parameterMetaData, indent + "  ");
                first = false;
            }
            result = result + "\n" + indent + "}";
        }
        return result;
    }

    private String getParameter(String parameter, ParameterMetaData parameterMetaData, String indent) {
        String result = "\n" + indent;
        result = result + OptionsResultJsonProvider.quote(parameter) + ":{";
        Set<String> attributes = parameterMetaData.attributes();
        Iterator<String> iterator = attributes.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                result = result + ", ";
            }
            String attributeName = iterator.next();
            String attributeValue = parameterMetaData.getAttributeValue(attributeName);
            result = result + this.getAttribute(attributeName, attributeValue);
            first = false;
        }
        result = result + "}";
        return result;
    }

    private String getAttribute(String name, String value) {
        String result = "";
        result = result + OptionsResultJsonProvider.quote(name) + ":" + OptionsResultJsonProvider.quote(value);
        return result;
    }
}

