/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.Reader;
import java.util.HashMap;
import org.glassfish.admin.rest.provider.InputException;
import org.glassfish.admin.rest.provider.InputReader;
import org.glassfish.admin.rest.provider.XmlInputObject;

public class XmlInputReader
extends InputReader {
    public static final HashMap entity = new HashMap(8);

    public XmlInputReader(Reader reader) {
        super(reader);
    }

    public XmlInputReader(String s) {
        super(s);
    }

    public String nextCDATA() throws InputException {
        int i;
        StringBuffer sb = new StringBuffer();
        do {
            char c;
            if ((c = this.next()) == '\u0000') {
                throw this.error("Unclosed CDATA");
            }
            sb.append(c);
        } while ((i = sb.length() - 3) < 0 || sb.charAt(i) != ']' || sb.charAt(i + 1) != ']' || sb.charAt(i + 2) != '>');
        sb.setLength(i);
        return sb.toString();
    }

    public Object nextContent() throws InputException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            return XmlInputObject.LT;
        }
        StringBuffer sb = new StringBuffer();
        while (true) {
            if (c == '<' || c == '\u0000') {
                this.back();
                return sb.toString().trim();
            }
            if (c == '&') {
                sb.append(this.nextEntity(c));
            } else {
                sb.append(c);
            }
            c = this.next();
        }
    }

    public Object nextEntity(char a) throws InputException {
        char c;
        StringBuffer sb = new StringBuffer();
        while (Character.isLetterOrDigit(c = this.next()) || c == '#') {
            sb.append(Character.toLowerCase(c));
        }
        if (c != ';') {
            throw this.error("Missing ';' in XML entity: &" + sb);
        }
        String s = sb.toString();
        Object e = entity.get(s);
        return e != null ? e : a + s + ";";
    }

    public Object nextMeta() throws InputException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.error("Misshaped meta tag");
            }
            case '<': {
                return XmlInputObject.LT;
            }
            case '>': {
                return XmlInputObject.GT;
            }
            case '/': {
                return XmlInputObject.SLASH;
            }
            case '=': {
                return XmlInputObject.EQ;
            }
            case '!': {
                return XmlInputObject.BANG;
            }
            case '?': {
                return XmlInputObject.QUEST;
            }
            case '\"': 
            case '\'': {
                char q = c;
                do {
                    if ((c = this.next()) != '\u0000') continue;
                    throw this.error("Unterminated string");
                } while (c != q);
                return Boolean.TRUE;
            }
        }
        while (!Character.isWhitespace(c = this.next())) {
            switch (c) {
                case '\u0000': 
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public Object nextToken() throws InputException {
        char c;
        while (Character.isWhitespace(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.error("Misshaped element");
            }
            case '<': {
                throw this.error("Misplaced '<'");
            }
            case '>': {
                return XmlInputObject.GT;
            }
            case '/': {
                return XmlInputObject.SLASH;
            }
            case '=': {
                return XmlInputObject.EQ;
            }
            case '!': {
                return XmlInputObject.BANG;
            }
            case '?': {
                return XmlInputObject.QUEST;
            }
            case '\"': 
            case '\'': {
                char q = c;
                StringBuffer sb = new StringBuffer();
                while (true) {
                    if ((c = this.next()) == '\u0000') {
                        throw this.error("Unterminated string");
                    }
                    if (c == q) {
                        return sb.toString();
                    }
                    if (c == '&') {
                        sb.append(this.nextEntity(c));
                        continue;
                    }
                    sb.append(c);
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        while (true) {
            sb.append(c);
            c = this.next();
            if (Character.isWhitespace(c)) {
                return sb.toString();
            }
            switch (c) {
                case '\u0000': {
                    return sb.toString();
                }
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': {
                    this.back();
                    return sb.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw this.error("Bad character in a name");
                }
            }
        }
    }

    public boolean skipPast(String to) throws InputException {
        char c;
        int i;
        int offset = 0;
        int n = to.length();
        char[] circle = new char[n];
        for (i = 0; i < n; ++i) {
            c = this.next();
            if (c == '\u0000') {
                return false;
            }
            circle[i] = c;
        }
        while (true) {
            int j = offset;
            boolean b = true;
            for (i = 0; i < n; ++i) {
                if (circle[j] != to.charAt(i)) {
                    b = false;
                    break;
                }
                if (++j < n) continue;
                j -= n;
            }
            if (b) {
                return true;
            }
            c = this.next();
            if (c == '\u0000') {
                return false;
            }
            circle[offset] = c;
            if (++offset < n) continue;
            offset -= n;
        }
    }

    static {
        entity.put("amp", XmlInputObject.AMP);
        entity.put("apos", XmlInputObject.APOS);
        entity.put("gt", XmlInputObject.GT);
        entity.put("lt", XmlInputObject.LT);
        entity.put("quot", XmlInputObject.QUOT);
    }
}

