/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.util.OS;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jps {
    private Map<String, Integer> pidMap = new HashMap<String, Integer>();
    private static final File jpsExe;
    private static final String jpsName;

    public static void main(String[] args) {
        Set<Map.Entry<String, Integer>> set = Jps.getProcessTable().entrySet();
        System.out.println("** Got " + set.size() + " process entries");
        for (Map.Entry<String, Integer> e : set) {
            System.out.printf("%d %s\n", e.getValue(), e.getKey());
        }
    }

    public static final Map<String, Integer> getProcessTable() {
        return new Jps().pidMap;
    }

    public static final int getPid(String mainClassName) {
        Jps jps = new Jps();
        Integer integer = jps.pidMap.get(mainClassName);
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public static final boolean isPid(int apid) {
        return new Jps().pidMap.containsValue(apid);
    }

    private Jps() {
        try {
            String[] ss;
            if (jpsExe == null) {
                return;
            }
            ProcessManager pm = new ProcessManager(jpsExe.getPath(), "-l");
            pm.execute();
            String jpsOutput = pm.getStdout();
            for (String line : ss = jpsOutput.split("[\n\r]")) {
                String[] sublines;
                if (line == null || line.length() <= 0 || (sublines = line.split(" ")) == null || sublines.length != 2) continue;
                int aPid = 0;
                try {
                    aPid = Integer.parseInt(sublines[0]);
                }
                catch (Exception e) {
                    continue;
                }
                if (this.isJps(sublines[1])) continue;
                this.pidMap.put(sublines[1], aPid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isJps(String id) {
        if (!StringUtils.ok(id)) {
            return false;
        }
        if (id.equals(this.getClass().getName())) {
            return true;
        }
        return id.equals("sun.tools.jps.Jps");
    }

    static {
        jpsName = OS.isWindows() ? "jps.exe" : "jps";
        String javaroot = System.getProperty("java.home");
        String relpath = "/bin/" + jpsName;
        File fhere = new File(javaroot + relpath);
        File fthere = new File(javaroot + "/.." + relpath);
        jpsExe = fhere.isFile() ? SmartFile.sanitize(fhere) : (fthere.isFile() ? SmartFile.sanitize(fthere) : null);
    }
}

