/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    static final Logger _logger = Logger.getLogger("javax.enterprise.system.util");
    static final Logger _utillogger = LogDomains.getLogger(FileUtils.class, "javax.enterprise.system.util");
    private static final int BUFFER_SIZE = 65536;
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static final String ILLEGAL_FILENAME_STRING = "\\/:*?\"<>|";
    private static final char REPLACEMENT_CHAR = '_';
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static String TMPFILENAME = "scratch";
    private static final int FILE_OPERATION_MAX_RETRIES = Integer.getInteger("com.sun.appserv.winFileLockRetryLimit", 4);
    private static final int FILE_OPERATION_SLEEP_DELAY_MS = Integer.getInteger("com.sun.appserv.winFileLockRetryDelay", 100);
    private static final Level FILE_OPERATION_LOG_LEVEL = Level.FINE;

    public static File[] listFiles(File f) {
        try {
            File[] files = f.listFiles();
            if (files != null) {
                return files;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static File[] listFiles(File f, FileFilter ff) {
        try {
            File[] files = f.listFiles(ff);
            if (files != null) {
                return files;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static File[] listFiles(File f, FilenameFilter fnf) {
        try {
            File[] files = f.listFiles(fnf);
            if (files != null) {
                return files;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File[0];
    }

    public static boolean safeIsDirectory(File f) {
        return f != null && f.exists() && f.isDirectory();
    }

    public static boolean safeIsRealDirectory(String s) {
        return FileUtils.safeIsRealDirectory(new File(s));
    }

    public static boolean safeIsRealDirectory(File f) {
        String absolute;
        if (!FileUtils.safeIsDirectory(f)) {
            return false;
        }
        String canonical = FileUtils.safeGetCanonicalPath(f);
        if (canonical.equals(absolute = f.getAbsolutePath())) {
            return true;
        }
        return OS.isWindows() && canonical.equalsIgnoreCase(absolute);
    }

    public static boolean safeIsDirectory(String s) {
        return FileUtils.safeIsDirectory(new File(s));
    }

    public static String safeGetCanonicalPath(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static File safeGetCanonicalFile(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    public static boolean hasExtension(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.endsWith(ext);
    }

    public static boolean hasExtension(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().endsWith(ext);
    }

    public static boolean hasExtensionIgnoreCase(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.toLowerCase().endsWith(ext.toLowerCase());
    }

    public static boolean hasExtensionIgnoreCase(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().toLowerCase().endsWith(ext.toLowerCase());
    }

    public static boolean isLegalFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFriendlyFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return FileUtils.isLegalFilename(filename);
    }

    public static String makeLegalFilename(String filename) {
        if (FileUtils.isLegalFilename(filename)) {
            return filename;
        }
        filename = filename.replaceAll("[/" + Pattern.quote("\\") + "]", "__");
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            filename = filename.replace(ILLEGAL_FILENAME_CHARS[i], '_');
        }
        return filename;
    }

    public static String makeLegalNoBlankFileName(String filename) {
        return FileUtils.makeLegalFilename(filename).replace(' ', '_');
    }

    public static String makeFriendlyFilename(String filename) {
        if (FileUtils.isFriendlyFilename(filename)) {
            return filename;
        }
        String ret = FileUtils.makeLegalFilename(filename).replace(' ', '_');
        ret = ret.replace('.', '_');
        return ret;
    }

    public static String makeFriendlyFilenameNoExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            filename = filename.substring(0, index);
        }
        return FileUtils.makeFriendlyFilename(filename);
    }

    public static String makeFriendlyFilenameExtension(String filename) {
        if (filename == null) {
            return null;
        }
        filename = FileUtils.makeLegalNoBlankFileName(filename);
        String extension = "";
        if (filename.endsWith(".ear")) {
            filename = filename.substring(0, filename.indexOf(".ear"));
            extension = "_ear";
        } else if (filename.endsWith(".war")) {
            filename = filename.substring(0, filename.indexOf(".war"));
            extension = "_war";
        } else if (filename.endsWith(".jar")) {
            filename = filename.substring(0, filename.indexOf(".jar"));
            extension = "_jar";
        } else if (filename.endsWith(".rar")) {
            filename = filename.substring(0, filename.indexOf(".rar"));
            extension = "_rar";
        }
        return filename + extension;
    }

    public static String revertFriendlyFilenameExtension(String filename) {
        if (filename == null || !filename.endsWith("_ear") && !filename.endsWith("_war") && !filename.endsWith("_jar") && !filename.endsWith("_rar")) {
            return filename;
        }
        String extension = "";
        if (filename.endsWith("_ear")) {
            filename = filename.substring(0, filename.indexOf("_ear"));
            extension = ".ear";
        } else if (filename.endsWith("_war")) {
            filename = filename.substring(0, filename.indexOf("_war"));
            extension = ".war";
        } else if (filename.endsWith("_jar")) {
            filename = filename.substring(0, filename.indexOf("_jar"));
            extension = ".jar";
        } else if (filename.endsWith("_rar")) {
            filename = filename.substring(0, filename.indexOf("_rar"));
            extension = ".rar";
        }
        return filename + extension;
    }

    public static String revertFriendlyFilename(String filename) {
        String name = FileUtils.revertFriendlyFilenameExtension(filename);
        return name.replaceAll("__", "/");
    }

    public static void liquidate(File parent) {
        FileUtils.whack(parent);
    }

    public static boolean isJar(String filename) {
        return FileUtils.hasExtension(filename, ".jar");
    }

    public static boolean isZip(String filename) {
        return FileUtils.hasExtensionIgnoreCase(filename, ".zip");
    }

    public static boolean isJar(File f) {
        return FileUtils.hasExtension(f, ".jar");
    }

    public static boolean isZip(File f) {
        return FileUtils.hasExtensionIgnoreCase(f, ".zip");
    }

    public static boolean whack(File parent) {
        return FileUtils.whack(parent, null);
    }

    public static boolean whack(File parent, Collection<File> undeletedFiles) {
        try {
            return FileUtils.whackResolvedDirectory(parent.getCanonicalFile(), undeletedFiles);
        }
        catch (IOException ioe) {
            _utillogger.log(Level.SEVERE, "iplanet_util.io_exception", ioe);
            return false;
        }
    }

    private static boolean whackResolvedDirectory(File parent, Collection<File> undeletedFiles) {
        if (FileUtils.safeIsRealDirectory(parent)) {
            File[] kids = FileUtils.listFiles(parent);
            for (int i = 0; i < kids.length; ++i) {
                File f = kids[i];
                if (f.isDirectory()) {
                    FileUtils.whackResolvedDirectory(f, undeletedFiles);
                    continue;
                }
                if (FileUtils.deleteFile(f) || undeletedFiles == null) continue;
                undeletedFiles.add(f);
            }
        }
        return FileUtils.deleteFile(parent);
    }

    public static boolean deleteFile(File f) {
        if (f.delete()) {
            return true;
        }
        boolean log = _utillogger.isLoggable(FILE_OPERATION_LOG_LEVEL);
        String filePath = f.getAbsolutePath();
        if (!f.exists()) {
            if (log) {
                _utillogger.log(Level.FINE, "enterprise_util.delete_failed_absent", filePath);
            }
            return true;
        }
        if (log) {
            _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.error_deleting_file", filePath);
        }
        return false;
    }

    public static FileOutputStream openFileOutputStream(File out) throws IOException {
        FileOutputStreamWork work = new FileOutputStreamWork(out);
        int retries = FileUtils.doWithRetry(work);
        if (work.workComplete()) {
            return work.getStream();
        }
        IOException ioe = new IOException();
        ioe.initCause(work.getLastError());
        throw ioe;
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        return FileUtils.getAllFilesUnder(directory, filenameFilter, true);
    }

    public static Set getAllFilesUnder(File directory, FilenameFilter filenameFilter, boolean relativize) throws IOException {
        TreeSet allFiles = new TreeSet();
        File relativizingDir = relativize ? directory : null;
        FileUtils.recursiveGetFilesUnder(relativizingDir, directory, filenameFilter, allFiles, false);
        return allFiles;
    }

    public static Set getAllFilesAndDirectoriesUnder(File directory) throws IOException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Problem with: " + directory + ". You must supply a directory that exists");
        }
        TreeSet allFiles = new TreeSet();
        FileUtils.recursiveGetFilesUnder(directory, directory, null, allFiles, true);
        return allFiles;
    }

    private static void recursiveGetFilesUnder(File relativizingRoot, File directory, FilenameFilter filenameFilter, Set set, boolean returnDirectories) {
        File[] files = FileUtils.listFiles(directory, filenameFilter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileUtils.recursiveGetFilesUnder(relativizingRoot, files[i], filenameFilter, set, returnDirectories);
                if (!returnDirectories) continue;
                if (relativizingRoot != null) {
                    set.add(FileUtils.relativize(relativizingRoot, files[i]));
                    continue;
                }
                set.add(files[i]);
                continue;
            }
            if (relativizingRoot != null) {
                set.add(FileUtils.relativize(relativizingRoot, files[i]));
                continue;
            }
            set.add(files[i]);
        }
    }

    public static File relativize(File parent, File child) {
        String baseDir = parent.getAbsolutePath();
        String baseDirAndChild = child.getAbsolutePath();
        String relative = baseDirAndChild.substring(baseDir.length(), baseDirAndChild.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return new File(relative);
    }

    private static int doWithRetry(RetriableWork work) {
        int retries = 0;
        work.run();
        if (!work.workComplete() && OS.isWindows()) {
            _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.perform_gc");
            while (!work.workComplete() && retries++ < FILE_OPERATION_MAX_RETRIES) {
                try {
                    Thread.currentThread();
                    Thread.sleep(FILE_OPERATION_SLEEP_DELAY_MS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.gc();
                work.run();
            }
        }
        return retries;
    }

    public static String formatFileCollection(Collection<File> files) {
        StringBuilder sb = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        String prefix = "";
        for (File f : files) {
            sb.append(prefix).append(f.getAbsolutePath());
            prefix = lineSep;
        }
        return sb.toString();
    }

    public static File getDirectory(File f) {
        String filename = f.getAbsolutePath();
        return new File(new File(filename).getParent());
    }

    public static File createTempFile(File directory) {
        File f = null;
        try {
            f = File.createTempFile(TMPFILENAME, "jar", directory);
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, "iplanet_util.io_exception", ioe);
        }
        f.deleteOnExit();
        return f;
    }

    public static File[] listAllFiles(File dirName, String ext) {
        File[] target = null;
        List list = FileUtils.searchDir(dirName, ext);
        if (list != null && list.size() > 0) {
            target = new File[list.size()];
            target = list.toArray(target);
        }
        return target;
    }

    public static List searchDir(File dirName, String ext) {
        ArrayList<File> targetList = null;
        if (dirName.isDirectory()) {
            targetList = new ArrayList<File>();
            File[] list = FileUtils.listFiles(dirName);
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    targetList.addAll(FileUtils.searchDir(list[i], ext));
                    continue;
                }
                String name = list[i].toString();
                if (!FileUtils.hasExtension(name, ext)) continue;
                targetList.add(list[i]);
            }
        }
        return targetList;
    }

    public static void copy(String from, String to) throws IOException {
        if (from == null || to == null) {
            throw new IllegalArgumentException("null or empty filename argument");
        }
        File fin = new File(from);
        File fout = new File(to);
        FileUtils.copy(fin, fout);
    }

    public static void copy(File fin, File fout) throws IOException {
        if (FileUtils.safeIsDirectory(fin)) {
            FileUtils.copyTree(fin, fout);
            return;
        }
        if (!fin.exists()) {
            throw new IllegalArgumentException("File source doesn't exist");
        }
        if (!FileUtils.safeIsDirectory(fout.getParentFile())) {
            fout.getParentFile().mkdirs();
        }
        FileUtils.copyFile(fin, fout);
    }

    public static void copyTree(File din, File dout) throws IOException {
        if (!FileUtils.safeIsDirectory(din)) {
            throw new IllegalArgumentException("Source isn't a directory");
        }
        dout.mkdirs();
        if (!FileUtils.safeIsDirectory(dout)) {
            throw new IllegalArgumentException("Can't create destination directory");
        }
        FileListerRelative flr = new FileListerRelative(din);
        String[] files = flr.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File fin = new File(din, files[i]);
            File fout = new File(dout, files[i]);
            FileUtils.copy(fin, fout);
        }
    }

    public static String makeForwardSlashes(String inputStr) {
        if (inputStr == null) {
            throw new IllegalArgumentException("null String FileUtils.makeForwardSlashes");
        }
        return inputStr.replace('\\', '/');
    }

    public static String getIllegalFilenameCharacters() {
        return ILLEGAL_FILENAME_STRING;
    }

    static boolean isValidString(String s) {
        return s != null && s.length() != 0;
    }

    public static void copyFile(File fin, File fout) throws IOException {
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(fin));
        FileOutputStream fos = FileUtils.openFileOutputStream(fout);
        FileUtils.copy((InputStream)inStream, fos, fin.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, FileOutputStream out, long size) throws IOException {
        try {
            FileUtils.copyWithoutClose(in, out, size);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copyWithoutClose(InputStream in, FileOutputStream out, long size) throws IOException {
        ReadableByteChannel inChannel = Channels.newChannel(in);
        FileChannel outChannel = out.getChannel();
        outChannel.transferFrom(inChannel, 0L, size);
    }

    public static void copy(InputStream in, OutputStream os, long size) throws IOException {
        if (os instanceof FileOutputStream) {
            FileUtils.copy(in, (FileOutputStream)os, size);
        } else {
            ReadableByteChannel inChannel = Channels.newChannel(in);
            WritableByteChannel outChannel = Channels.newChannel(os);
            if (size == 0L) {
                int read;
                ByteBuffer byteBuffer = ByteBuffer.allocate(10240);
                do {
                    if ((read = inChannel.read(byteBuffer)) <= 0) continue;
                    byteBuffer.limit(byteBuffer.position());
                    byteBuffer.rewind();
                    outChannel.write(byteBuffer);
                    byteBuffer.clear();
                } while (read != -1);
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocate(Long.valueOf(size).intValue());
                inChannel.read(byteBuffer);
                byteBuffer.rewind();
                outChannel.write(byteBuffer);
            }
        }
    }

    public static boolean renameFile(File fromFile, File toFile) {
        boolean log = _utillogger.isLoggable(FILE_OPERATION_LOG_LEVEL) || _utillogger.isLoggable(Level.FINE);
        RenameFileWork renameWork = new RenameFileWork(fromFile, toFile);
        int retries = FileUtils.doWithRetry(renameWork);
        boolean result = renameWork.workComplete();
        String fromFilePath = null;
        String toFilePath = null;
        if (log || !result) {
            fromFilePath = fromFile.getAbsolutePath();
            toFilePath = toFile.getAbsolutePath();
        }
        if (result) {
            if (log) {
                if (retries == 0) {
                    if (_utillogger.isLoggable(Level.FINE)) {
                        _utillogger.log(Level.FINE, "enterprise_util.rename_initial_success", new Object[]{fromFilePath, toFilePath});
                    }
                } else {
                    _utillogger.log(FILE_OPERATION_LOG_LEVEL, "enterprise_util.retry_rename_success", new Object[]{fromFilePath, toFilePath, retries});
                }
            }
        } else {
            _utillogger.log(Level.WARNING, "enterprise_util.retry_rename_failure", new Object[]{fromFilePath, toFilePath, retries});
        }
        return result;
    }

    public static void appendText(String fileName, String line) throws RuntimeException {
        RandomAccessFile file = null;
        try {
            String MODE = "rw";
            file = new RandomAccessFile(fileName, "rw");
            file.seek(file.getFilePointer() + file.length());
            file.writeBytes(line);
        }
        catch (Exception e) {
            throw new RuntimeException("FileUtils.appendText()", e);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void appendText(String fileName, StringBuffer buffer) throws IOException, FileNotFoundException {
        FileUtils.appendText(fileName, buffer.toString());
    }

    public static String readSmallFile(String fileName) throws IOException, FileNotFoundException {
        return FileUtils.readSmallFile(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSmallFile(File file) throws IOException {
        BufferedReader bf = new BufferedReader(new FileReader(file));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = bf.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
        }
        finally {
            try {
                bf.close();
            }
            catch (Exception e) {}
        }
        return sb.toString();
    }

    private static class FileOutputStreamWork
    implements RetriableWork {
        private FileOutputStream fos = null;
        private Throwable lastError = null;
        private File out;

        public FileOutputStreamWork(File out) {
            this.out = out;
        }

        public boolean workComplete() {
            return this.fos != null;
        }

        public void run() {
            try {
                this.fos = new FileOutputStream(this.out);
                this.lastError = null;
            }
            catch (IOException ioe) {
                this.lastError = ioe;
            }
        }

        public FileOutputStream getStream() {
            return this.fos;
        }

        public Throwable getLastError() {
            return this.lastError;
        }
    }

    private static class RenameFileWork
    implements RetriableWork {
        private File originalFile;
        private File newFile;
        private boolean renameResult = false;

        public RenameFileWork(File originalFile, File newFile) {
            this.originalFile = originalFile;
            this.newFile = newFile;
        }

        public boolean workComplete() {
            return this.renameResult;
        }

        public void run() {
            this.renameResult = this.originalFile.renameTo(this.newFile);
        }
    }

    private static interface RetriableWork
    extends Runnable {
        public boolean workComplete();
    }
}

