/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Pipeline;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.glassfish.api.embedded.web.ConfigException;
import org.glassfish.api.embedded.web.Context;
import org.glassfish.api.embedded.web.VirtualServer;
import org.glassfish.api.embedded.web.WebListener;
import org.glassfish.api.embedded.web.config.VirtualServerConfig;
import org.glassfish.web.valve.GlassFishValve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualServerImpl
extends StandardHost
implements VirtualServer {
    private static Logger log = Logger.getLogger(VirtualServer.class.getName());
    private AccessLogValve accessLogValve = new AccessLogValve();
    private boolean allowLinking = false;
    private VirtualServerConfig config;
    private String defaultContextXmlLocation;
    private String defaultWebXmlLocation;

    public VirtualServerImpl() {
        this.accessLogValve.setContainer(this);
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public File getDocRoot() {
        return new File(this.getAppBase());
    }

    @Override
    public Collection<WebListener> getWebListeners() {
        return null;
    }

    @Override
    public void addContext(Context context, String contextRoot) throws ConfigException, org.glassfish.api.embedded.LifecycleException {
        if (this.findContext(contextRoot) != null) {
            throw new ConfigException("Context with contextRoot " + contextRoot + " is already registered");
        }
        context.setPath(contextRoot);
        this.addChild((Container)((Object)context));
        if (log.isLoggable(Level.INFO)) {
            log.info("Added context " + context.getPath());
        }
    }

    @Override
    public void removeContext(Context context) {
        this.removeChild((Container)((Object)context));
    }

    @Override
    public Context findContext(String contextRoot) {
        Context context = null;
        for (Context c : this.getContexts()) {
            if (!c.getPath().equals(contextRoot)) continue;
            context = c;
        }
        return context;
    }

    @Override
    public Collection<Context> getContexts() {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (Container child : this.findChildren()) {
            if (!(child instanceof Context)) continue;
            contexts.add((Context)((Object)child));
        }
        return contexts;
    }

    @Override
    public VirtualServerConfig getConfig() {
        return this.config;
    }

    @Override
    public void enable() throws org.glassfish.api.embedded.LifecycleException {
        try {
            this.start();
        }
        catch (LifecycleException e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    @Override
    public void disable() throws org.glassfish.api.embedded.LifecycleException {
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    @Override
    public void setConfig(VirtualServerConfig config) throws ConfigException {
        this.config = config;
        this.configureSingleSignOn(config.isSsoEnabled());
        if (config.isAccessLoggingEnabled()) {
            this.enableAccessLogging();
        } else {
            this.disableAccessLogging();
        }
        this.setDefaultWebXmlLocation(config.getDefaultWebXml());
        this.setDefaultContextXmlLocation(config.getContextXmlDefault());
        this.setAllowLinking(config.isAllowLinking());
        this.configureRemoteAddressFilterValve(config.getAllowRemoteAddress(), config.getDenyRemoteAddress());
        this.configureRemoteHostFilterValve(config.getAllowRemoteHost(), config.getAllowRemoteHost());
        this.configureAliases(config.getHostNames());
    }

    protected void configureAliases(String ... hosts) {
        for (String host : hosts) {
            if (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(host);
        }
    }

    protected void configureRemoteAddressFilterValve(String allow, String deny) {
        RemoteAddrValve remoteAddrValve = null;
        if (allow != null || deny != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null) {
            remoteAddrValve.setAllow(allow);
        }
        if (deny != null) {
            remoteAddrValve.setDeny(deny);
        }
        if (remoteAddrValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve(remoteAddrValve);
        }
    }

    protected void configureRemoteHostFilterValve(String allow, String deny) {
        RemoteHostValve remoteHostValve = null;
        if (allow != null || deny != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null) {
            remoteHostValve.setAllow(allow);
        }
        if (deny != null) {
            remoteHostValve.setDeny(deny);
        }
        if (remoteHostValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve(remoteHostValve);
        }
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public void configureSingleSignOn(boolean ssoEnabled) {
        if (!ssoEnabled) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("sso is disabled");
            }
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                break;
            }
        } else {
            try {
                SingleSignOn sso = new SingleSignOn();
                GlassFishValve[] valves = this.getValves();
                for (int i = 0; valves != null && i < valves.length; ++i) {
                    if (!(valves[i] instanceof SingleSignOn)) continue;
                    this.removeValve(valves[i]);
                    break;
                }
                this.addValve(sso);
            }
            catch (Exception e) {
                log.severe(e.getMessage());
            }
        }
    }

    private boolean isAccessLogValveActivated() {
        GlassFishValve[] valves;
        Pipeline p = this.getPipeline();
        if (p != null && (valves = p.getValves()) != null) {
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof AccessLogValve)) continue;
                return true;
            }
        }
        return false;
    }

    public void enableAccessLogging() {
        if (!this.isAccessLogValveActivated()) {
            this.addValve(this.accessLogValve);
        } else {
            try {
                if (this.accessLogValve.isStarted()) {
                    this.accessLogValve.stop();
                }
                this.accessLogValve.start();
            }
            catch (LifecycleException le) {
                log.severe(le.getMessage());
            }
        }
    }

    public void disableAccessLogging() {
        this.removeValve(this.accessLogValve);
    }

    public String getDefaultContextXmlLocation() {
        return this.defaultContextXmlLocation;
    }

    public void setDefaultContextXmlLocation(String defaultContextXmlLocation) {
        this.defaultContextXmlLocation = defaultContextXmlLocation;
    }

    public String getDefaultWebXmlLocation() {
        return this.defaultWebXmlLocation;
    }

    public void setDefaultWebXmlLocation(String defaultWebXmlLocation) {
        this.defaultWebXmlLocation = defaultWebXmlLocation;
    }
}

