/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MakeConnectionElement;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MessagePendingElement;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.UnsupportedSelectionType;
import com.sun.xml.ws.rx.util.JaxbContextRepository;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum McVersion {
    WSMC200702("http://docs.oasis-open.org/ws-rx/wsmc/200702", "http://docs.oasis-open.org/ws-rx/wsmc/200702", MakeConnectionElement.class, MessagePendingElement.class, UnsupportedSelectionType.class);

    public final String namespaceUri;
    public final String policyNamespaceUri;
    public final String wsmcAction;
    public final String wsmcFaultAction;
    public final QName messagePendingHeaderName;
    public final QName unsupportedSelectionFaultCode;
    public final QName missingSelectionFaultCode;
    private final JaxbContextRepository jaxbContextRepository;

    private McVersion(String nsUri, String policyNsUri, Class<?> ... protocolClasses) {
        this.namespaceUri = nsUri;
        this.policyNamespaceUri = policyNsUri;
        this.wsmcAction = nsUri + "/MakeConnection";
        this.wsmcFaultAction = nsUri + "/fault";
        this.messagePendingHeaderName = new QName(this.namespaceUri, "MessagePending");
        this.unsupportedSelectionFaultCode = new QName(this.namespaceUri, "UnsupportedSelection");
        this.missingSelectionFaultCode = new QName(this.namespaceUri, "MissingSelection");
        this.jaxbContextRepository = new JaxbContextRepository(protocolClasses);
    }

    public String getClientId(String eprAddress) {
        String mcAnnonymousAddressPrefix = this.namespaceUri + "/anonymous?id=";
        if (eprAddress.startsWith(mcAnnonymousAddressPrefix)) {
            return eprAddress.substring(mcAnnonymousAddressPrefix.length());
        }
        return null;
    }

    public boolean isMcFault(String wsaAction) {
        return this.wsmcFaultAction.equals(wsaAction);
    }

    public String getWsmcAnonymousAddress(String uuid) {
        return this.namespaceUri + "/anonymous?id=" + uuid;
    }

    public Unmarshaller getUnmarshaller(AddressingVersion av) throws RxRuntimeException {
        return this.jaxbContextRepository.getUnmarshaller(av);
    }

    public JAXBRIContext getJaxbContext(AddressingVersion av) {
        return this.jaxbContextRepository.getJaxbContext(av);
    }
}

