/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.sequence.AbstractSequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InboundSequence
extends AbstractSequence {
    private static final Logger LOGGER = Logger.getLogger(InboundSequence.class);
    public static final long INITIAL_LAST_MESSAGE_ID = 0L;

    public InboundSequence(SequenceData data, DeliveryQueueBuilder deliveryQueueBuilder, TimeSynchronizer timeSynchronizer) {
        super(data, deliveryQueueBuilder, timeSynchronizer);
    }

    @Override
    public void registerMessage(ApplicationMessage message, boolean storeMessageFlag) throws DuplicateMessageRegistrationException, IllegalStateException {
        this.getState().verifyAcceptingMessageRegistration(this.getId(), AbstractSoapFaultException.Code.Receiver);
        if (!this.getId().equals(message.getSequenceId())) {
            throw (IllegalArgumentException)LOGGER.logSevereException((Throwable)new IllegalArgumentException(LocalizationMessages.WSRM_1149_DIFFERENT_MSG_SEQUENCE_ID(message.getSequenceId(), this.getId())));
        }
        this.data.registerUnackedMessageNumber(message.getMessageNumber(), true);
        if (storeMessageFlag) {
            this.data.attachMessageToUnackedMessageNumber(message);
        }
    }

    @Override
    public void acknowledgeMessageNumbers(List<Sequence.AckRange> ranges) {
        throw new UnsupportedOperationException(String.format("This operation is not supported on %s class", this.getClass().getName()));
    }

    @Override
    public void acknowledgeMessageNumber(long messageId) throws IllegalStateException {
        this.getState().verifyAcceptingAcknowledgement(this.getId(), AbstractSoapFaultException.Code.Receiver);
        this.data.markAsAcknowledged(messageId);
        this.getDeliveryQueue().onSequenceAcknowledgement();
    }
}

