/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.config.management;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class EndpointUtil {
    private static final Logger LOGGER = Logger.getLogger(EndpointUtil.class);
    private static final QName SERVICE_ASSERTION_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "ManagedService");

    public static ManagedServiceAssertion getAssertion(WSEndpoint endpoint) throws WebServiceException {
        LOGGER.entering(new Object[]{endpoint});
        try {
            AssertionSet assertionSet;
            Iterator<PolicyAssertion> assertions;
            Iterator<AssertionSet> assertionSets;
            PolicyMapKey key;
            Policy policy;
            PolicyAssertion assertion = null;
            PolicyMap policyMap = endpoint.getPolicyMap();
            if (policyMap != null && (policy = policyMap.getEndpointEffectivePolicy(key = PolicyMap.createWsdlEndpointScopeKey(endpoint.getServiceName(), endpoint.getPortName()))) != null && (assertionSets = policy.iterator()).hasNext() && (assertions = (assertionSet = assertionSets.next()).get(SERVICE_ASSERTION_QNAME).iterator()).hasNext()) {
                assertion = assertions.next();
            }
            LOGGER.exiting(assertion);
            return assertion == null ? null : assertion.getImplementation(ManagedServiceAssertion.class);
        }
        catch (PolicyException ex) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException(ManagementMessages.WSM_5003_FAILED_ASSERTION(), (Throwable)ex));
        }
    }
}

