/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11.soap;

import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP11Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP12Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAPBody;
import org.jvnet.wom.impl.extension.Messages;
import org.jvnet.wom.impl.extension.wsdl11.AbstractWSDLExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPHeaderFaultImpl;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPHeaderFaultExtensionHandler
extends AbstractWSDLExtensionHandler {
    private final QName[] names = new QName[]{SOAP11Constants.SOAPHEADERFAULT_NAME, SOAP12Constants.SOAPHEADERFAULT_NAME};
    private SOAPHeaderFaultImpl headerFault;
    private final ContentHandler contentHandler = new SOAPHeaderFaultCH();

    public SOAPHeaderFaultExtensionHandler(ErrorHandler errorHandler, EntityResolver entityResolver) {
        super(errorHandler, entityResolver);
    }

    @Override
    public ContentHandler getContentHandlerFor(String nsUri, String localName) {
        if (this.canHandle(nsUri, localName)) {
            return this.contentHandler;
        }
        return null;
    }

    @Override
    public Collection<WSDLExtension> getExtensions() {
        return Collections.singleton(this.headerFault);
    }

    @Override
    protected QName[] getExtensionNames() {
        return this.names;
    }

    private class SOAPHeaderFaultCH
    extends AbstractWSDLExtensionHandler.WSDLExtensibilityContentHandler {
        private SOAPHeaderFaultCH() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String message;
            if (!SOAPHeaderFaultExtensionHandler.this.canHandle(uri, localName)) {
                return;
            }
            String encodingStyleAtt = atts.getValue("encodingStyle");
            String[] encodingStyle = null;
            if (encodingStyleAtt != null) {
                encodingStyle = encodingStyleAtt.split("\\s");
            }
            String namespace = atts.getValue("namespace");
            String useatt = XmlUtil.fixNull(atts.getValue("use")).trim();
            SOAPBody.Use use = SOAPBody.Use.literal;
            if (useatt.equals("encoded")) {
                use = SOAPBody.Use.encoded;
            } else if (!useatt.equals("literal")) {
                SOAPHeaderFaultExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("invalid.attr", "use", useatt, "literal or encoded"), this.locator));
            }
            String part = atts.getValue("part");
            if (part == null) {
                SOAPHeaderFaultExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("missing.attr", "part", "soap:header"), this.locator));
            }
            if ((message = atts.getValue("message")) == null) {
                SOAPHeaderFaultExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("missing.attr", "message", "soap:header"), this.locator));
            }
            String localPart = XmlUtil.getLocalPart(message);
            String prefix = XmlUtil.getPrefix(message);
            SOAPHeaderFaultExtensionHandler.this.headerFault = new SOAPHeaderFaultImpl(new QName(uri, localName));
            SOAPHeaderFaultExtensionHandler.this.headerFault.setMessage(new QName(this.resolveNamespacePrefix(prefix), localPart));
            SOAPHeaderFaultExtensionHandler.this.headerFault.setPart(part);
            SOAPHeaderFaultExtensionHandler.this.headerFault.setUse(use);
            SOAPHeaderFaultExtensionHandler.this.headerFault.setEncodingStyle(encodingStyle);
            SOAPHeaderFaultExtensionHandler.this.headerFault.setNamespace(namespace);
        }
    }
}

