/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.util;

import com.sun.enterprise.naming.spi.NamingObjectFactory;
import com.sun.enterprise.naming.spi.NamingUtils;
import com.sun.enterprise.naming.util.CloningNamingObjectFactory;
import com.sun.enterprise.naming.util.DelegatingNamingObjectFactory;
import com.sun.enterprise.naming.util.JndiNamingObjectFactory;
import com.sun.enterprise.naming.util.LogFacade;
import com.sun.enterprise.naming.util.MailLogOutputStream;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactoryFactory;
import com.sun.enterprise.naming.util.SimpleNamingObjectFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class NamingUtilsImpl
implements NamingUtils {
    static Logger _logger = LogFacade.getLogger();

    public NamingObjectFactory createSimpleNamingObjectFactory(String name, Object value) {
        return new SimpleNamingObjectFactory(name, value);
    }

    public NamingObjectFactory createLazyNamingObjectFactory(String name, String jndiName, boolean cacheResult) {
        return new JndiNamingObjectFactory(name, jndiName, cacheResult);
    }

    public NamingObjectFactory createCloningNamingObjectFactory(String name, Object value) {
        return new CloningNamingObjectFactory(name, value);
    }

    public NamingObjectFactory createCloningNamingObjectFactory(String name, NamingObjectFactory delegate) {
        return new CloningNamingObjectFactory(name, delegate);
    }

    public NamingObjectFactory createDelegatingNamingObjectFactory(String name, NamingObjectFactory delegate, boolean cacheResult) {
        return new DelegatingNamingObjectFactory(name, delegate, cacheResult);
    }

    public Object makeCopyOfObject(Object obj) {
        if (obj instanceof Serializable) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "** makeCopyOfObject:: " + obj);
            }
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = ObjectInputOutputStreamFactoryFactory.getFactory().createObjectOutputStream(bos);
                oos.writeObject(obj);
                oos.flush();
                byte[] data = bos.toByteArray();
                oos.close();
                bos.close();
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                final ObjectInputStream ois = ObjectInputOutputStreamFactoryFactory.getFactory().createObjectInputStream(bis);
                obj = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, ClassNotFoundException {
                        return ois.readObject();
                    }
                });
                return obj;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "enterprise_naming.excep_in_copymutableobj", ex);
                RuntimeException re = new RuntimeException("Cant copy Serializable object:");
                re.initCause(ex);
                throw re;
            }
        }
        return obj;
    }

    public OutputStream getMailLogOutputStream() {
        return new MailLogOutputStream();
    }
}

