/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.spi.monitoring.glassfish;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@ManagedObject
public class ApplicationStatsProvider {
    private final Map<String, Long> rootResourceClassCounter;
    private final Map<String, Long> resourceClassCounter;
    private long rootResourceClassHitCountStartTime = new Date().getTime();
    private long rootResourceClassHitCountLastSampleTime;
    private long resourceClassHitCountStartTime = new Date().getTime();
    private long resourceClassHitCountLastSampleTime;

    @ManagedAttribute(id="rootresourceclasshitcount-description")
    public String getRootResourceClassHitCountDesc() {
        return "Root resource class hit count";
    }

    @ManagedAttribute(id="rootresourceclasshitcount-starttime")
    public long getRootResourceClassHitCountStartTime() {
        return this.rootResourceClassHitCountStartTime;
    }

    @ManagedAttribute(id="rootresourceclasshitcount-lastsampletime")
    public long getRootResourceClassHitCountLastSampleTime() {
        return this.rootResourceClassHitCountLastSampleTime;
    }

    @ManagedAttribute(id="rootresourceclasshitcount")
    public Map<String, Long> getRootResourceClassCounter() {
        return this.rootResourceClassCounter;
    }

    @ManagedAttribute(id="resourceclasshitcount-description")
    public String getResourceClassHitCountDesc() {
        return "Resource class hit count";
    }

    @ManagedAttribute(id="resourceclasshitcount-starttime")
    public long getResourceClassHitCountStartTime() {
        return this.resourceClassHitCountStartTime;
    }

    @ManagedAttribute(id="resourceclasshitcount-lastsampletime")
    public long getResourceClassHitCountLastSampleTime() {
        return this.resourceClassHitCountLastSampleTime;
    }

    @ManagedAttribute(id="resourceclasshitcount")
    public Map<String, Long> getResourceClassCounter() {
        return this.resourceClassCounter;
    }

    public ApplicationStatsProvider() {
        this.rootResourceClassCounter = new HashMap<String, Long>();
        this.resourceClassCounter = new HashMap<String, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rootResourceClassHit(String resourceClassName) {
        Map<String, Long> map = this.rootResourceClassCounter;
        synchronized (map) {
            if (this.rootResourceClassCounter.containsKey(resourceClassName)) {
                this.rootResourceClassCounter.put(resourceClassName, this.rootResourceClassCounter.get(resourceClassName) + 1L);
            } else {
                this.rootResourceClassCounter.put(resourceClassName, new Long(1L));
            }
        }
        this.rootResourceClassHitCountLastSampleTime = new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceClassHit(String resourceClassName) {
        Map<String, Long> map = this.resourceClassCounter;
        synchronized (map) {
            if (this.resourceClassCounter.containsKey(resourceClassName)) {
                this.resourceClassCounter.put(resourceClassName, this.resourceClassCounter.get(resourceClassName) + 1L);
            } else {
                this.resourceClassCounter.put(resourceClassName, new Long(1L));
            }
        }
        this.resourceClassHitCountLastSampleTime = new Date().getTime();
    }
}

