/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import com.sun.messaging.bridge.service.jms.JMSBridge;
import java.util.Properties;

public class DestinationElement {
    private Properties _attrs = null;
    private Properties _props = null;
    private String _type = null;

    public void setAttributes(Properties properties) throws IllegalArgumentException {
        if (properties != null) {
            String string = properties.getProperty("ref-name");
            if (string.equals("imq.bridge.jms.dmq") || string.equals("built-in-dmq") || string.equals("AS_SOURCE")) {
                throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "ref-name", string));
            }
            if (properties.getProperty("lookup-name") == null) {
                String string2 = properties.getProperty("name");
                if (string2 == null) {
                    Object[] objectArray = new String[]{"lookup-name", "name", "destination"};
                    throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4030", objectArray));
                }
                if (string2.equals("imq.bridge.jms.dmq")) {
                    throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "name", string2));
                }
            }
        }
        this._attrs = properties;
    }

    public void setProperties(Properties properties) {
        this._props = properties;
    }

    public Properties getAttributes() {
        return this._attrs;
    }

    public Properties getProperties() {
        return this._props;
    }

    public String getName() throws Exception {
        String string = this._attrs.getProperty("name");
        String string2 = this._attrs.getProperty("lookup-name");
        if (string2 != null) {
            throw new UnsupportedOperationException("Called when lookup-name is specified");
        }
        if (string == null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4031", "destination", "name"));
        }
        return string;
    }

    public String getLookupName() {
        return this._attrs.getProperty("lookup-name");
    }

    public String getRefName() {
        return this._attrs.getProperty("ref-name");
    }

    public boolean isQueue() throws Exception {
        if (this._type == null) {
            this._type = this._attrs.getProperty("type");
        }
        if (this.getLookupName() != null) {
            throw new UnsupportedOperationException("Called when lookup-name is specified");
        }
        if (this._type == null) {
            throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4031", "destination", "type"));
        }
        this._type = this._type.trim().toLowerCase();
        return !this._type.equals("topic");
    }

    public String toString() {
        return "destination[" + this.getRefName() + "]";
    }
}

