/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.TimeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.flashlight.statistics.TimeStats;
import org.glassfish.flashlight.statistics.factory.TimeStatsFactory;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.jvnet.hk2.component.PostConstruct;

@AMXMetadata(type="request-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container HTTP Service Statistics")
public class HttpServiceStatsProvider
implements PostConstruct {
    private CountStatisticImpl errorCount = new CountStatisticImpl("ErrorCount", "count", "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400");
    private CountStatisticImpl count200 = new CountStatisticImpl("Count200", "count", "Number of responses with a status code equal to 200");
    private CountStatisticImpl count2xx = new CountStatisticImpl("Count2xx", "count", "Number of responses with a status code in the 2xx range");
    private CountStatisticImpl count302 = new CountStatisticImpl("Count302", "count", "Number of responses with a status code equal to 302");
    private CountStatisticImpl count304 = new CountStatisticImpl("Count304", "count", "Number of responses with a status code equal to 304");
    private CountStatisticImpl count3xx = new CountStatisticImpl("Count3xx", "count", "Number of responses with a status code in the 3xx range");
    private CountStatisticImpl count400 = new CountStatisticImpl("Count400", "count", "Number of responses with a status code equal to 400");
    private CountStatisticImpl count401 = new CountStatisticImpl("Count401", "count", "Number of responses with a status code equal to 401");
    private CountStatisticImpl count403 = new CountStatisticImpl("Count403", "count", "Number of responses with a status code equal to 403");
    private CountStatisticImpl count404 = new CountStatisticImpl("Count404", "count", "Number of responses with a status code equal to 404");
    private CountStatisticImpl count4xx = new CountStatisticImpl("Count4xx", "count", "Number of responses with a status code in the 4xx range");
    private CountStatisticImpl count503 = new CountStatisticImpl("Count503", "count", "Number of responses with a status code equal to 503");
    private CountStatisticImpl count5xx = new CountStatisticImpl("Count5xx", "count", "Number of responses with a status code in the 5xx range");
    private CountStatisticImpl countOther = new CountStatisticImpl("CountOther", "count", "Number of responses with a status code outside the 2xx, 3xx, 4xx, and 5xx range");
    private TimeStats requestProcessTime = TimeStatsFactory.createTimeStatsMilli();
    private Logger logger = Logger.getLogger(HttpServiceStatsProvider.class.getName());
    private String virtualServerName = null;

    public HttpServiceStatsProvider(String vsName) {
        this.virtualServerName = vsName;
    }

    public void postConstruct() {
    }

    @ManagedAttribute(id="maxtime")
    @Description(value="Provides the longest response time for a response - not a cumulative value, but the largest response time from among response times.")
    public TimeStatistic getMaximumTime() {
        TimeStatisticImpl maxTime = new TimeStatisticImpl(this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMinimumTime(), this.requestProcessTime.getTotalTime(), "MaxTime", "milliseconds", "Provides the longest response time for a response - not a cumulative value, but the largest response time from among response times.", this.requestProcessTime.getStartTime(), this.requestProcessTime.getLastSampleTime());
        return maxTime;
    }

    @ManagedAttribute(id="requestcount")
    @Description(value="Provides cumulative number of requests processed so far")
    public CountStatistic getCount() {
        CountStatisticImpl requestCount = new CountStatisticImpl("RequestCount", "count", "Provides cumulative number of requests processed so far.");
        requestCount.setCount(this.requestProcessTime.getCount());
        return requestCount;
    }

    @ManagedAttribute(id="processingtime")
    @Description(value="Provides cumulative value of the times taken to process each request The processing time is the average request processing times over the request count.")
    public TimeStatistic getTime() {
        TimeStatisticImpl processingTime = new TimeStatisticImpl((long)this.requestProcessTime.getTime(), this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMinimumTime(), this.requestProcessTime.getTotalTime(), "ProcessingTime", "milliseconds", "Provides cumulative value of the times taken to process each request The processing time is the average request processing times over the request count.", this.requestProcessTime.getStartTime(), this.requestProcessTime.getLastSampleTime());
        return processingTime;
    }

    @ManagedAttribute(id="errorcount")
    @Description(value="")
    public CountStatistic getErrorCount() {
        return this.errorCount.getStatistic();
    }

    @ManagedAttribute(id="count200")
    @Description(value="")
    public CountStatistic getCount200() {
        return this.count200.getStatistic();
    }

    @ManagedAttribute(id="count2xx")
    @Description(value="")
    public CountStatistic getCount2xx() {
        return this.count2xx.getStatistic();
    }

    @ManagedAttribute(id="count302")
    @Description(value="")
    public CountStatistic getCount302() {
        return this.count302.getStatistic();
    }

    @ManagedAttribute(id="count304")
    @Description(value="")
    public CountStatistic getCount304() {
        return this.count304.getStatistic();
    }

    @ManagedAttribute(id="count3xx")
    @Description(value="")
    public CountStatistic getCount3xxt() {
        return this.count3xx.getStatistic();
    }

    @ManagedAttribute(id="count400")
    @Description(value="")
    public CountStatistic getCount400() {
        return this.count400.getStatistic();
    }

    @ManagedAttribute(id="count401")
    @Description(value="")
    public CountStatistic getCount401() {
        return this.count401.getStatistic();
    }

    @ManagedAttribute(id="count403")
    @Description(value="")
    public CountStatistic getCount403() {
        return this.count403.getStatistic();
    }

    @ManagedAttribute(id="count404")
    @Description(value="")
    public CountStatistic getCount404() {
        return this.count404.getStatistic();
    }

    @ManagedAttribute(id="count4xx")
    @Description(value="")
    public CountStatistic getCount4xx() {
        return this.count4xx.getStatistic();
    }

    @ManagedAttribute(id="count503")
    @Description(value="")
    public CountStatistic getCount503() {
        return this.count503.getStatistic();
    }

    @ManagedAttribute(id="count5xx")
    @Description(value="")
    public CountStatistic getCount5xx() {
        return this.count5xx.getStatistic();
    }

    @ManagedAttribute(id="countother")
    @Description(value="")
    public CountStatistic getCountOther() {
        return this.countOther.getStatistic();
    }

    @ProbeListener(value="glassfish:web:http-service:requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            this.requestProcessTime.entry();
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("[TM]requestStartEvent received - virtual-server = " + serverName + " : port = " + serverPort);
            }
        }
    }

    @ProbeListener(value="glassfish:web:http-service:requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath, @ProbeParam(value="statusCode") int statusCode) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            this.requestProcessTime.exit();
            this.incrementStatsCounter(statusCode);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("[TM]requestEndEvent received - virtual-server = " + serverName + ": application = " + contextPath + " : servlet = " + servletPath + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
            }
        }
    }

    public long getProcessTime() {
        return this.requestProcessTime.getTotalTime() / this.requestProcessTime.getCount();
    }

    private void incrementStatsCounter(int statusCode) {
        switch (statusCode) {
            case 200: {
                this.count200.increment();
                break;
            }
            case 302: {
                this.count302.increment();
                break;
            }
            case 304: {
                this.count304.increment();
                break;
            }
            case 400: {
                this.count400.increment();
                break;
            }
            case 401: {
                this.count401.increment();
                break;
            }
            case 403: {
                this.count403.increment();
                break;
            }
            case 404: {
                this.count404.increment();
                break;
            }
            case 503: {
                this.count503.increment();
                break;
            }
        }
        if (200 <= statusCode && statusCode <= 299) {
            this.count2xx.increment();
        } else if (300 <= statusCode && statusCode <= 399) {
            this.count3xx.increment();
        } else if (400 <= statusCode && statusCode <= 499) {
            this.count4xx.increment();
        } else if (500 <= statusCode && statusCode <= 599) {
            this.count5xx.increment();
        } else {
            this.countOther.increment();
        }
        if (statusCode >= 400) {
            this.errorCount.increment();
        }
    }
}

