/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.web.admin.monitor.HttpServiceStatsProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service(name="http-service")
@Scoped(value=Singleton.class)
public class HttpServiceStatsProviderBootstrap
implements PostConstruct {
    @Inject
    private Logger logger;
    @Inject
    private static Domain domain;
    private boolean httpServiceMonitoringEnabled = false;
    private static HttpService httpService;
    private static NetworkConfig networkConfig;

    public void postConstruct() {
        Level dbgLevel = Level.FINEST;
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == null || dbgLevel.intValue() < defaultLevel.intValue()) {
            // empty if block
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("****** [Monitor]In the HttpServiceStatsProvider bootstrap ************");
        }
        List lc = domain.getConfigs().getConfig();
        Config config = null;
        for (Config cf : lc) {
            if (!cf.getName().equals("server-config")) continue;
            config = cf;
            break;
        }
        httpService = config.getHttpService();
        networkConfig = config.getNetworkConfig();
        for (VirtualServer vs : httpService.getVirtualServer()) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("**** Registering a new StatsProvider");
            }
            StatsProviderManager.register("http-service", PluginPoint.SERVER, "http-service/" + vs.getId() + "/request", new HttpServiceStatsProvider(vs.getId()));
        }
    }

    private boolean getEnabledValue(String enabledStr) {
        return !"OFF".equals(enabledStr);
    }

    public static String getVirtualServer(String hostName, String listenerPort) {
        try {
            if (hostName == null) {
                return null;
            }
            if (hostName.equals("localhost")) {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            NetworkListener listener = null;
            for (NetworkListener hl : networkConfig.getNetworkListeners().getNetworkListener()) {
                if (!hl.getPort().equals(listenerPort)) continue;
                listener = hl;
                break;
            }
            VirtualServer virtualServer = null;
            for (VirtualServer vs : httpService.getVirtualServer()) {
                if (!vs.getHosts().contains(hostName) || !vs.getNetworkListeners().contains(listener.getName())) continue;
                virtualServer = vs;
            }
            return virtualServer.getId();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(HttpServiceStatsProviderBootstrap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    static {
        httpService = null;
        networkConfig = null;
    }
}

