/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.net.NetUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="start-domain")
@Scoped(value=PerLookup.class)
public class StartDomainCommand
extends LocalDomainCommand {
    private GFLauncherInfo info;
    private GFLauncher launcher;
    private boolean verbose;
    private boolean upgrade;
    private boolean debug;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartDomainCommand.class);
    private static final int DEATH_TIMEOUT_MS = 300000;

    @Override
    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        StartDomainCommand.addOption(opts, "debug", '\u0000', "BOOLEAN", false, "false");
        StartDomainCommand.addOption(opts, "domaindir", '\u0000', "STRING", false, null);
        StartDomainCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        StartDomainCommand.addOption(opts, "upgrade", '\u0000', "BOOLEAN", false, "false");
        StartDomainCommand.addOption(opts, "verbose", 'v', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 1;
        this.processProgramOptions();
    }

    @Override
    protected int executeCommand() throws CommandException {
        this.verbose = this.getBooleanOption("verbose");
        this.upgrade = this.getBooleanOption("upgrade");
        this.debug = this.getBooleanOption("debug");
        String gfejar = System.getenv("GFE_JAR");
        if (gfejar != null && gfejar.length() > 0) {
            return this.runCommandEmbedded();
        }
        return this.runCommandNotEmbedded();
    }

    private int runCommandNotEmbedded() throws CommandException {
        try {
            String parent;
            this.launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.domain);
            this.info = this.launcher.getInfo();
            if (!this.operands.isEmpty()) {
                this.info.setDomainName((String)this.operands.get(0));
            }
            if ((parent = (String)this.options.get("domaindir")) != null) {
                this.info.setDomainParentDir(parent);
            }
            this.info.setVerbose(this.verbose || this.upgrade);
            this.info.setDebug(this.debug);
            this.info.setUpgrade(this.upgrade);
            this.info.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.programOpts.getProgramArguments());
            this.launcher.setup();
            if (Boolean.getBoolean("AS_RESTART")) {
                new DeathWaiter();
            } else {
                String err = this.adminPortInUse();
                if (err != null) {
                    logger.printWarning(err);
                    return 1;
                }
            }
            this.setMasterPassword(this.info);
            this.launcher.launch();
            if (this.verbose || this.upgrade) {
                while (this.launcher.getExitValue() == 10) {
                    logger.printMessage(strings.get("restart"));
                    if (CLIConstants.debugMode) {
                        System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                    }
                    this.launcher.relaunch();
                }
                return this.launcher.getExitValue();
            }
            this.waitForDAS(this.info.getAdminPorts());
            this.report();
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException(me);
        }
    }

    private void setMasterPassword(GFLauncherInfo info) throws CommandException {
        boolean ok;
        String mpn = "AS_ADMIN_MASTERPASSWORD";
        String mpv = (String)this.passwords.get(mpn);
        if (mpv == null) {
            mpv = this.checkMasterPasswordFile();
        }
        if (mpv == null) {
            mpv = "changeit";
        }
        if (!(ok = this.verifyMasterPassword(mpv))) {
            mpv = this.retry(3);
        }
        info.addSecurityToken(mpn, mpv);
    }

    private String retry(int times) throws CommandException {
        logger.printMessage("No valid master password found");
        for (int i = 0; i < times; ++i) {
            String prompt = "Enter master password (" + (times - i) + " attempt(s) remain)> ";
            String mpv = super.readPassword(prompt);
            if (mpv == null) {
                throw new CommandException("No console, no prompting possible");
            }
            if (this.verifyMasterPassword(mpv)) {
                return mpv;
            }
            logger.printMessage("Sorry, incorrect master password, retry");
        }
        throw new CommandException("Number of attempts (" + times + ") exhausted, giving up");
    }

    private int runCommandEmbedded() throws CommandException {
        try {
            this.launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.embedded);
            this.info = this.launcher.getInfo();
            if (!this.operands.isEmpty()) {
                this.info.setDomainName((String)this.operands.get(0));
            } else {
                this.info.setDomainName("domain1");
            }
            String parent = (String)this.options.get("domaindir");
            if (parent != null) {
                this.info.setDomainParentDir(parent);
            } else {
                this.info.setDomainParentDir(System.getenv("S1AS_HOME") + "/domains");
            }
            this.info.setVerbose(this.verbose);
            this.info.setDebug(this.debug);
            this.launcher.setup();
            Set ports = this.info.getAdminPorts();
            if (this.isServerAlive(ports)) {
                throw new CommandException("The Admin port is already taken: ");
            }
            this.launcher.launch();
            this.waitForDAS(ports);
            this.report();
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException(me);
        }
    }

    private void waitForDAS(Set<Integer> ports) throws CommandException {
        if (ports == null || ports.size() <= 0) {
            String msg = strings.get("noPorts");
            throw new CommandException(strings.get("CommandUnSuccessfulWithArg", new Object[]{this.name, msg}));
        }
        long startWait = System.currentTimeMillis();
        logger.printDetailMessage(strings.get("WaitDAS"));
        boolean alive = false;
        block5: while (!this.timedOut(startWait)) {
            for (int port : ports) {
                if (!this.isServerAlive(port)) continue;
                alive = true;
                break block5;
            }
            try {
                Process p = this.launcher.getProcess();
                int exitCode = p.exitValue();
                ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
                String output = psd.getOutErrString();
                if (StartDomainCommand.ok(output)) {
                    throw new CommandException(strings.get("dasDiedOutput", new Object[]{this.info.getDomainName(), exitCode, output}));
                }
                throw new CommandException(strings.get("dasDied", new Object[]{this.info.getDomainName(), exitCode}));
            }
            catch (GFLauncherException ex) {
            }
            catch (IllegalThreadStateException ex) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        }
        if (!alive) {
            String msg = strings.get("dasNoStart", new Object[]{this.info.getDomainName(), 600L});
            throw new CommandException(msg);
        }
    }

    private boolean isServerAlive(int port) {
        logger.printDebugMessage("Check if server is alive on port " + port);
        this.programOpts.setPort(port);
        this.programOpts.setInteractive(false);
        return DASUtils.pingDASQuietly(this.programOpts, this.env);
    }

    private boolean isServerAlive(Set<Integer> ports) {
        if (ports == null || ports.size() == 0) {
            return false;
        }
        return this.isServerAlive(ports.iterator().next());
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 600000L;
    }

    private void report() {
        String logfile;
        try {
            logfile = this.launcher.getLogFilename();
        }
        catch (GFLauncherException ex) {
            logfile = "UNKNOWN";
        }
        logger.printMessage(strings.get("DomainLocation", new Object[]{this.info.getDomainName(), this.info.getDomainRootDir().getAbsolutePath(), logfile}));
        Integer ap = -1;
        try {
            ap = (Integer)this.info.getAdminPorts().iterator().next();
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.printMessage(strings.get("DomainAdminPort", new Object[]{Integer.toString(ap)}));
        if (this.debug) {
            int debugPort = this.launcher.getDebugPort();
            if (debugPort > 0) {
                logger.printMessage(strings.get("DomainDebugPort", new Object[]{Integer.toString(debugPort)}));
            } else {
                logger.printMessage(strings.get("DomainDebugPort", new Object[]{"UNKNOWN"}));
            }
        }
    }

    private String adminPortInUse() {
        Set adminPorts = this.info.getAdminPorts();
        return this.adminPortInUse(adminPorts);
    }

    private String adminPortInUse(Set<Integer> adminPorts) {
        for (Integer port : adminPorts) {
            if (NetUtils.isPortFree((int)port)) continue;
            return strings.get("ServerRunning", new Object[]{port.toString()});
        }
        return null;
    }

    private void debug(String s) {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream("startdomain.txt", true));
            ps.println(new Date().toString() + ":  " + s);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private class DeathWaiter
    implements Runnable {
        boolean success = false;

        public void run() {
            try {
                while (System.in.read() >= 0) {
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            Set adminPorts = StartDomainCommand.this.info.getAdminPorts();
            while (StartDomainCommand.this.adminPortInUse(adminPorts) != null) {
            }
            this.success = true;
        }

        public DeathWaiter() throws CommandException {
            try {
                Thread t = new Thread(this);
                t.start();
                t.join(300000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.success) {
                throw new CommandException(strings.get("deathwait_timeout", new Object[]{300000}));
            }
        }
    }
}

